/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.server.*;

import jp.ossc.nimbus.beans.MethodEditor;
import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.aop.invoker.*;
import jp.ossc.nimbus.service.performance.ResourceUsage;
import jp.ossc.nimbus.service.repository.*;
import jp.ossc.nimbus.service.distribute.ClusterService;
import jp.ossc.nimbus.service.distribute.KeepAliveListener;

/**
 * [gĂяoT[oT[rXB<p>
 * {@link RemoteServerInvoker}C^tF[XIuWFNgJNDIɃoChB<br>
 * {@link RemoteServerInvoker}C^tF[X̎NX́AC^[Zv^ݍދ@\AT[rX̌Ăяo@JX^}CY@\B<br>
 * T[rX̌Ăяos{@link Invoker}̃ftHgNX́A{@link MethodReflectionCallInvokerService}ŁAĂяoReLXg{@link jp.ossc.nimbus.service.aop.InvocationContext#getTargetObject() InvocationContext.getTargetObject()}Ŏ擾T[rX̃T[rXĂяoB<br>
 * InvocationContext.getTargetObject()ŃT[rX擾łȂꍇ́A{@link #setRemoteServiceName(ServiceName)}Őݒ肳ꂽT[rX̃T[rXĂяoB<br>
 *
 * @author M.Takata
 * @deprecated ʂ̃NXɒu܂B{@link ProxyServerService}
 */
public class RemoteServiceServerService extends ServiceBase
 implements RemoteServiceServerServiceMBean{
    
    private static final long serialVersionUID = -1165545167180777753L;
    
    private ServiceName remoteServiceName;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private MethodReflectionCallInvokerService defaultInvoker;
    private ServiceName interceptorChainFactoryServiceName;
    private InterceptorChainFactory interceptorChainFactory;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String jndiName;
    private int rmiPort;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private ServiceName resourceUsageServiceName;
    private ResourceUsage<Comparable<?>> resourceUsage;
    private ServiceName clientSocketFactoryServiceName;
    private RMIClientSocketFactory clientSocketFactory;
    private ServiceName serverSocketFactoryServiceName;
    private RMIServerSocketFactory serverSocketFactory;
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setRemoteServiceName(ServiceName name){
        remoteServiceName = name;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getRemoteServiceName(){
        return remoteServiceName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setInterceptorChainListServiceName(ServiceName name){
        interceptorChainListServiceName = name;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getInterceptorChainListServiceName(){
        return interceptorChainListServiceName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setInvokerServiceName(ServiceName name){
        invokerServiceName = name;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getInvokerServiceName(){
        return invokerServiceName;
    }
    
    // RemoteServiceServerServiceMBean
    public void setInterceptorChainFactoryServiceName(ServiceName name){
        interceptorChainFactoryServiceName = name;
    }
    // RemoteServiceServerServiceMBean
    public ServiceName getInterceptorChainFactoryServiceName(){
        return interceptorChainFactoryServiceName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setJndiName(String name){
        jndiName = name;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public String getJndiName(){
        return jndiName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setJndiRepositoryServiceName(ServiceName name){
        jndiRepositoryServiceName = name;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getJndiRepositoryServiceName(){
        return jndiRepositoryServiceName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setRMIPort(int port){
        rmiPort = port;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public int getRMIPort(){
        return rmiPort;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setClusterServiceName(ServiceName name){
        clusterServiceName = name;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getClusterServiceName(){
        return clusterServiceName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setResourceUsageServiceName(ServiceName name){
        resourceUsageServiceName = name;
    }
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getResourceUsageServiceName(){
        return resourceUsageServiceName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setRMIClientSocketFactoryServiceName(ServiceName name){
        clientSocketFactoryServiceName = name;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getRMIClientSocketFactoryServiceName(){
        return clientSocketFactoryServiceName;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public void setRMIServerSocketFactoryServiceName(ServiceName name){
        serverSocketFactoryServiceName = name;
    }
    
    // RemoteServiceServerServiceMBeanJavaDoc
    public ServiceName getRMIServerSocketFactoryServiceName(){
        return serverSocketFactoryServiceName;
    }
    
    public void setRMIClientSocketFactory(RMIClientSocketFactory csf){
        clientSocketFactory = csf;
    }
    
    public void setRMIServerSocketFactory(RMIServerSocketFactory ssf){
        serverSocketFactory = ssf;
    }
    
    public void setResourceUsage(ResourceUsage<Comparable<?>> usage){
        resourceUsage = usage;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        if(resourceUsage == null && resourceUsageServiceName != null){
            resourceUsage = ServiceManagerFactory
                .getServiceObject(resourceUsageServiceName);
        }
        if(interceptorChainFactoryServiceName != null){
            interceptorChainFactory = (InterceptorChainFactory)ServiceManagerFactory
                    .getServiceObject(interceptorChainFactoryServiceName);
        }else if(getInvokerServiceName() == null){
            if(defaultInvoker == null){
                defaultInvoker = new MethodReflectionCallInvokerService();
                defaultInvoker.create();
                defaultInvoker.start();
            }else{
                defaultInvoker.start();
            }
        }else{
            @SuppressWarnings("unused")
            Invoker invoker = (Invoker)ServiceManagerFactory
                .getServiceObject(getInvokerServiceName());
            defaultInvoker = null;
        }
        
        if(jndiRepositoryServiceName == null){
            throw new IllegalArgumentException(
                "jndiRepositoryServiceName must be specified."
            );
        }
        
        if(jndiName == null && remoteServiceName == null){
            throw new IllegalArgumentException(
                "jndiName or remoteServiceName must be specified."
            );
        }
        
        if(jndiName == null){
            jndiName = remoteServiceName.getServiceManagerName()
                 + '/' + remoteServiceName.getServiceName();
        }
        jndiRepository = ServiceManagerFactory
            .getServiceObject(jndiRepositoryServiceName);
        RemoteServerInvokerImpl serverInvoker = null;
        if(interceptorChainFactory == null){
            serverInvoker = new RemoteServerInvokerImpl(
                interceptorChainListServiceName,
                invokerServiceName,
                defaultInvoker,
                remoteServiceName,
                resourceUsage,
                rmiPort,
                clientSocketFactory != null ? clientSocketFactory
                    : (clientSocketFactoryServiceName != null ? (RMIClientSocketFactory)ServiceManagerFactory.getServiceObject(clientSocketFactoryServiceName)
                        : null),
                serverSocketFactory != null ? serverSocketFactory
                    : (serverSocketFactoryServiceName != null ? (RMIServerSocketFactory)ServiceManagerFactory.getServiceObject(serverSocketFactoryServiceName)
                        : null)
            );
        }else{
            serverInvoker = new RemoteServerInvokerImpl(
                interceptorChainFactory,
                remoteServiceName,
                resourceUsage,
                rmiPort,
                clientSocketFactory != null ? clientSocketFactory
                    : (clientSocketFactoryServiceName != null ? (RMIClientSocketFactory)ServiceManagerFactory.getServiceObject(clientSocketFactoryServiceName)
                        : null),
                serverSocketFactory != null ? serverSocketFactory
                    : (serverSocketFactoryServiceName != null ? (RMIServerSocketFactory)ServiceManagerFactory.getServiceObject(serverSocketFactoryServiceName)
                        : null)
            );
        }
        if(!jndiRepository.register(jndiName, serverInvoker)){
            throw new Exception("Could not register in jndiRepository.");
        }
        if(clusterServiceName != null){
            cluster = ServiceManagerFactory.getServiceObject(clusterServiceName);
            if(cluster.isJoin()){
                throw new IllegalArgumentException("ClusterService already join.");
            }
            cluster.setOption(
                (Serializable)new RemoteServiceClientInvoker(
                    (RemoteServerInvoker)RemoteObject.toStub(serverInvoker)
                )
            );
            cluster.join();
        }
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    public void stopService() throws Exception{
        if(defaultInvoker != null){
            defaultInvoker.stop();
        }
        if(cluster != null){
            cluster.leave();
            cluster = null;
        }
        jndiRepository.unregister(jndiName);
    }
    
    /**
     * T[rX̔jsB<p>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    public void destroyService() throws Exception{
        if(defaultInvoker != null){
            defaultInvoker.destroy();
            defaultInvoker = null;
        }
    }
    
    /**
     * {@link RemoteServerInvoker}NXB<p>
     * ĂяoReLXgA܂́A{@link RemoteServiceServerService#getRemoteServiceName()}ŁAĂяoΏۂ̃T[rX肵āA[J{@link ServiceManager}ĂяoΏۂ̃T[rX擾āAĂяoB<br>
     * ܂AC^[Zv^ݍދ@\AT[rX̌Ăяo@JX^}CY@\B<br>
     *
     * @author M.Takata
     */
    public static class RemoteServerInvokerImpl extends UnicastRemoteObject
     implements RemoteServerInvoker{
        
        private static final long serialVersionUID = -2397154705661936441L;
        
        private final ServiceName interceptorChainListServiceName;
        private final ServiceName invokerServiceName;
        private final Invoker defaultInvoker;
        private final ServiceName remoteServiceName;
        private final InterceptorChainFactory interceptorChainFactory;
        private final ResourceUsage<Comparable<?>> resourceUsage;
        
        /**
         * CX^X𐶐B<p>
         *
         * @param interceptorChainFactory {@link InterceptorChainFactory}T[rX̃T[rX
         * @param remoteServiceName [gĂяoT[rX̃T[rX
         * @param port RMI|[gԍ
         * @param csf RMIClientSocketFactory
         * @param ssf RMIServerSocketFactory
         * @exception java.rmi.RemoteException IuWFNg̃GNX|[gsꍇ
         */
        public RemoteServerInvokerImpl(
            InterceptorChainFactory interceptorChainFactory,
            ServiceName remoteServiceName,
            ResourceUsage<Comparable<?>> resourceUsage,
            int port,
            RMIClientSocketFactory csf,
            RMIServerSocketFactory ssf
        ) throws java.rmi.RemoteException{
            super(port, csf, ssf);
            this.interceptorChainListServiceName = null;
            this.invokerServiceName = null;
            this.defaultInvoker = null;
            this.interceptorChainFactory = interceptorChainFactory;
            this.remoteServiceName = remoteServiceName;
            this.resourceUsage = resourceUsage;
        }
        
        /**
         * CX^X𐶐B<p>
         *
         * @param interceptorChainListServiceName {@link InterceptorChainList}T[rX̃T[rX
         * @param invokerServiceName {@link Invoker}T[rX̃T[rX
         * @param defaultInvoker ftHg{@link Invoker}T[rX
         * @param remoteServiceName [gĂяoT[rX̃T[rX
         * @param port RMI|[gԍ
         * @param csf RMIClientSocketFactory
         * @param ssf RMIServerSocketFactory
         * @exception java.rmi.RemoteException IuWFNg̃GNX|[gsꍇ
         */
        public RemoteServerInvokerImpl(
            ServiceName interceptorChainListServiceName,
            ServiceName invokerServiceName,
            Invoker defaultInvoker,
            ServiceName remoteServiceName,
            ResourceUsage<Comparable<?>> resourceUsage,
            int port,
            RMIClientSocketFactory csf,
            RMIServerSocketFactory ssf
        ) throws java.rmi.RemoteException{
            super(port, csf, ssf);
            this.interceptorChainListServiceName = interceptorChainListServiceName;
            this.invokerServiceName = invokerServiceName;
            this.defaultInvoker = defaultInvoker;
            this.remoteServiceName = remoteServiceName;
            interceptorChainFactory = null;
            this.resourceUsage = resourceUsage;
        }
        
        /**
         * [gĂяoT[rXĂяoB<p>
         * ĂяoReLXg{@link jp.ossc.nimbus.service.aop.InvocationContext#getTargetObject() InvocationContext.getTargetObject()}Ŏ擾T[rX̃T[rX[J{@link ServiceManager}擾āA{@link jp.ossc.nimbus.service.aop.InvocationContext#setTargetObject(Object) InvocationContext.setTargetObject(Object)}ŁAĂяoReLXgɐݒ肷B<br>
         * InvocationContext.getTargetObject()ŃT[rX擾łȂꍇ́A{@link RemoteServiceServerService#setRemoteServiceName(ServiceName)}Őݒ肳ꂽT[rX̃T[rX擾āAĂяoReLXgɐݒ肷B<br>
         * ̌ARXgN^Ŏw肳ꂽ{@link InterceptorChainList}{@link Invoker}A{@link InterceptorChain}𐶐āAĂяoB<br>
         * 
         * @param context ĂяoReLXg
         * @return T[rX̌Ăяo
         * @exception Exception [gĂяoT[rX̌ĂяoɎsꍇ
         */
        public Object invoke(InvocationContext context) throws Exception{
            
            InterceptorChain chain = null;
            if(interceptorChainFactory == null){
                chain = new DefaultInterceptorChain(
                    interceptorChainListServiceName,
                    invokerServiceName
                );
                if(invokerServiceName == null && defaultInvoker != null){
                    ((DefaultInterceptorChain)chain).setInvoker(defaultInvoker);
                }
            }else{
                StringBuilder key = new StringBuilder();
                Object target = context.getTargetObject();
                if(target != null){
                    key.append(target);
                }
                if(context instanceof MethodInvocationContext){
                    Method method = ((MethodInvocationContext)context).getTargetMethod();
                    if(method != null){
                        final MethodEditor editor = new MethodEditor();
                        editor.setValue(method);
                        key.append(':').append(editor.getAsText());
                    }
                }
                chain = interceptorChainFactory.getInterceptorChain(key.length() == 0 ? null : key.toString());
            }
            
            ServiceName serviceName = null;
            if(context.getTargetObject() != null
                && context.getTargetObject() instanceof ServiceName){
                serviceName = (ServiceName)context.getTargetObject();
                if(remoteServiceName != null
                     && !remoteServiceName.equals(serviceName)){
                    throw new IllegalAccessException(
                        serviceName + " don't be allowed access."
                    );
                }
            }else{
                serviceName = remoteServiceName;
            }
            if(serviceName != null){
                context.setTargetObject(
                    ServiceManagerFactory.getServiceObject(serviceName)
                );
                try{
                    chain.setCurrentInterceptorIndex(-1);
                    return chain.invokeNext(context);
                }catch(Exception e){
                    throw e;
                }catch(Throwable e){
                    e.printStackTrace();
                    return null;
                }finally{
                    chain.setCurrentInterceptorIndex(-1);
                }
            }else{
                throw new ServiceNotFoundException(null);
            }
        }
        
        public boolean isAlive(ServiceName name){
            ServiceName serviceName = remoteServiceName;
            if(name != null){
                if(remoteServiceName != null
                     && !remoteServiceName.equals(name)){
                    return false;
                }
                serviceName = name;
            }
            if(serviceName == null){
                return true;
            }else{
                try{
                    final Service service = ServiceManagerFactory.getService(serviceName);
                    return service != null && service.getState() == State.STARTED;
                }catch(ServiceNotFoundException e){
                    return false;
                }
            }
        }

        @SuppressWarnings("unchecked")
        @Override
        public <T extends Comparable<?>> T getResourceUsage(){
            return resourceUsage == null ? null : (T)resourceUsage.getUsage();
        }
     }
    
    public static class RemoteServiceClientInvoker implements KeepAliveCheckInvoker, Serializable{
        
        private static final long serialVersionUID = 7098276664964190910L;
        private RemoteServerInvoker serverInvoker;
        
        public RemoteServiceClientInvoker(){
        }
        
        public RemoteServiceClientInvoker(RemoteServerInvoker server){
            serverInvoker = server;
        }
        
        // KeepAliveCheckInvokerJavaDoc
        public Object invoke(InvocationContext context) throws Throwable{
            try{
                return serverInvoker.invoke(context);
            }catch(java.rmi.RemoteException e){
                throw new InvokeException(e);
            }
        }
        
        // KeepAliveCheckInvokerJavaDoc
        public boolean isAlive(){
            try{
                return serverInvoker.isAlive(null);
            }catch(Exception e){
                return false;
            }
        }
        
        // KeepAliveCheckInvokerJavaDoc
        public void addKeepAliveListener(KeepAliveListener listener){
            throw new UnsupportedOperationException();
        }
        
        // KeepAliveCheckInvokerJavaDoc
        public void removeKeepAliveListener(KeepAliveListener listener){
            throw new UnsupportedOperationException();
        }
        
        // KeepAliveCheckInvokerJavaDoc
        public void clearKeepAliveListener(){
            throw new UnsupportedOperationException();
        }
        public <T extends Comparable<?>> T getResourceUsage(){
            try{
                return serverInvoker.getResourceUsage();
            }catch(Exception e){
                return null;
            }
        }
    }
}