/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;
import java.io.Serializable;
import java.net.UnknownHostException;

import jp.ossc.nimbus.net.GlobalUID;

/**
 * {@link ClientConnection}O[sOClientConnectionC^tF[XNXB<p>
 * 
 * @author M.Takata
 */
public class DistributedClientConnectionImpl implements ClientConnection, Serializable{
    
    private static final long serialVersionUID = -582594445717006869L;

    private List<ClientConnection> connectionList = new ArrayList<ClientConnection>();
    
    private Object id;
    private transient String serviceManagerName;
    
    public void addClientConnection(ClientConnection connection){
        connectionList.add(connection);
    }
    
    public void setServiceManagerName(String name){
        serviceManagerName = name;
    }
    
    public void connect() throws ConnectException{
        connect(null);
    }
    
    public void connect(Object id) throws ConnectException{
        if(id == null){
            try{
                this.id = new GlobalUID();
            }catch(UnknownHostException e){
                throw new ConnectException(e);
            }
        }else{
            this.id = id;
        }
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            ClientConnection connection = connectionList.get(i);
            connection.setServiceManagerName(serviceManagerName);
            connection.connect(this.id);
        }
    }
    
    public void addSubject(String subject) throws MessageSendException{
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            connectionList.get(i).addSubject(subject);
        }
    }
    
    public void addSubject(String subject, String[] keys) throws MessageSendException{
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            connectionList.get(i).addSubject(subject, keys);
        }
    }
    
    public void removeSubject(String subject) throws MessageSendException{
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            connectionList.get(i).removeSubject(subject);
        }
    }
    
    public void removeSubject(String subject, String[] keys) throws MessageSendException{
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            connectionList.get(i).removeSubject(subject, keys);
        }
    }
    
    public void startReceive() throws MessageSendException{
        startReceive(-1);
    }
    
    public void startReceive(long from) throws MessageSendException{
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            connectionList.get(i).startReceive(from);
        }
    }
    
    public boolean isStartReceive(){
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            if(!connectionList.get(i).isStartReceive()){
                return false;
            }
        }
        return true;
    }
    
    public void stopReceive() throws MessageSendException{
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            connectionList.get(i).stopReceive();
        }
    }
    
    public Set<String> getSubjects(){
        final Set<String> result = new HashSet<String>();
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            result.addAll(connectionList.get(i).getSubjects());
        }
        return result;
    }
    
    public Set<String> getKeys(String subject){
        final Set<String> result = new HashSet<String>();
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            result.addAll(connectionList.get(i).getKeys(subject));
        }
        return result;
    }
    
    public void setMessageListener(MessageListener listener){
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            connectionList.get(i).setMessageListener(listener);
        }
    }
    
    public boolean isConnected(){
        return id != null;
    }
    
    public Object getId(){
        if(connectionList == null || connectionList.size() == 0){
            return id;
        }
        List<Object> result = new ArrayList<Object>();
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            ClientConnection connection = connectionList.get(i);
            if(connection.getId() != null){
                result.add(connection.getId());
            }
        }
        return result.size() == 0 ? id : result;
    }
    
    public void close(){
        for(int i = 0, imax = connectionList.size(); i < imax; i++){
            try{
                connectionList.get(i).close();
            }catch(RuntimeException e){
            }
        }
    }
    
    public String toString(){
        final StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('{');
        buf.append("id=").append(id);
        buf.append(", connectionList=").append(connectionList);
        buf.append('}');
        return buf.toString();
    }
}