/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.queue;

import java.util.Map;
import java.util.HashMap;

import jp.ossc.nimbus.service.context.Context;

/**
 * 񓯊sReLXgB<p>
 *
 * @author M.Takata
 */
public class AsynchContext<I, O> implements java.io.Serializable{
    
    private static final long serialVersionUID = 1707869608895589769L;
    
    protected I input;
    protected O output;
    protected Throwable throwable;
    protected Queue<AsynchContext<I, O>> responseQueue;
    protected Map<Object, Object> threadContext;
    protected boolean isCancel;
    
    public AsynchContext(){
    }
    
    public AsynchContext(I input){
        this.input = input;
    }
    
    public AsynchContext(I input, Queue<AsynchContext<I, O>> queue){
        this.input = input;
        responseQueue = queue;
    }
    
    public void setInput(I input){
        this.input = input;
    }
    public I getInput(){
        return input;
    }
    
    public boolean isCancel(){
        return isCancel;
    }
    public void cancel(){
        isCancel = true;
    }
    
    public void setResponseQueue(Queue<AsynchContext<I, O>> queue){
        responseQueue = queue;
    }
    public Queue<AsynchContext<I, O>> getResponseQueue(){
        return responseQueue;
    }
    
    public void setOutput(O output){
        this.output = output;
    }
    public O getOutput(){
        return output;
    }
    
    public void response(){
        if(responseQueue != null){
            responseQueue.push(this);
        }
    }
    
    public void checkError() throws Throwable{
        if(throwable != null){
            throw throwable;
        }
    }
    
    public void setThrowable(Throwable th){
        throwable = th;
    }
    public Throwable getThrowable(){
        return throwable;
    }
    
    public void putThreadContext(Object key, Object value){
        if(threadContext == null){
            threadContext = new HashMap<Object, Object>();
        }
        threadContext.put(key, value);
    }
    
    public <K, V> void putThreadContextAll(Context<K, V> context){
        if(threadContext == null){
            threadContext = new HashMap<Object, Object>();
        }
        threadContext.putAll(context);
    }
    
    @SuppressWarnings("unchecked")
    public <K, V> void applyThreadContext(Context<K, V> context){
        if(threadContext != null){
            context.putAll((Map<? extends K, ? extends V>)threadContext);
        }
    }
    
    public String toString(){
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append('{');
        buf.append("input=").append(input);
        buf.append(", output=").append(output);
        buf.append(", throwable=").append(throwable);
        buf.append(", isCancel=").append(isCancel);
        buf.append('}');
        return buf.toString();
    }
}