/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Date;

/**
 * XPW[B<p>
 *
 * @author M.Takata
 */
public interface Schedule extends Comparable<Schedule>{
    
    /**
     * XPW[̏ԁFB<p>
     */
    public static final int STATE_INITIAL = 1;
    
    /**
     * XPW[̏ԁFB<p>
     */
    public static final int STATE_ENTRY   = 2;
    
    /**
     * XPW[̏ԁFsB<p>
     */
    public static final int STATE_RUN     = 3;
    
    /**
     * XPW[̏ԁFIB<p>
     */
    public static final int STATE_END     = 4;
    
    /**
     * XPW[̏ԁFُIB<p>
     */
    public static final int STATE_FAILED  = 5;
    
    /**
     * XPW[̏ԁFꎞ~B<p>
     */
    public static final int STATE_PAUSE   = 6;
    
    /**
     * XPW[̏ԁFfB<p>
     */
    public static final int STATE_ABORT   = 7;
    
    /**
     * XPW[̏ԁFgCB<p>
     */
    public static final int STATE_RETRY   = 8;
    
    /**
     * XPW[̏ԁF`OB<p>
     */
    public static final int STATE_UNKNOWN   = -1;
    
    
    /**
     * XPW[̐ԁFԁB<p>
     */
    public static final int CONTROL_STATE_INITIAL  = 1;
    
    /**
     * XPW[̐ԁFꎞ~B<p>
     */
    public static final int CONTROL_STATE_PAUSE    = 2;
    
    /**
     * XPW[̐ԁFĊJB<p>
     */
    public static final int CONTROL_STATE_RESUME   = 3;
    
    /**
     * XPW[̐ԁFfB<p>
     */
    public static final int CONTROL_STATE_ABORT    = 4;
    
    /**
     * XPW[̐ԁF䎸sB<p>
     */
    public static final int CONTROL_STATE_FAILED   = 5;
    
    /**
     * XPW[̐ԁF`OB<p>
     */
    public static final int CONTROL_STATE_UNKNOWN  = -1;
    
    
    /**
     * XPW[̃`FbNԁFԁB<p>
     */
    public static final int CHECK_STATE_INITIAL  = 1;
    
    /**
     * XPW[̃`FbNԁF^CI[o[B<p>
     */
    public static final int CHECK_STATE_TIMEOVER  = 2;
    
    /**
     * XPW[̃`FbNԁF`OB<p>
     */
    public static final int CHECK_STATE_UNKNOWN  = -1;
    
    /**
     * XPW[ID擾B<p>
     *
     * @return XPW[ID
     */
    public String getId();
    
    /**
     * XPW[IDݒ肷B<p>
     *
     * @param id XPW[ID
     */
    public void setId(String id);
    
    /**
     * XPW[}X^ID擾B<p>
     *
     * @return XPW[}X^ID
     */
    public String getMasterId();
    
    /**
     * XPW[ꂽ擾B<p>
     *
     * @return XPW[
     */
    public Date getTime();
    
    /**
     * XPW[ꂽݒ肷B<p>
     *
     * @param time XPW[
     */
    public void setTime(Date time);
    
    /**
     * XPW[ꂽ^XN擾B<p>
     *
     * @return ^XN
     */
    public String getTaskName();
    
    /**
     * XPW[̓̓f[^擾B<p>
     *
     * @return ̓f[^
     */
    public Object getInput();
    
    /**
     * XPW[̓̓f[^ݒ肷B<p>
     *
     * @param input ̓f[^
     */
    public void setInput(Object input);
    
    /**
     * ˑXPW[}X^ID擾B<p>
     *
     * @return XPW[}X^ID̔z
     */
    public String[] getDepends();
    
    /**
     * XPW[̏ʂ擾B<p>
     *
     * @return 
     */
    public Object getOutput();
    
    /**
     * XPW[̏ʂݒ肷B<p>
     *
     * @param out 
     */
    public void setOutput(Object out);
    
    /**
     * ŏɃXPW[ꂽ擾B<p>
     *
     * @return ŏɃXPW[ꂽ
     */
    public Date getInitialTime();
    
    /**
     * XPW[gCsԊu[ms]擾B<p>
     *
     * @return gCsԊu
     */
    public long getRetryInterval();
    
    /**
     * XPW[gCI擾B<p>
     *
     * @return XPW[gCI
     */
    public Date getRetryEndTime();
    
    /**
     * gC邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇgC
     */
    public boolean isRetry();
    
    /**
     * gC邩ǂݒ肷B<p>
     *
     * @param retry gCꍇ́Atrue
     */
    public void setRetry(boolean retry);
    
    /**
     * XPW[̍őx[ms]擾B<p>
     *
     * @return XPW[őx
     */
    public long getMaxDelayTime();
    
    /**
     * XPW[̏Ԃ擾B<p>
     *
     * @return XPW[̏
     */
    public int getState();
    
    /**
     * XPW[̏Ԃݒ肷B<p>
     * ̃IuWFNgDTOł邽߁AXPW[̏ԂύXɂ́A{@link ScheduleManager#changeState(String, int)}ĂяoKvB<br>
     *
     * @param state XPW[̏
     */
    public void setState(int state);
    
    /**
     * XPW[̐Ԃ擾B<p>
     *
     * @return XPW[̐
     */
    public int getControlState();
    
    /**
     * XPW[̐Ԃݒ肷B<p>
     * ̃IuWFNgDTOł邽߁AXPW[̐ԂύXɂ́A{@link ScheduleManager#changeControlState(String, int)}ĂяoKvB<br>
     *
     * @param state XPW[̐
     */
    public void setControlState(int state);
    
    /**
     * XPW[̃`FbNԂ擾B<p>
     *
     * @return XPW[̃`FbN
     */
    public int getCheckState();
    
    /**
     * XPW[̃`FbNԂݒ肷B<p>
     *
     * @param state XPW[̃`FbN
     */
    public void setCheckState(int state);
    
    /**
     * UŎs{@link ScheduleExecutor}w肷L[ݒ肷B<p>
     *
     * @param key ScheduleExecutor肷L[
     */
    public void setExecutorKey(String key);
    
    /**
     * UŎs{@link ScheduleExecutor}w肷L[擾B<p>
     *
     * @return ScheduleExecutor肷L[
     */
    public String getExecutorKey();
    
    /**
     * {@link ScheduleExecutor}̎ނݒ肷B<p>
     *
     * @param type ScheduleExecutor̎
     */
    public void setExecutorType(String type);
    
    /**
     * {@link ScheduleExecutor}̎ނ擾B<p>
     *
     * @return ScheduleExecutor̎
     */
    public String getExecutorType();
    
    /**
     * XPW[̊Jn擾B<p>
     *
     * @return XPW[̊Jn
     */
    public Date getExecuteStartTime();
    
    /**
     * XPW[̊Jnݒ肷B<p>
     *
     * @param time XPW[̊Jn
     */
    public void setExecuteStartTime(Date time);
    
    /**
     * XPW[̏I擾B<p>
     *
     * @return XPW[̏I
     */
    public Date getExecuteEndTime();
    
    /**
     * XPW[̏Iݒ肷B<p>
     *
     * @param time XPW[̏I
     */
    public void setExecuteEndTime(Date time);
}