/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer;

import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.FormatConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

/**
 * ȈՋLqvfB<p>
 * ݒ肳ꂽl̂܂܎oȈՂȋLqvfNXłB<br>
 * {@link WritableRecord}̃ftHg̗vfłB<br>
 *
 * @author Y.Tokuda
 */
public class SimpleElement implements WritableElement, java.io.Serializable {
    
    private static final long serialVersionUID = 8510769262946215439L;
    
    protected Object key;
    
    protected Object value;
    
    protected StringConverter stringConverter;
    
    protected FormatConverter formatConverter;
    
    protected String nullString = null;
    
    /**
     * ̃CX^X𐶐B<p>
     */
    public SimpleElement(){
        key = this;
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param value ϊΏۂ̃IuWFNg
     */
    public SimpleElement(Object value){
        key = this;
        this.value = value;
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param key L[
     * @param value ϊΏۂ̃IuWFNg
     */
    public SimpleElement(Object key, Object value){
        this.key = key;
        this.value = value;
    }
    
    // WritableElementJavaDoc
    public void setKey(Object key){
        this.key = key;
    }
    
    // WritableElementJavaDoc
    public Object getKey(){
        return key == null ? this : key;
    }
    
    // WritableElementJavaDoc
    public void setValue(Object val){
        this.value = val;
    }
    
    // WritableElementJavaDoc
    public Object getValue(){
        return value;
    }
    
    /**
     * lnullɏo͂镶ݒ肷B<p>
     *
     * @param str 
     */
    public void setNullString(String str){
        nullString = str;
    }
    
    /**
     * lnullɏo͂镶擾B<p>
     *
     * @return 
     */
    public String getNullString(){
        return nullString;
    }
    
    /**
     * ϊsۂɓKpRo[^ݒ肷B<p>
     *
     * @param converter Ro[^
     */
    public void setStringConverter(StringConverter converter){
        stringConverter = converter;
    }
    
    /**
     * ϊsۂɓKpRo[^擾B<p>
     *
     * @return Ro[^
     */
    public StringConverter getStringConverter(){
        return stringConverter;
    }
    
    /**
     * ϊsۂɓKpRo[^ݒ肷B<p>
     *
     * @param converter Ro[^
     */
    public void setFormatConverter(FormatConverter converter){
        formatConverter = converter;
        formatConverter.setConvertType(FormatConverter.OBJECT_TO_STRING);
    }
    
    /**
     * ϊsۂɓKpRo[^擾B<p>
     *
     * @return Ro[^
     */
    public FormatConverter getFormatConverter(){
        return formatConverter;
    }
    
    /**
     * ̗vf̒l̂܂ܕɂĎ擾B<p>
     * 
     * @return ̗vf̒ltoString()Ăяo
     */
    public String toString(){
        if(formatConverter == null){
            return convertString(value != null ? value.toString() : nullString);
        }else{
            final String ret = (String)formatConverter.convert(value);
            return ret == null ? nullString : ret;
        }
    }
    
    protected String convertString(String str){
        String result =  str;
        if(stringConverter != null && result != null){
            try{
                result = stringConverter.convert(result);
            }catch(ConvertException e){
            }
        }
        return result;
    }
    
    /**
     * ̗vf̃IuWFNĝ܂܎擾B<p>
     * {@link #getValue()}ƓlԂB<br>
     * 
     * @return ̗vf̃IuWFNg
     */
    public Object toObject(){
        return value;
    }
}