/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.servlet;

import javax.servlet.http.*;

/**
 * BeanFlowT[ubg̎sReLXgB<p>
 * {@link BeanFlowServlet}BeanFlowĂяöƂȂIuWFNgB<p>
 *
 * @author M.Takata
 */
public class BeanFlowServletContext{
    
    /**
     * HTTPNGXgB<p>
     */
    protected HttpServletRequest request;
    
    /**
     * HTTPX|XB<p>
     */
    protected HttpServletResponse response;
    
    /**
     * ̓IuWFNgB<p>
     */
    protected Object input;
    
    /**
     * o̓IuWFNgB<p>
     */
    protected Object output;
    
    /**
     * CX^X𐶐B<p>
     *
     * @param req HTTPNGXg
     * @param resp HTTPX|X
     */
    public BeanFlowServletContext(
        HttpServletRequest req,
        HttpServletResponse resp
    ){
        request = req;
        response = resp;
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param req HTTPNGXg
     * @param resp HTTPX|X
     * @param input ̓IuWFNg
     */
    public BeanFlowServletContext(
        HttpServletRequest req,
        HttpServletResponse resp,
        Object input
    ){
        request = req;
        response = resp;
        this.input = input;
    }
    
    /**
     * HTTPNGXg擾B<p>
     * 
     * @return HTTPNGXg
     */
    public HttpServletRequest getRequest(){
        return request;
    }
    
    /**
     * HTTPX|X擾B<p>
     * 
     * @return HTTPX|X
     */
    public HttpServletResponse getResponse(){
        return response;
    }
    
    /**
     * ̓IuWFNg擾B<p>
     * 
     * @return ̓IuWFNg
     */
    public Object getInput(){
        return input;
    }
    
    /**
     * o̓IuWFNg擾B<p>
     * 
     * @return o̓IuWFNg
     */
    public Object getOutput(){
        return output;
    }
    
    /**
     * o̓IuWFNgݒ肷B<p>
     * 
     * @param output o̓IuWFNg
     */
    public void setOutput(Object output){
        this.output = output;
    }
}