/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

/**
 * LRo[^B<p>
 * <table border=5>
 *     <tr><th>pL</th><th>SpL</th></tr>
 *     <tr><td>&nbsp;</td><td>@</td></tr>
 *     <tr><td>!</td><td>I</td></tr>
 *     <tr><td>"</td><td>h</td></tr>
 *     <tr><td>#</td><td></td></tr>
 *     <tr><td>$</td><td></td></tr>
 *     <tr><td>%</td><td></td></tr>
 *     <tr><td>&amp</td><td></td></tr>
 *     <tr><td>'</td><td>f</td></tr>
 *     <tr><td>(</td><td>i</td></tr>
 *     <tr><td>)</td><td>j</td></tr>
 *     <tr><td>*</td><td></td></tr>
 *     <tr><td>+</td><td>{</td></tr>
 *     <tr><td>,</td><td>C</td></tr>
 *     <tr><td>-</td><td>|(MS932)</td></tr>
 *     <tr><td>.</td><td>D</td></tr>
 *     <tr><td>/</td><td>^</td></tr>
 *     <tr><td>:</td><td>F</td></tr>
 *     <tr><td>;</td><td>G</td></tr>
 *     <tr><td>&lt</td><td></td></tr>
 *     <tr><td>=</td><td></td></tr>
 *     <tr><td>&gt</td><td></td></tr>
 *     <tr><td>?</td><td>H</td></tr>
 *     <tr><td>@</td><td></td></tr>
 *     <tr><td>[</td><td>m</td></tr>
 *     <tr><td>\</td><td>(MS932)</td></tr>
 *     <tr><td>]</td><td>n</td></tr>
 *     <tr><td>^</td><td>O</td></tr>
 *     <tr><td>_</td><td>Q</td></tr>
 *     <tr><td>`</td><td>e</td></tr>
 *     <tr><td>{</td><td>o</td></tr>
 *     <tr><td>|</td><td>b</td></tr>
 *     <tr><td>}</td><td>p</td></tr>
 *     <tr><td>~</td><td>`</td></tr>
 * </table>
 *
 * @author M.Takata
 */
public class SymbolCharacterConverter extends HankakuZenkakuCharacterConverter
 implements java.io.Serializable{
    
    private static final long serialVersionUID = 7864849670204503111L;
    
    /**
     * [pL][SpL] ̔z
     */
    protected final static char CONV_CHARS[][] = {
        /* 0x0020 - 0x002F */
        {'\u0020','\u3000'}, // @
        {'\u0021','\uff01'}, // I
        {'\u0022','\u201d'}, // h
        {'\u0023','\uff03'}, // 
        {'\u0024','\uff04'}, // 
        {'\u0025','\uff05'}, // 
        {'\u0026','\uff06'}, // 
        {'\u005C\u0027','\u2019'}, // f
        {'\u0028','\uff08'}, // i
        {'\u0029','\uff09'}, // j
        {'\u002A','\uff0a'}, // 
        {'\u002B','\uff0b'}, // {
        {'\u002C','\uff0c'}, // C
        {'\u002D','\uff0d'}, // |  // MS932 ł̃nCtΉ
        {'\u002E','\uff0e'}, // D
        {'\u002F','\uff0f'}, // ^
        /* 0x003A - 0x0040 */
        {'\u003A','\uff1a'}, // F
        {'\u003B','\uff1b'}, // G
        {'\u003C','\uff1c'}, // 
        {'\u003D','\uff1d'}, // 
        {'\u003E','\uff1e'}, // 
        {'\u003F','\uff1f'}, // H
        {'\u0040','\uff20'}, // 
        /* 0x005B - 0x0060 */
        {'\u005B','\uff3b'}, // m
        {'\u005C\u005C','\uffe5'}, //  MS932 
        {'\u005D','\uff3d'}, // n
        {'\u005E','\uff3e'}, // O
        {'\u005F','\uff3f'}, // Q
        {'\u0060','\u2018'}, // e
        /* 0x007B - 0x007E */
        {'\u007B','\uff5b'}, // o
        {'\u007C','\uff5c'}, // b
        {'\u007D','\uff5d'}, // p
        {'\u007E','\uff5e'} // `
    };
    
    /**
     * pSpϊʂ̋LRo[^𐶐B<p>
     */
    public SymbolCharacterConverter(){
        super(HANKAKU_TO_ZENKAKU);
    }
    
    /**
     * LRo[^[𐶐B<p>
     *
     * @param type ϊ
     * @see HankakuZenkakuCharacterConverter#HANKAKU_TO_ZENKAKU
     * @see HankakuZenkakuCharacterConverter#ZENKAKU_TO_HANKAKU
     */
    public SymbolCharacterConverter(int type){
        super(type);
    }
    
    /**
     * pSpϊLN^z擾B<p>
     *
     * @return {@link #CONV_CHARS}
     */
    @Override
    protected char[][] getHankakuZenkakuChars(){
        return CONV_CHARS;
    }
}
