/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.core;

/**
 * T[rXNXMBeanC^tF[XB<p>
 * {@link ServiceBase}NXMBeanƂĎ邽߂̃C^tF[XłB<br>
 * ̃C^tF[XNX́A{@link Service}C^tF[XMBeanC^tF[XƂĔFB<br>
 * 
 * @author M.Takata
 * @see ServiceBase
 */
public interface ServiceBaseMBean extends Service{
    
    /**
     * T[rXċNB<p>
     *
     * @exception IllegalStateException T[rXԃ`FbNɎsꍇ
     * @exception Exception start()Astop()ŗOꍇ
     * @see #start()
     * @see #stop()
     */
    public void restart() throws Exception;
    
    /**
     * ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rX̖Oݒ肷B<p>
     *
     * @param name ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rX̖O
     * @see #getSystemLoggerServiceName()
     */
    public void setSystemLoggerServiceName(ServiceName name);
    
    /**
     * ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rX̖O擾B<p>
     *
     * @return ServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rX̖O
     * @see #setSystemLoggerServiceName(ServiceName)
     */
    public ServiceName getSystemLoggerServiceName();
    
    /**
     * Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX̖Oݒ肷B<p>
     *
     * @param name Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX̖O
     * @see #getSystemMessageRecordFactoryServiceName()
     */
    public void setSystemMessageRecordFactoryServiceName(ServiceName name);
    
    /**
     * Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX̖O擾B<p>
     *
     * @return Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX̖O
     * @see #setSystemMessageRecordFactoryServiceName(ServiceName)
     */
    public ServiceName getSystemMessageRecordFactoryServiceName();
}
