/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.io;

import java.io.*;
import java.util.*;

import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.beans.dataset.PropertySetException;

/**
 * CSV`̃Xg[{@link Record}ƂēǂݍReaderNXB<p>
 * <pre>
 * import java.io.*;
 * import jp.ossc.nimbus.io.CSVRecordReader;
 * import jp.ossc.nimbus.beans.dataset.Record;
 * import jp.ossc.nimbus.beans.dataset.RecordSchema;
 *
 * FileInputStream fis = new FileInputStream("sample.csv");
 * InputStreamReader isr = new InputStreamReader(fis, "UTF-8");
 * CSVRecordReader reader = new CSVRecordReader(isr);
 * Record record = new Record(":a,java.lang.String\n:b,int");
 * reader.setRecordSchema(record.getRecordSchema());
 * try{
 *     while((record = reader.readRecord(record)) != null){
 *         String a = record.getStringProperty("a");
 *         int b = record.getIntProperty("b");
 *             :
 *     }
 * }finally{
 *     reader.close();
 * }
 * </pre>
 * 
 * @author M.Takata
 */
public class CSVRecordReader extends CSVReader{
    
    private RecordSchema schema;
    private List<String> workList;
    
    /**
     * ftHg̓ǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     */
    public CSVRecordReader(){
        super();
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     */
    public CSVRecordReader(Reader reader){
        super(reader);
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param schema R[hXL[}
     */
    public CSVRecordReader(Reader reader, RecordSchema schema){
        super(reader);
        setRecordSchema(schema);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param size ǂݍ݃obt@TCY
     */
    public CSVRecordReader(int size){
        super(size);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param size ǂݍ݃obt@TCY
     */
    public CSVRecordReader(Reader reader, int size){
        super(reader, size);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param schema R[hXL[}
     * @param size ǂݍ݃obt@TCY
     */
    public CSVRecordReader(Reader reader, RecordSchema schema, int size){
        super(reader, size);
        setRecordSchema(schema);
    }
    
    /**
     * ǂݍCSV`̃XL[}ݒ肷B<p>
     *
     * @param schema XL[}
     * @see #readRecord()
     */
    public void setRecordSchema(RecordSchema schema){
        this.schema = schema;
        workList = new ArrayList<String>(schema.getPropertySize());
    }
    
    /**
     * ǂݍCSV`̃R[hXL[}擾B<p>
     *
     * @return XL[}
     */
    public RecordSchema getRecordSchema(){
        return schema;
    }
    
    /**
     * \ߐݒ肳ꂽR[hXL[}gāACSVs1sAR[hƂēǂݍށB<p>
     *
     * @return CSVvfi[R[h
     * @exception IOException o̓G[ꍇ
     * @exception PropertySetException CSV`̗vf̃p[XɎsꍇ
     * @see #setRecordSchema(RecordSchema)
     */
    public Record readRecord() throws IOException, PropertySetException{
        List<String> csv = readCSVLineList(workList);
        if(csv == null){
            return null;
        }
        Record record = new Record(getRecordSchema());
        return readRecord(record);
    }
    
    /**
     * CSVs1sAR[hƂēǂݍށB<p>
     * CSVvf̒li[郌R[hėp邽߂̃\bhłB<br>
     *
     * @param record CSVvf̒li[郌R[h
     * @return CSVvfi[R[h
     * @exception IOException o̓G[ꍇ
     * @exception PropertySetException CSV`̗vf̃p[XɎsꍇ
     */
    public Record readRecord(Record record) throws IOException, PropertySetException{
        if(workList == null){
            workList = new ArrayList<String>();
        }
        List<String> csv = readCSVLineList(workList);
        if(csv == null){
            return null;
        }
        if(record == null){
            record = new Record(getRecordSchema());
        }else{
            record.clear();
        }
        for(int i = 0, imax = csv.size(); i < imax; i++){
            String element = (String)csv.get(i);
            record.setParseProperty(i, element);
        }
        return record;
    }
    
    /**
     * ڑ̕𐶐B<p>
     *
     * @return ڑ̕
     */
    public CSVReader cloneReader(){
        return cloneReader(new CSVRecordReader());
    }
    
    /**
     * ڑ̕𐶐B<p>
     *
     * @param clone ڑ̃CX^X
     * @return ڑ̕
     */
    protected CSVReader cloneReader(CSVReader clone){
        super.cloneReader(clone);
        ((CSVRecordReader)clone).schema = schema;
        return clone;
    }
}
