/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.io;

import java.io.*;
import java.util.*;

/**
 * ċAIFileList@\tt@CB<p>
 *
 * @author H.Nakano
 */
public class RecursiveFile extends File implements Serializable{
    
    private static final long serialVersionUID = 4549749658684567046L;
    
    /**
     * ʁFt@Ĉ݌B<p>
     * ftHglB<br>
     */
    public static final int SEARCH_TYPE_FILE = 0;
    
    /**
     * ʁFfBNĝ݌B<p>
     */
    public static final int SEARCH_TYPE_DIR = 1;
    
    /**
     * ʁFt@CƃfBNg̗B<p>
     */
    public static final int SEARCH_TYPE_ALL = 2;
    
    private static final String REGEX_ESCAPE_ESCAPE = Character.toString((char)0x00);
    
    /**
     * w肳ꂽpX̃t@CCX^X𐶐B<p>
     *
     * @param pathname pX
     */
    public RecursiveFile(String pathname) {
        super(pathname);
    }
    
    /**
     * w肳ꂽpX̃t@CCX^X𐶐B<p>
     *
     * @param parent epX
     * @param child qpX
     */
    public RecursiveFile(File parent, String child) {
        super(parent, child);
    }
    
    /**
     * w肳ꂽpX̃t@CCX^X𐶐B<p>
     *
     * @param parent epX
     * @param child qpX
     */
    public RecursiveFile(String parent, String child) {
        super(parent, child);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CpX擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @return t@CpXz
     */
    public String[] listAllTree(){
        return listAllTree(SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CpX擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param searchType 
     * @return t@CpXz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public String[] listAllTree(int searchType){
        if(!isDirectory()){
            return null;
        }
        final List<File> dirList = new ArrayList<File>();
        dirList.add(this);
        final List<File> fileList = recurciveSerach(dirList, searchType);
        final String[] ret = new String[fileList.size()];
        for(int cnt = 0; cnt < ret.length; cnt++){
            File tmp = (File) fileList.get(cnt);
            ret[cnt] = tmp.getAbsolutePath();
        }
        return ret;
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^
     * @return t@CpXz
     */
    public String[] listAllTree(FilenameFilter filter){
        return listAllTree(filter, SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^
     * @param searchType 
     * @return t@CpXz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public String[] listAllTree(FilenameFilter filter, int searchType){
        if(!isDirectory()){
            return null;
        }
        final FilenameFilter[] filters = new FilenameFilter[1];
        filters[0] = filter;
        return listAllTree(filters, searchType);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^z
     * @return t@CpXz
     */
    public String[] listAllTree(FilenameFilter[] filter){
        return listAllTree(filter, SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^z
     * @param searchType 
     * @return t@CpXz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public String[] listAllTree(FilenameFilter[] filter, int searchType){
        if(!isDirectory()){
            return null;
        }
        final List<File> dirList = new ArrayList<File>();
        dirList.add(this);
        final List<File> fileList = filteringRecurciveSerach(dirList, filter, searchType);
        String[] ret = new String[fileList.size()];
        for(int cnt = 0; cnt < ret.length; cnt++){
            final File tmp = (File)fileList.get(cnt);
            ret[cnt] = tmp.getAbsolutePath();
        }
        return ret;
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@C擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @return t@Cz
     */
    public File[] listAllTreeFiles(){
        return listAllTreeFiles(SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@C擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param searchType 
     * @return t@Cz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public File[] listAllTreeFiles(int searchType){
        if(!isDirectory()){
            return null;
        }
        final List<File> dirList = new ArrayList<File>();
        dirList.add(this);
        final List<File> fileList = recurciveSerach(dirList, searchType);
        final File[] ret = new File[fileList.size()];
        for(int cnt = 0; cnt < ret.length; cnt++){
            ret[cnt] = (File)fileList.get(cnt);
        }
        return ret;
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^
     * @return t@Cz
     */
    public File[] listAllTreeFiles(FilenameFilter filter) {
        return listAllTreeFiles(filter, SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^
     * @param searchType 
     * @return t@Cz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public File[] listAllTreeFiles(FilenameFilter filter, int searchType) {
        if(!isDirectory()){
            return null;
        }
        final List<File> dirList = new ArrayList<File>();
        dirList.add(this);
        final FilenameFilter[] filters = new FilenameFilter[1];
        filters[0] = filter;
        final List<File> fileList = filteringRecurciveSerach(dirList, filters, searchType);
        final File[] ret = new File[fileList.size()];
        for(int cnt = 0; cnt < ret.length; cnt++){
            ret[cnt] = (File)fileList.get(cnt);
        }
        return ret;
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^z
     * @return t@Cz
     */
    public File[] listAllTreeFiles(FilenameFilter filter[]){
        return listAllTreeFiles(filter, SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃t@CfBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     * ̃t@CfBNgȂꍇɂ́AnullԂB
     *
     * @param filter tB^z
     * @param searchType 
     * @return t@Cz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public File[] listAllTreeFiles(FilenameFilter filter[], int searchType){
        if(!isDirectory()){
            return null;
        }
        final List<File> dirList = new ArrayList<File>();
        dirList.add(this);
        final List<File> fileList = filteringRecurciveSerach(dirList, filter, searchType);
        File[] ret = new File[fileList.size()];
        for (int cnt = 0; cnt < ret.length; cnt++) {
            ret[cnt] = (File) fileList.get(cnt);
        }
        return ret;
    }
    
    /**
     * w肳ꂽfBNgXg̊efBNgz̃TufBNg܂߂SẴt@C̃Xg擾B<p>
     *
     * @param dirList fBNg̃Xg
     * @param searchType 
     * @return t@C̃Xg
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    protected List<File> recurciveSerach(List<File> dirList, int searchType){
        final List<File> fileList = new ArrayList<File>();
        while(dirList.size() > 0){
            File dir = (File)dirList.remove(0);
            File[] list = dir.listFiles();
            if(list != null){
                for(int cnt = 0; cnt < list.length; cnt++){
                    File tmp = list[cnt];
                    final boolean isDir = tmp.isDirectory();
                    final boolean isFile = tmp.isFile();
                    if(!isDir && !isFile){
                        continue;
                    }
                    if(isDir){
                        dirList.add(tmp);
                    }
                    switch(searchType){
                    case SEARCH_TYPE_FILE:
                        if(isDir){
                            continue;
                        }
                        break;
                    case SEARCH_TYPE_DIR:
                        if(isFile){
                            continue;
                        }
                        break;
                    case SEARCH_TYPE_ALL:
                    default:
                    }
                    fileList.add(tmp);
                }
            }
        }
        return fileList;
    }
    
    /**
     * w肳ꂽfBNgXg̊efBNgz̃TufBNg܂߂SẴt@CAw肳ꂽtB^ŃtB^Oʂ擾B<p>
     *
     * @param dirList fBNg̃Xg
     * @param filter tB^z
     * @param searchType 
     * @return t@CpXz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    protected List<File> filteringRecurciveSerach(
        List<File> dirList,
        FilenameFilter[] filter,
        int searchType
    ){
        final List<File> fileList = new ArrayList<File>();
        while (dirList.size() > 0) {
            File dir = (File)dirList.remove(0);
            File[] list = dir.listFiles();
            for (int cnt = 0; cnt < list.length; cnt++) {
                File tmp = list[cnt];
                final boolean isDir = tmp.isDirectory();
                final boolean isFile = tmp.isFile();
                if(!isDir && !isFile){
                    continue;
                }
                if(isDir){
                    dirList.add(tmp);
                }
                switch(searchType){
                case SEARCH_TYPE_FILE:
                    if(isDir){
                        continue;
                    }
                    break;
                case SEARCH_TYPE_DIR:
                    if(isFile){
                        continue;
                    }
                    break;
                case SEARCH_TYPE_ALL:
                default:
                }
                boolean check = true;
                for(int fcnt = 0; fcnt < filter.length; fcnt++){
                    if(!filter[fcnt].accept(tmp.getParentFile(), tmp.getName())){
                        check = false;
                        break;
                    }
                }
                if(check){
                    fileList.add(tmp);
                }
            }
        }
        return fileList;
    }
    
    /**
     * ̃fBNgzŁAw肳ꂽK\Ɉvt@CpXz擾B<p>
     *
     * @param regexPath pX̐K\
     * @return t@CpXz
     * @see #listAllTreeFiles(String, int)
     */
    public String[] listAllTree(String regexPath){
        return listAllTree(regexPath, SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃fBNgzŁAw肳ꂽK\Ɉvt@CpXz擾B<p>
     *
     * @param regexPath pX̐K\
     * @param searchType 
     * @return t@CpXz
     * @see #listAllTreeFiles(String, int)
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public String[] listAllTree(String regexPath, int searchType){
        final File[] files = listAllTreeFiles(regexPath, searchType);
        String[] result = new String[files.length];
        for(int i = 0; i < files.length; i++){
            result[i] = files[i].getAbsolutePath();
        }
        return result;
    }
    
    /**
     * ̃fBNgzŁAw肳ꂽK\Ɉvt@Cz擾B<p>
     *
     * @param regexPath pX̐K\
     * @return t@Cz
     * @see #listAllTreeFiles(String, int)
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public File[] listAllTreeFiles(String regexPath){
        return listAllTreeFiles(regexPath, SEARCH_TYPE_FILE);
    }
    
    /**
     * ̃fBNgzŁAw肳ꂽK\Ɉvt@Cz擾B<p>
     * pX̐K\ɂ́Aʏ̐K\ɉ"**"Ƃw肪\łB<br>
     * "**"Ǝw肳ꂽꍇAȓSẴfBNg\܂ގB<br>
     * ƂāAK\̃GXP[vł"\"́AWindows OS̃pXZp[^ɂȂĂ邽߁AK\Ƃ"\"w肵ꍇ́A"\\"Ǝw肷鎖B<br>
     *
     * @param regexPath pX̐K\
     * @param searchType 
     * @return t@Cz
     * @see #SEARCH_TYPE_FILE
     * @see #SEARCH_TYPE_DIR
     * @see #SEARCH_TYPE_ALL
     */
    public File[] listAllTreeFiles(String regexPath, int searchType){
        regexPath = regexPath.replaceAll("\\\\\\\\", REGEX_ESCAPE_ESCAPE);
        final List<File> result = filteringRecurciveSerachByRegEx(
            getPath().length() == 0
                 ? new File(regexPath) : new File(this, regexPath),
            searchType,
            new ArrayList<File>()
        );
        return result.toArray(new File[result.size()]);
    }
    
    private List<File> filteringRecurciveSerachByRegEx(
        File file,
        int searchType,
        List<File> result
    ){
        if(file.exists()){
            switch(searchType){
            case SEARCH_TYPE_FILE:
                if(file.isDirectory()){
                    return result;
                }
                break;
            case SEARCH_TYPE_DIR:
                if(file.isFile()){
                    return result;
                }
                break;
            case SEARCH_TYPE_ALL:
            default:
            }
            result.add(file);
            return result;
        }
        List<String> pathList = new ArrayList<String>();
        File f = file;
        String name = null;
        do{
            name = f.getName();
            f = f.getParentFile();
            pathList.add(0, name.length() == 0 ? "/" : name);
        }while(f != null);
        
        File allDir = null;
        for(int i = 0, imax = pathList.size(); i < imax; i++){
            name = (String)pathList.get(i);
            f = new File(f, name);
            if("**".equals(name)){
                if(allDir == null){
                    allDir = f.getParentFile();
                    if(allDir == null){
                        allDir = new File(".");
                    }
                }
                if(i == imax - 1){
                    name = ".*";
                }else{
                    continue;
                }
            }
            if(allDir != null){
                RecursiveFile rootDir
                     = new RecursiveFile(allDir.getPath());
                if(i == imax - 1){
                    File[] files = rootDir.listAllTreeFiles(
                        new RegexFileFilter(
                            name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")
                        ),
                        searchType
                    );
                    if(files != null){
                        for(int j = 0; j < files.length; j++){
                            result.add(files[j]);
                        }
                    }
                }else{
                    File[] dirs = rootDir.listAllTreeFiles(
                        new RegexFileFilter(
                            name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")
                        ),
                        RecursiveFile.SEARCH_TYPE_DIR
                    );
                    if(dirs != null){
                        final StringBuilder buf = new StringBuilder();
                        for(int j = i + 1; j < imax; j++){
                            buf.append((String)pathList.get(j));
                            if(j != imax - 1){
                                buf.append('/');
                            }
                        }
                        final String path = buf.toString();
                        for(int j = 0; j < dirs.length; j++){
                            dirs[j] = new File(dirs[j], path);
                            result = filteringRecurciveSerachByRegEx(
                                dirs[j],
                                searchType,
                                result
                            );
                        }
                    }
                    break;
                }
            }else if(!f.exists()){
                File rootDir = f.getParentFile();
                if(rootDir == null){
                    rootDir = new File(".");
                }
                if(i == imax - 1){
                    File[] files = rootDir.listFiles(
                        new RegexFileFilter(
                            name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")
                        )
                    );
                    if(files != null){
                        for(int j = 0; j < files.length; j++){
                            boolean isDir = files[j].isDirectory();
                            boolean isFile = files[j].isFile();
                            if(!isDir && !isFile){
                                continue;
                            }
                            switch(searchType){
                            case SEARCH_TYPE_FILE:
                                if(isDir){
                                    continue;
                                }
                                break;
                            case SEARCH_TYPE_DIR:
                                if(isFile){
                                    continue;
                                }
                                break;
                            case SEARCH_TYPE_ALL:
                            default:
                            }
                            result.add(files[j]);
                        }
                    }
                }else{
                    File[] dirs = rootDir.listFiles(
                        new RegexFileFilter(
                            name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")
                        )
                    );
                    if(dirs != null){
                        final StringBuilder buf = new StringBuilder();
                        for(int j = i + 1; j < imax; j++){
                            buf.append((String)pathList.get(j));
                            if(j != imax - 1){
                                buf.append('/');
                            }
                        }
                        final String path = buf.toString();
                        for(int j = 0; j < dirs.length; j++){
                            if(!dirs[j].isDirectory()){
                                continue;
                            }
                            dirs[j] = new File(dirs[j], path);
                            result = filteringRecurciveSerachByRegEx(
                                dirs[j],
                                searchType,
                                result
                            );
                        }
                    }
                    break;
                }
            }
        }
        return result;
    }
    
    /**
     * ̃t@CȉċAIɍ폜B<p>
     *
     * @return Sč폜łꍇtrue
     */
    public boolean deleteAllTree(){
        return deleteAllTree(this);
    }
    
    /**
     * w肳ꂽt@CȉċAIɍ폜B<p>
     *
     * @param file 폜t@C
     * @return Sč폜łꍇtrue
     */
    public static boolean deleteAllTree(File file){
        if(!file.exists()){
            return true;
        }
        boolean result = true;
        if(file.isDirectory()){
            File[] files = file.listFiles();
            for(int i = 0; i < files.length; i++){
                result &= deleteAllTree(files[i]);
            }
            result &= file.delete();
        }else if(file.isFile()){
            result &= file.delete();
        }
        return result;
    }
}
