/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.Locale;

import jp.ossc.nimbus.core.*;

/**
 * {@link ExceptionThrowInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ExceptionThrowInterceptorService
 */
public interface ExceptionThrowInterceptorServiceMBean extends ServiceBaseMBean{
    
    /**
     * Othrow/Ȃݒ肷B<p>
     *
     * @param enabled throwꍇ́Atrue
     */
    public void setEnabled(boolean enabled);
    
    /**
     * Othrow/Ȃ𔻒肷B<p>
     *
     * @return truȅꍇAL
     */
    public boolean isEnabled();
    
    /**
     * throwO擾B<p>
     * 
     * @return throwO
     */
    public Throwable getThrowable();
    
    /**
     * throwONXݒ肷B<p>
     * 
     * @param clazz throwONX
     */
    public void setThrowableClass(Class<?> clazz);
    
    /**
     * throwONX擾B<p>
     * 
     * @return throwONX
     */
    public Class<?> getThrowableClass();
    
    /**
     * throwÕbZ[Wݒ肷B<p>
     * 
     * @param message bZ[W
     */
    public void setThrowableMessage(String message);
    
    /**
     * throwÕbZ[W擾B<p>
     * 
     * @return bZ[W
     */
    public String getThrowableMessage();
    
    /**
     * throwÕbZ[WL[ݒ肷B<p>
     * ݒ肳ꂽbZ[WL[ŁÃT[rXɐݒ肳ꂽ{@link jp.ossc.nimbus.service.message.MessageRecordFactory MessageRecordFactory}烁bZ[W擾B<br>
     * 
     * @param key bZ[WL[
     */
    public void setThrowableMessageKey(String key);
    
    /**
     * throwÕbZ[WL[擾B<p>
     * 
     * @return bZ[WL[
     */
    public String getThrowableMessageKey();
    
    /**
     * throwÕbZ[WP[ݒ肷B<p>
     * ݒ肳ꂽbZ[WP[ŁÃT[rXɐݒ肳ꂽ{@link jp.ossc.nimbus.service.message.MessageRecordFactory MessageRecordFactory}烁bZ[W擾B<br>
     * 
     * @param locale bZ[WP[
     */
    public void setThrowableMessageLocale(Locale locale);
    
    /**
     * throwÕbZ[WP[擾B<p>
     * 
     * @return bZ[WP[
     */
    public Locale getThrowableMessageLocale();
    
    /**
     * throwÕbZ[Wߍ݃p[^ݒ肷B<p>
     * ݒ肳ꂽbZ[Wߍ݃p[^ŁÃT[rXɐݒ肳ꂽ{@link jp.ossc.nimbus.service.message.MessageRecordFactory MessageRecordFactory}烁bZ[W擾B<br>
     * 
     * @param args bZ[Wߍ݃p[^
     */
    public void setThrowableMessageArgs(Object[] args);
    
    /**
     * throwÕbZ[Wߍ݃p[^擾B<p>
     * 
     * @return bZ[Wߍ݃p[^
     */
    public Object[] getThrowableMessageArgs();
}
