/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The Nimbus Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link ServletRequestInitializeInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see ServletRequestInitializeInterceptorService
 */
public interface ServletRequestInitializeInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX烊NGXgɐݒ肷L[ݒ肷B<p>
     *
     * @param keys NGXgɐݒ肷ReLXgL[̔z
     */
    public void setContextKeys(String[] keys);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX烊NGXgɐݒ肷L[擾B<p>
     *
     * @return NGXgɐݒ肷ReLXgL[̔z
     */
    public String[] getContextKeys();
    
    /**
     * NGXgɐݒ肷鑮ƃT[rX̃T[rX̃}bsOݒ肷B<p>
     *
     * @param names ƃT[rX̃}bsOzB=T[rX
     */
    public void setRequestAttributeServiceNames(Map<String, String> names);
    
    /**
     * NGXgɐݒ肷鑮ƃT[rX̃T[rX̃}bsO擾B<p>
     *
     * @return ƃT[rX̃}bsOz
     */
    public Map<String, String> getRequestAttributeServiceNames();
    
    /**
     * NGXgɐݒ肷鑮ƃIuWFNg̃}bsOݒ肷B<p>
     *
     * @param attrs ƃIuWFNg̃}bsO
     */
    public void setRequestAttributes(Map<String, Object> attrs);
    
    /**
     * NGXgɐݒ肷鑮ƃIuWFNg̃}bsO擾B<p>
     *
     * @return ƃIuWFNg̃}bsO
     */
    public Map<String, Object> getRequestAttributes();
    
    /**
     * NGXgɐݒ肷鑮ƃIuWFNgݒ肷B<p>
     *
     * @param name 
     * @param attr l
     */
    public void setRequestAttribute(String name, Object attr);
    
    /**
     * NGXgɐݒ肷IuWFNg擾B<p>
     *
     * @param name 
     * @return l
     */
    public Object getRequestAttribute(String name);
    
    /**
     * {@link #setRequestAttributeServiceNames(ServiceNameRef[])}Őݒ肳ꂽT[rX擾łȂꍇɁA{@link ServiceNotFoundException}throw邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇthrow
     */
    public boolean isThrowServiceNotFoundException();
    
    /**
     * {@link #setRequestAttributeServiceNames(ServiceNameRef[])}Őݒ肳ꂽT[rX擾łȂꍇɁA{@link ServiceNotFoundException}throw邩ǂݒ肷B<p>
     * ftHǵAtruethrowB<br>
     *
     * @param isThrow throwꍇ́Atrue
     */
    public void setThrowServiceNotFoundException(boolean isThrow);
}
