/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.Set;

import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link SharedContextService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see SharedContextService
 */
public interface SharedContextServiceMBean<K, V> extends DefaultContextServiceMBean<K, V>{
    
    /**
     * ftHg̃TuWFNgB<p>
     */
    public static final String DEFAULT_SUBJECT = "SharedContext";
    
    /**
     * NCAg[h̃TuWFNguB<p>
     */
    public static final String CLIENT_SUBJECT_SUFFIX = ".Client";
    
    /**
     * {@link jp.ossc.nimbus.service.publish.RequestConnectionFactoryService RequestConnectionFactoryService}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name RequestConnectionFactoryServiceT[rX̃T[rX
     */
    public void setRequestConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.RequestConnectionFactoryService RequestConnectionFactoryService}T[rX̃T[rX擾B<p>
     * 
     * @return RequestConnectionFactoryServiceT[rX̃T[rX
     */
    public ServiceName getRequestConnectionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.keepalive.ClusterService}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name ClusterServiceT[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.keepalive.ClusterService}T[rX̃T[rX擾B<p>
     * 
     * @return ClusterServiceT[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * NCAg[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rXݒ肷B<p>
     * ReLXgCacheMapɊi[ăf[^̂ӂꐧsꍇAݒ肷B<br>
     * 
     * @param name CacheMapT[rX̃T[rX
     */
    public void setClientCacheMapServiceName(ServiceName name);
    
    /**
     * NCAg[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rX擾B<p>
     * 
     * @return CacheMapT[rX̃T[rX
     */
    public ServiceName getClientCacheMapServiceName();
    
    /**
     * T[o[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rXݒ肷B<p>
     * ReLXgCacheMapɊi[ꍇAݒ肷B<br>
     * 
     * @param name CacheMapT[rX̃T[rX
     */
    public void setServerCacheMapServiceName(ServiceName name);
    
    /**
     * T[o[h{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rX擾B<p>
     * 
     * @return CacheMapT[rX̃T[rX
     */
    public ServiceName getServerCacheMapServiceName();
    
    /**
     * {@link SharedContextStore}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name SharedContextStoreT[rX̃T[rX
     */
    public void setSharedContextStoreServiceName(ServiceName name);
    
    /**
     * {@link SharedContextStore}T[rX̃T[rX擾B<p>
     * 
     * @return SharedContextStoreT[rX̃T[rX
     */
    public ServiceName getSharedContextStoreServiceName();
    
    /**
     * TuWFNgݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SUBJECT}B
     *
     * @param subject TuWFNg
     */
    public void setSubject(String subject);
    
    /**
     * TuWFNg擾B<p>
     *
     * @return TuWFNg
     */
    public String getSubject();
    
    /**
     * NCAg/T[o[hݒ肷B<p>
     * ftHǵAfalseŃT[o[hB<br>
     *
     * @param isClient NCAg[h̏ꍇAtrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void setClient(boolean isClient) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * NCAg/T[o[h𔻒肷B<p>
     *
     * @return truȅꍇANCAg[h
     */
    public boolean isClient();
    
    /**
     * ̃^CAEg[ms]ݒ肷B<p>
     * ftHǵA5000[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setSynchronizeTimeout(long timeout);
    
    /**
     * ̃^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getSynchronizeTimeout();
    
    /**
     * ^CAEgw肵Ȃ\bhĂяoꍇɓKp^CAEg[ms]ݒ肷B<p>
     * ftHǵA1000[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setDefaultTimeout(long timeout);
    
    /**
     * ^CAEgw肵Ȃ\bhĂяoꍇɓKp^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getDefaultTimeout();
    
    /**
     * T[rX̊Jnɑ̃ReLXgƂ̃f[^sǂݒ肷B<p>
     * ftHǵAtrueŃf[^B<br>
     *
     * @param isSynch f[^ꍇAtrue
     */
    public void setSynchronizeOnStart(boolean isSynch);
    
    /**
     * T[rX̊Jnɑ̃ReLXgƂ̃f[^sǂ𔻒肷B<p>
     *
     * @return trueꍇAf[^
     */
    public boolean isSynchronizeOnStart();
    
    /**
     * ƂȂm[ĥ݂ReLXg̕ۑsǂݒ肷B<p>
     * ftHǵAfalseŁANCAg[hȊȎSẴm[hۑB<br>
     *
     * @param isSave ƂȂm[ĥ݂ReLXg̕ۑsꍇAtrue
     */
    public void setSaveOnlyMain(boolean isSave);
    
    /**
     * ƂȂm[ĥ݂ReLXg̕ۑsǂ𔻒肷B<p>
     *
     * @return truȅꍇAƂȂm[ĥ݂ReLXg̕ۑs
     */
    public boolean isSaveOnlyMain();
    
    /**
     * T[rX̊JnɃReLXg̓ǂݍ݂sǂݒ肷B<p>
     * ftHǵAfalseœǂݍ܂ȂB<br>
     *
     * @param isLoad ǂݍ݂sꍇAtrue
     */
    public void setLoadOnStart(boolean isLoad);
    
    /**
     * T[rX̊JnɃReLXg̓ǂݍ݂sǂ𔻒肷B<p>
     *
     * @return truȅꍇAǂݍ݂s
     */
    public boolean isLoadOnStart();
    
    /**
     * ReLXg̕ۑ̑OɃXgANA邩ǂݒ肷B<p>
     * ftHǵAtrueŃNAB<br>
     *
     * @param isClear NAꍇAtrue
     */
    public void setClearBeforeSave(boolean isClear);
    
    /**
     * ReLXg̕ۑ̑OɃXgANA邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇANA
     */
    public boolean isClearBeforeSave();
    
    /**
     * ReLXgsB<p>
     * NCAg[h̏ꍇ́A[J̃ReLXgNAB܂AT[o[hŎm[h̏ꍇ́ASẴm[hɓ߂oB<br>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * ReLXgsB<p>
     * NCAg[h̏ꍇ́A[J̃ReLXgNAB܂AT[o[hŎm[h̏ꍇ́ASẴm[hɓ߂oB<br>
     *
     * @param timeout ^CAEg
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽL[̃bNJB<p>
     *
     * @param key L[
     * @return bNJłꍇ́Atrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public boolean unlock(K key) throws SharedContextSendException;
    
    /**
     * w肳ꂽL[̃bNJB<p>
     *
     * @param key L[
     * @param force tO
     * @return bNJłꍇ́Atrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public boolean unlock(K key, boolean force) throws SharedContextSendException;
    
    /**
     * L[̏W擾B<p>
     *
     * @return L[̏W
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Set<K> keySet() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * o^ĂL[̌擾B<p>
     *
     * @return L[̌
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public int size() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * Sč폜B<p>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void clear() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * Sč폜B<p>
     *
     * @param timeout ^CAEg[ms]
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * SĔ񓯊ō폜B<p>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     */
    public void clearAsynch() throws SharedContextSendException;
    
    /**
     * ReLXgǂݍ݂sB<p>
     * m[hłȂꍇAm[hɓǂݍ݂˗B<br>
     *
     * @param timeout UT[oւ̒ʐM^CAEg[ms]
     * @exception Exception ReLXgǂݍ݂Ɏsꍇ
     */
    public void load(long timeout) throws Exception;
    
    /**
     * ReLXgۑsB<p>
     * m[hłȂꍇAm[hɕۑ˗BAA{@link #setSaveOnlyMain(boolean) setSaveOnlyMain(false)}̏ꍇ́ANCAgȊO͑SĕۑB<br>
     *
     * @param timeout UT[oւ̒ʐM^CAEg[ms]
     * @exception Exception ReLXgۑɎsꍇ
     */
    public void save(long timeout) throws Exception;
    
    /**
     * m[hǂ𔻒肷B<p>
     *
     * @return m[h̏ꍇtrue
     */
    public boolean isMain();
    
    /**
     * m[hID擾B<p>
     *
     * @return m[hID
     */
    public Object getId();
    
    /**
     * m[h̃m[hID擾B<p>
     *
     * @return m[hID
     */
    public Object getMainId();
}
