/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.message;

import java.util.*;

/**
 * ObZ[WR[hT[rXB<p>
 * ObZ[WR[h̃t@C̓ǂݍ݋yъO񋟂sB<br>
 *
 * @author H.Nakano
 */
public class LogMessageRecordFactoryService
 extends DefaultMessageRecordFactoryService{
    
    private static final long serialVersionUID = -6563544086427425914L;

    protected MessageRecord createMessageRecord(){
        MessageRecord rec = new LogMessageRecordImpl();
        rec.setMessageRecordFactory(this);
        rec.setSecret(isSecret);
        rec.setSecretString(secretString);
        return rec;
    }
    
    public static class LogMessageRecordImpl extends MessageRecordImpl
     implements LogMessageRecord, java.io.Serializable{
        
        private static final long serialVersionUID = 6861222398118645636L;
        
        /** OvCIeB */
        protected int priority = -1;
        
        /** JeS */
        protected List<String> category;
        
        protected boolean isPrintStackTrace = true;
        
        public void rec2Obj(List<String> record)
         throws MessageRecordParseException{
            if(record.size() < 2){
                throw new MessageRecordParseException("Message define error. record=" + record);
            }else{
                // {f[^i[
                code = record.get(0);
                messageMap.put(C_DFAUTL_LOCALE, record.get(1));
            }
            if(record.size() > 2){
                try{
                    priority = Integer.parseInt(record.get(2));
                }catch(NumberFormatException e){}
            }
            if(record.size() > 3){
                category = new ArrayList<String>();
                final String str = record.get(3);
                if(str != null && str.length() != 0){
                    String[] categories = str.split(":");
                    for(String ctg : categories){
                        category.add(ctg);
                    }
                }
            }
            if(record.size() > 4){
                isPrintStackTrace = Boolean.valueOf(record.get(4))
                    .booleanValue();
            }
        }
         
        public boolean isPrintStackTrace(){
            return isPrintStackTrace;
        }
        
        public int getPriority(){
            return priority;
        }
        
        public void setPriority(int priority){
            this.priority = priority;
        }
        
        public List<String> getCategories(){
            if(category == null){
                return new ArrayList<String>();
            }
            return category;
        }
        
        public void setCategories(List<String> categories){
            if(category == null){
                category = new ArrayList<String>();
            }
            category.clear();
            category.addAll(categories);
        }
        
        public void addCategory(String ctg){
            if(category == null){
                category = new ArrayList<String>();
            }
            if(!category.contains(ctg)){
                category.add(ctg);
            }
        }
        
        public String toString(){
            StringBuilder buf = new StringBuilder(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(',');
            buf.append("priority=").append(priority).append(',');
            buf.append("category=").append(category).append(',');
            buf.append("isPrintStackTrace=").append(isPrintStackTrace);
            buf.append('}');
            return buf.toString();
        }
    }
}
