/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.queue.*;

/**
 * ftHgXPW[B<p>
 * XPW[{@link Queue}ɓāAXPW[fBXpb`Xbhő҂󂯁AXPW[sB<br>
 *
 * @author M.Takata
 */
public class DefaultSchedulerService extends AbstractSchedulerService
 implements DefaultSchedulerServiceMBean{
    
    private static final long serialVersionUID = 1536820942062675121L;
    protected QueueHandlerContainerService<ScheduleRequest> queueHandlerContainer;
    protected ServiceName queueServiceName;
    protected Queue<ScheduleRequest> requestQueue;
    protected int scheduleDispatcherSize = 1;
    protected boolean isDaemonScheduleDispatcher = true;
    
    // DefaultSchedulerServiceMBeanJavaDoc
    public void setQueueServiceName(ServiceName name){
        queueServiceName = name;
    }
    // DefaultSchedulerServiceMBeanJavaDoc
    public ServiceName getQueueServiceName(){
        return queueServiceName;
    }
    
    // DefaultSchedulerServiceMBeanJavaDoc
    public void setScheduleDispatcherSize(int size){
        scheduleDispatcherSize = size;
    }
    
    // DefaultSchedulerServiceMBeanJavaDoc
    public int getScheduleDispatcherSize(){
        return scheduleDispatcherSize;
    }
    
    // DefaultSchedulerServiceMBeanJavaDoc
    public int getActiveScheduleDispatcherSize(){
        return queueHandlerContainer == null
            ? 0 : queueHandlerContainer.getActiveQueueHandlerSize();
    }
    
    // DefaultSchedulerServiceMBeanJavaDoc
    public void setDaemonScheduleDispatcher(boolean isDaemon){
        isDaemonScheduleDispatcher = isDaemon;
    }
    
    // DefaultSchedulerServiceMBeanJavaDoc
    public boolean isDaemonScheduleDispatcher(){
        return isDaemonScheduleDispatcher;
    }
    
    /**
     * T[rX̐sB<p>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    public void createService() throws Exception{
        queueHandlerContainer = new QueueHandlerContainerService<ScheduleRequest>();
        queueHandlerContainer.create();
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        
        queueHandlerContainer.setQueueHandlerSize(scheduleDispatcherSize);
        queueHandlerContainer.setDaemonQueueHandler(isDaemonScheduleDispatcher);
        if(queueServiceName != null){
            queueHandlerContainer.setQueueServiceName(queueServiceName);
        }else if(requestQueue != null){
            queueHandlerContainer.setQueueService(requestQueue);
        }else{
            DefaultQueueService<ScheduleRequest> queue = new DefaultQueueService<ScheduleRequest>();
            queue.create();
            queue.start();
            queueHandlerContainer.setQueueService(queue);
        }
        queueHandlerContainer.setQueueHandler(new ScheduleDispatcher());
        queueHandlerContainer.start();
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    public void stopService() throws Exception{
        
        queueHandlerContainer.stop();
    }
    
    /**
     * T[rX̔jsB<p>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    public void destroyService() throws Exception{
        
        queueHandlerContainer.destroy();
        queueHandlerContainer = null;
    }
    
    /**
     * XPW[𓊓{@link Queue}T[rXݒ肷B<p>
     *
     * @param queue QueueT[rX
     */
    public void setQueue(Queue<ScheduleRequest> queue){
        this.requestQueue = queue;
    }
    
    /**
     * XPW[𓊓{{@link Queue}T[rX擾B<p>
     *
     * @return QueueT[rX
     */
    protected Queue<ScheduleRequest> getQueue(){
        return requestQueue;
    }
    
    /**
     * gUNVQs\Ȃ̂falseԂB<p>
     *
     * @return false
     */
    protected boolean isTransactableQueue(){
        return false;
    }
    
    /**
     * {@link Queue}ɃXPW[NGXg𓊓B<p>
     *
     * @param request XPW[NGXg
     * @exception Throwable Ɏsꍇ
     */
    protected void entrySchedule(ScheduleRequest request) throws Throwable{
        queueHandlerContainer.getQueueService().push(request);
    }
    
    /**
     * XPW[fBXpb`B<p>
     * XPW[{@link ScheduleExecutor}Ɏs˗B܂A{@link ScheduleManager}gāAXPW[̏ԂύXB<br>
     * 
     * @author M.Takata
     */
    protected class ScheduleDispatcher implements QueueHandler<ScheduleRequest>{
        
        /**
         * {@link Queue}oXPW[{@link ScheduleExecutor}Ɏs˗B<p>
         *
         * @param obj {@link Queue}oXPW[
         * @exception Throwable
         */
        public void handleDequeuedObject(ScheduleRequest obj) throws Throwable{
            if(obj == null){
                return;
            }
            dispatchSchedule(obj);
        }
        public boolean handleError(ScheduleRequest obj, Throwable th) throws Throwable{
            throw th;
        }
        public void handleRetryOver(ScheduleRequest obj, Throwable th) throws Throwable{
            throw th;
        }
    }
}