/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.*;

/**
 * XPW[ǗB<p>
 * XPW[쐬EǗAsׂXPW[񋟂B<br>
 * sׂǂ́AXPW[AXPW[ԁAˑ֌W画fB<br>
 *
 * @author M.Takata
 */
public interface ScheduleManager{
    
    /**
     * w肳ꂽt̃XPW[쐬B<p>
     *
     * @param date t
     * @throws ScheduleMakeException XPW[쐬Ɏsꍇ
     */
    public void makeSchedule(Date date) throws ScheduleMakeException;
    
    /**
     * w肳ꂽXPW[ʂ̃XPW[쐬{@link ScheduleMaker}o^B<p>
     *
     * @param scheduleType XPW[
     * @param maker ScheduleMaker
     */
    public void setScheduleMaker(String scheduleType, ScheduleMaker maker);
    
    /**
     * w肳ꂽXPW[ʂ̃XPW[쐬{@link ScheduleMaker}擾B<p>
     *
     * @param scheduleType XPW[
     * @return ScheduleMaker
     */
    public ScheduleMaker getScheduleMaker(String scheduleType);
    
    /**
     * XPW[ʂɊY{@link ScheduleMaker}o^ĂȂꍇɎgpftHgScheduleMakerݒ肷B<p>
     *
     * @param maker ScheduleMaker
     */
    public void setDefaultScheduleMaker(ScheduleMaker maker);
    
    /**
     * XPW[ʂɊY{@link ScheduleMaker}o^ĂȂꍇɎgpftHgScheduleMaker擾B<p>
     *
     * @return ScheduleMaker
     */
    public ScheduleMaker getDefaultScheduleMaker();
    
    
    
    /**
     * SẴXPW[}X^B<p>
     *
     * @return XPW[}X^Xg
     * @exception ScheduleManageException XPW[}X^̌Ɏsꍇ
     */
    public List<ScheduleMaster> findAllScheduleMasters() throws ScheduleManageException;
    
    /**
     * w肳ꂽXPW[}X^B<p>
     *
     * @param id XPW[}X^ID
     * @return XPW[}X^
     * @exception ScheduleManageException XPW[}X^̌Ɏsꍇ
     */
    public ScheduleMaster findScheduleMaster(String id) throws ScheduleManageException;
    
    /**
     * SẴXPW[B<p>
     *
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findAllSchedules() throws ScheduleManageException;
    
    /**
     * w肳ꂽXPW[B<p>
     *
     * @param id XPW[ID
     * @return XPW[
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public Schedule findSchedule(String id) throws ScheduleManageException;
    
    /**
     * w肳ꂽ}X^ID̃XPW[B<p>
     *
     * @param masterId XPW[}X^ID
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(String masterId) throws ScheduleManageException;
    
    /**
     * w肳ꂽt̃XPW[B<p>
     *
     * @param date t
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(Date date) throws ScheduleManageException;
    
    /**
     * w肳ꂽԂ̃XPW[B<p>
     *
     * @param from Ԃ̊Jn
     * @param to Ԃ̏I
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(Date from, Date to) throws ScheduleManageException;
    
    /**
     * w肳ꂽԂ̃XPW[B<p>
     *
     * @param states XPW[Ԃ̔z
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(int[] states) throws ScheduleManageException;
    
    /**
     * w肳ꂽԁAw肳ꂽԂ̃XPW[B<p>
     *
     * @param from Ԃ̊Jn
     * @param to Ԃ̏I
     * @param states XPW[Ԃ̔z
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(Date from, Date to, int[] states) throws ScheduleManageException;
    
    /**
     * w肳ꂽԁAԁA}X^ID̃XPW[B<p>
     *
     * @param from Ԃ̊Jn
     * @param to Ԃ̏I
     * @param states XPW[Ԃ̔z
     * @param masterId XPW[}X^ID
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(Date from, Date to, int[] states, String masterId) throws ScheduleManageException;
    
    /**
     * w肳ꂽƎsʂŎs\ȃXPW[B<p>
     *
     * @param date 
     * @param executorTypes sʔz
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findExecutableSchedules(Date date, String[] executorTypes) throws ScheduleManageException;
    
    /**
     * w肳ꂽsL[ƓŎs\ȃXPW[B<p>
     *
     * @param date 
     * @param executorTypes sʔz
     * @param executorKey sL[
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findExecutableSchedules(Date date, String[] executorTypes, String executorKey) throws ScheduleManageException;
    
    /**
     * w肳ꂽID̃XPW[ɈˑĂXPW[B<p>
     *
     * @param id XPW[ID
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findDependedSchedules(String id) throws ScheduleManageException;
    
    /**
     * XPW[ǉB<p>
     *
     * @param schedule XPW[
     * @exception ScheduleManageException XPW[̒ǉɎsꍇ
     */
    public void addSchedule(Schedule schedule) throws ScheduleManageException;
    
    /**
     * XPW[ύXB<p>
     *
     * @param id XPW[ID
     * @param time 
     * @return XPW[XVꂽꍇtrue
     * @exception ScheduleManageException XPW[̍XVɎsꍇ
     */
    public boolean reschedule(String id, Date time) throws ScheduleManageException;
    
    /**
     * XPW[폜B<p>
     *
     * @param id XPW[ID
     * @return XPW[폜ꂽꍇtrue
     * @exception ScheduleManageException XPW[̍폜Ɏsꍇ
     */
    public boolean removeSchedule(String id) throws ScheduleManageException;
    
    /**
     * XPW[폜B<p>
     *
     * @param masterId XPW[}X^ID
     * @return XPW[폜ꂽꍇtrue
     * @exception ScheduleManageException XPW[̍폜Ɏsꍇ
     */
    public boolean removeScheduleByMasterId(String masterId) throws ScheduleManageException;
    
    /**
     * w肳ꂽt̃XPW[폜B<p>
     *
     * @param date t
     * @return XPW[폜ꂽꍇtrue
     * @exception ScheduleManageException XPW[̍폜Ɏsꍇ
     */
    public boolean removeSchedule(Date date) throws ScheduleManageException;
    
    /**
     * w肳ꂽԁAԁA}X^ID̃XPW[폜B<p>
     *
     * @param from Ԃ̊Jn
     * @param to Ԃ̏I
     * @param states XPW[Ԃ̔z
     * @param masterId XPW[}X^ID
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public boolean removeSchedule(Date from, Date to, int[] states, String masterId) throws ScheduleManageException;
    
    /**
     * XPW[s{@link ScheduleExecutor}ݒ肷B<p>
     *
     * @param id XPW[ID
     * @param key ScheduleExecutor肷L[
     */
    public void setExecutorKey(String id, String key) throws ScheduleManageException;
    
    
    /**
     * w肳ꂽXPW[̏Ԃ擾B<p>
     *
     * @param id XPW[ID
     * @return 
     * @exception ScheduleStateControlException XPW[Ԃ̎擾Ɏsꍇ
     */
    public int getState(String id) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̐Ԃ擾B<p>
     *
     * @param id XPW[ID
     * @return 
     * @exception ScheduleStateControlException XPW[Ԃ̎擾Ɏsꍇ
     */
    public int getControlState(String id) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̏ԂύXB<p>
     *
     * @param id XPW[ID
     * @param state 
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeState(String id, int state) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̏ԂύXB<p>
     *
     * @param id XPW[ID
     * @param oldState ݂̏
     * @param newState ύX̏
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeState(String id, int oldState, int newState) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̏ԂύXB<p>
     *
     * @param id XPW[ID
     * @param state 
     * @param output s
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeState(String id, int state, Object output) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̐ԂύXB<p>
     *
     * @param id XPW[ID
     * @param state 
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeControlState(String id, int state) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̐ԂύXB<p>
     *
     * @param id XPW[ID
     * @param oldState ݂̏
     * @param newState ύX̏
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeControlState(String id, int oldState, int newState) throws ScheduleStateControlException;
    
    /**
     * XPW[䃊Xio^B<p>
     *
     * @param listener XPW[䃊Xi
     */
    public void addScheduleControlListener(ScheduleControlListener listener);
    
    /**
     * XPW[䃊Xi폜B<p>
     *
     * @param listener XPW[폜Xi
     */
    public void removeScheduleControlListener(ScheduleControlListener listener);
}