/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.transaction;

import java.lang.reflect.*;

import javax.transaction.TransactionManager;

import jp.ossc.nimbus.core.*;

/**
 * {@link ReflectionTransactionManagerFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ReflectionTransactionManagerFactoryService
 */
public interface ReflectionTransactionManagerFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * TransactionManager𐶐t@NgNX̃RXgN^ݒ肷B<p>
     * t@NgNXstatic\bhĂԏꍇ́Aw肷Kv͂ȂB<br>
     * 
     * @param c t@NgNX̃RXgN^
     */
    public void setFactoryConstructor(Constructor<?> c);
    
    /**
     * TransactionManager𐶐t@NgNX̃RXgN^擾B<p>
     * 
     * @return t@NgNX̃RXgN^
     */
    public Constructor<?> getFactoryConstructor();
    
    /**
     * TransactionManager𐶐t@NgNX̃RXgN^̈ݒ肷B<p>
     * 
     * @param params t@NgNX̃RXgN^̈
     */
    public void setFactoryConstructorParameters(Object[] params);
    
    /**
     * TransactionManager𐶐t@NgNX̃RXgN^̈擾B<p>
     * 
     * @return t@NgNX̃RXgN^̈
     */
    public Object[] getFactoryConstructorParameters();
    
    /**
     * TransactionManager𐶐t@NgNX̃t@Ng\bhݒ肷B<p>
     * 
     * @param m t@NgNX̃t@Ng\bh
     */
    public void setFactoryMethod(Method m);
    
    /**
     * TransactionManager𐶐t@NgNX̃t@Ng\bh擾B<p>
     * 
     * @return t@NgNX̃t@Ng\bh
     */
    public Method getFactoryMethod();
    
    /**
     * TransactionManager𐶐t@NgNX̃t@Ng\bḧݒ肷B<p>
     * 
     * @param params t@NgNX̃t@Ng\bḧ
     */
    public void setFactoryMethodParameters(Object[] params);
    
    /**
     * TransactionManager𐶐t@NgNX̃t@Ng\bḧ擾B<p>
     * 
     * @return t@NgNX̃t@Ng\bḧ
     */
    public Object[] getFactoryMethodParameters();
    
    /**
     * t@Ng̃CX^Xݒ肷B<p>
     *
     * @param fac t@Ng
     */
    public void setFactory(Object fac);
    
    /**
     * t@Ng̃CX^X擾B<p>
     *
     * @return t@Ng
     */
    public Object getFactory();
    
    /**
     * TransactionManagerNX̃RXgN^ݒ肷B<p>
     * static\bhĂԏꍇ́Aw肷Kv͂ȂB<br>
     * 
     * @param c RXgN^
     */
    public void setTransactionManagerConstructor(Constructor<TransactionManager> c);
    
    /**
     * TransactionManagerNX̃RXgN^擾B<p>
     * 
     * @return RXgN^
     */
    public Constructor<TransactionManager> getTransactionManagerConstructor();
    
    /**
     * TransactionManagerNX̃RXgN^̈ݒ肷B<p>
     * 
     * @param params RXgN^̈
     */
    public void setTransactionManagerConstructorParameters(Object[] params);
    
    /**
     * TransactionManagerNX̃RXgN^̈擾B<p>
     * 
     * @return RXgN^̈
     */
    public Object[] getTransactionManagerConstructorParameters();
}
