/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.validator;

import java.util.*;

/**
 * gݍ킹of[^B<p>
 * ̃of[^_ZqŘAČ؂B<br>
 * 
 * @author M.Takata
 */
public class CombinationValidator implements Validator, java.io.Serializable{
    
    private static final long serialVersionUID = 1695449609101701493L;
    
    /**
     * gݍ킹ꂽof[^Ƙ_Zq̃XgB<p>
     * ValidatorWithConditioñXgB<br>
     */
    protected List<ValidatorWithCondition> validators = new ArrayList<ValidatorWithCondition>();
    
    /**
     * ŏ̃of[^ǉB<p>
     *
     * @param validator of[^
     * @exception ValidateException Ƀof[^o^Ăꍇ
     */
    public void add(Validator validator) throws ValidateException{
        if(validators.size() != 0){
            throw new ValidateException("It is not the first validator.");
        }
        final ValidatorWithCondition cond
             = new ValidatorWithCondition(validator);
        validators.add(cond);
    }
    
    /**
     * ŏ̃of[^NOTZqtŒǉB<p>
     *
     * @param validator of[^
     * @exception ValidateException Ƀof[^o^Ăꍇ
     */
    public void addNot(Validator validator) throws ValidateException{
        if(validators.size() != 0){
            throw new ValidateException("It is not the first validator.");
        }
        final ValidatorWithCondition cond
             = new ValidatorWithCondition(validator);
        cond.isNot = true;
        validators.add(cond);
    }
    
    /**
     * of[^ORZqtŘAB<p>
     *
     * @param validator of[^
     */
    public void or(Validator validator){
        final ValidatorWithCondition cond
             = new ValidatorWithCondition(validator);
        cond.isOr = true;
        validators.add(cond);
    }
    
    /**
     * of[^ANDZqtŘAB<p>
     *
     * @param validator of[^
     */
    public void and(Validator validator){
        final ValidatorWithCondition cond
             = new ValidatorWithCondition(validator);
        cond.isAnd = true;
        validators.add(cond);
    }
    
    /**
     * of[^OR NOTZqtŘAB<p>
     *
     * @param validator of[^
     */
    public void orNot(Validator validator){
        final ValidatorWithCondition cond
             = new ValidatorWithCondition(validator);
        cond.isNot = true;
        cond.isOr = true;
        validators.add(cond);
    }
    
    /**
     * of[^AND NOTZqtŘAB<p>
     *
     * @param validator of[^
     */
    public void andNot(Validator validator){
        final ValidatorWithCondition cond
             = new ValidatorWithCondition(validator);
        cond.isNot = true;
        cond.isAnd = true;
        validators.add(cond);
    }
    
    /**
     * of[^Sč폜B<p>
     */
    public void clear(){
        validators.clear();
    }
    
    /**
     * w肳ꂽIuWFNg_ZqŘAꂽof[^gČ؂B<p>
     *
     * @param obj ؑΏۂ̃IuWFNg
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    @Override
    public boolean validate(Object obj) throws ValidateException{
        if(validators.size() == 0){
            return true;
        }
        Boolean result = null;
        for(int i = 0, imax = validators.size(); i < imax; i++){
            final ValidatorWithCondition cond
                 = (ValidatorWithCondition)validators.get(i);
            result = cond.validate(result, obj) ? Boolean.TRUE : Boolean.FALSE;
        }
        return result == null ? true : result.booleanValue();
    }
    
    /**
     * _Zqtof[^B<p>
     *
     * @author M.Takata
     */
    protected static class ValidatorWithCondition
     implements java.io.Serializable{
        
        private static final long serialVersionUID = 924450733620787066L;
        
        /**
         * NOTZqtǂ̃tOB<p>
         */
        protected boolean isNot;
        
        /**
         * ORZqtǂ̃tOB<p>
         */
        protected boolean isOr;
        
        /**
         * ANDZqtǂ̃tOB<p>
         */
        protected boolean isAnd;
        
        /**
         * of[^B<p>
         */
        protected Validator validator;
        
        /**
         * CX^X𐶐B<p>
         *
         * @param validator of[^
         */
        public ValidatorWithCondition(Validator validator){
            this.validator = validator;
        }
        
        /**
         * w肳ꂽIuWFNgof[^Ō؂Ǎ،ʂƂ܂ł̌،ʂ̘_ZsB<p>
         *
         * @param preResult ܂ł̌،
         * @param obj ؑΏۂ̃IuWFNg
         * @return ،ʁBؐ̏ꍇtrue
         * @exception ValidateException ؂Ɏsꍇ
         */
        public boolean validate(Boolean preResult, Object obj)
         throws ValidateException{
            if(preResult != null){
                if(!preResult.booleanValue() && isAnd){
                    return false;
                }else if(preResult.booleanValue() && isOr){
                    return true;
                }
            }
            boolean result = validator.validate(obj);
            result = isNot ? !result : result;
            if(preResult != null){
                if(isOr){
                    result = result | preResult.booleanValue();
                }else if(isAnd){
                    result = result & preResult.booleanValue();
                }
            }
            return result;
        }
    }
}