/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

/**
 * BeanspbP[W[eBeBB<p>
 *
 * @author M.Takata
 */
class Utility{
    
    /**
     * VXevpeBQƊJnB<p>
     */
    public static final String SYSTEM_PROPERTY_START = "${";
    
    /**
     * VXevpeBQƏIB<p>
     */
    public static final String SYSTEM_PROPERTY_END = "}";
    
    /**
     * XMLRgAEgJnB<p>
     */
    public static final String COMENT_START = "<!--";
    
    /**
     * XMLRgAEgIB<p>
     */
    public static final String COMENT_END = "-->";
    
    /**
     * w肳ꂽgB<p>
     * ǵAw肳ꂽ̑Ő󔒕i{@link Character#isWhitespace(char)}trueƂȂ镶j폜B
     * 
     * @param str 
     * @return gꂽ
     */
    public static String trim(String str){
        String result = str;
        for(int i = 0, max = result.length(); i < max; i++){
            final char c = result.charAt(i);
            if(!Character.isWhitespace(c)){
                result = result.substring(i);
                break;
            }
        }
        for(int i = result.length(); --i >= 0;){
            final char c = result.charAt(i);
            if(!Character.isWhitespace(c)){
                result = result.substring(0, i + 1);
                break;
            }
        }
        return result;
    }
    
    /**
     * w肳ꂽXMLRgAEgB<p>
     *
     * @param str 
     * @return XMLRgAEg
     */
    public static String xmlComentOut(String str){
        String result = str;
        final int startIndex = result.indexOf(COMENT_START);
        if(startIndex == -1){
            return result;
        }
        final int endIndex = result.indexOf(COMENT_END);
        if(endIndex == -1 || startIndex > endIndex){
            return result;
        }
        result = result.substring(0, startIndex)
             + result.substring(endIndex + COMENT_END.length());
        if(result.indexOf(COMENT_START) != -1){
            return xmlComentOut(result);
        }
        return result;
    }
    
    public static String unicodeConvert(String str){
        char c;
        int len = str.length();
        StringBuilder buf = new StringBuilder(len);
        
        for(int i = 0; i < len; ){
            c = str.charAt(i++);
            if(c == '\\' && i < len){
                c = str.charAt(i++);
                if(c == 'u'){
                    int startIndex = i;
                    int value = 0;
                    boolean isUnicode = true;
                    for(int j = 0; j < 4; j++){
                        if(i >= len){
                            isUnicode = false;
                            break;
                        }
                        c = str.charAt(i++);
                        switch(c){
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            value = (value << 4) + (c - '0');
                            break;
                        case 'a':
                        case 'b':
                        case 'c':
                        case 'd':
                        case 'e':
                        case 'f':
                            value = (value << 4) + 10 + (c - 'a');
                            break;
                        case 'A':
                        case 'B':
                        case 'C':
                        case 'D':
                        case 'E':
                        case 'F':
                            value = (value << 4) + 10 + (c - 'A');
                            break;
                        default:
                            isUnicode = false;
                            break;
                        }
                    }
                    if(isUnicode){
                        buf.append((char)value);
                    }else{
                        buf.append('\\').append('u');
                        i = startIndex;
                    }
                }else{
                    buf.append('\\').append(c);
                }
            }else{
                buf.append(c);
            }
        }
        return buf.toString();
    }
}
