/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.invoker;

import java.lang.reflect.*;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.distribute.KeepAliveListener;
import jp.ossc.nimbus.service.performance.ResourceUsage;

/**
 * \bhtNVĂяoC{[JB<p>
 * tNVAPIgāA\bhĂяosB<br>
 * ȉɁAT[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="SampleInvoker"
 *                  code="jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class MethodReflectionCallInvokerService extends ServiceBase
 implements KeepAliveCheckInvoker, java.io.Serializable, MethodReflectionCallInvokerServiceMBean{
    
    private static final long serialVersionUID = -2211871699281951334L;
    
    protected Set<KeepAliveListener> listeners;
    
    protected ServiceName resourceUsageServiceName;
    protected ResourceUsage<Comparable<?>> resourceUsage;
    
    // MethodReflectionCallInvokerServiceMBeanJavaDoc
    @Override
    public void setResourceUsageServiceName(ServiceName name){
        resourceUsageServiceName = name;
    }
    // MethodReflectionCallInvokerServiceMBeanJavaDoc
    @Override
    public ServiceName getResourceUsageServiceName(){
        return resourceUsageServiceName;
    }
    
    public void setResourceUsage(ResourceUsage<Comparable<?>> usage){
        resourceUsage = usage;
    }
    
    @Override
    public void startService() throws Exception{
        if(listeners != null){
            for(KeepAliveListener listener : listeners){
                listener.onRecover(this);
            }
        }
        if(resourceUsage == null && resourceUsageServiceName != null){
            resourceUsage = ServiceManagerFactory
                .getServiceObject(resourceUsageServiceName);
        }
    }
    
    @Override
    public void stopService() throws Exception{
        if(listeners != null){
            for(KeepAliveListener listener : listeners){
                listener.onDead(this);
            }
        }
    }
    
    /**
     * tNVAPIgāA\bhĂяosB<p>
     * 
     * @param context ĂяõReLXg
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇ
     */
    @Override
    public Object invoke(InvocationContext context) throws Throwable{
        final MethodInvocationContext methodContext
             = (MethodInvocationContext)context;
        try{
            return methodContext.getTargetMethod().invoke(
                methodContext.getTargetObject(),
                methodContext.getParameters()
            );
        }catch(InvocationTargetException e){
            throw e.getTargetException();
        }
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public boolean isAlive(){
        return getState() == State.STARTED;
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public void addKeepAliveListener(KeepAliveListener listener){
        if(listeners == null){
            listeners = Collections.synchronizedSet(new LinkedHashSet<KeepAliveListener>());
        }
        listeners.add(listener);
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public void removeKeepAliveListener(KeepAliveListener listener){
        if(listeners == null){
            return;
        }
        listeners.remove(listener);
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public void clearKeepAliveListener(){
        if(listeners == null){
            return;
        }
        listeners.clear();
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @SuppressWarnings("unchecked")
    @Override
    public <T extends Comparable<?>> T getResourceUsage(){
        return resourceUsage == null ? null : (T)resourceUsage.getUsage();
    }
}
