/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.invoker;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.distribute.KeepAliveListener;
import jp.ossc.nimbus.service.jndi.*;
import jp.ossc.nimbus.service.proxy.ProxyServerInvoker;
import jp.ossc.nimbus.service.repository.Repository;

/**
 * vLVT[oĂяoInvokerB<p>
 * [gT[õT[rXĂяo߂InvokerłB<br>
 * [gJNDIT[oɁA{@link ProxyServerInvoker}C^tF[X[gIuWFNgoChĂȂ΂ȂȂB<br>
 *
 * @author M.Takata
 */
public class ProxyServerCallInvokerService extends ServiceBase
 implements Invoker, KeepAliveCheckInvoker, java.io.Serializable,
            ProxyServerCallInvokerServiceMBean{
    
    private static final long serialVersionUID = -4617039048036524665L;
    
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String jndiName;
    private ServiceName remoteServiceName;
    
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    @Override
    public void setJndiFinderServiceName(ServiceName name){
        jndiFinderServiceName = name;
    }
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    @Override
    public ServiceName getJndiFinderServiceName(){
        return jndiFinderServiceName;
    }
    
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    public void setJndiRepositoryServiceName(ServiceName name){
        jndiRepositoryServiceName = name;
    }
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    public ServiceName getJndiRepositoryServiceName(){
        return jndiRepositoryServiceName;
    }
    
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    @Override
    public void setProxyServerJndiName(String name){
        jndiName = name;
    }
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    @Override
    public String getProxyServerJndiName(){
        return jndiName;
    }
    
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    @Override
    public void setRemoteServiceName(ServiceName name){
        remoteServiceName = name;
    }
    // ProxyServerCallInvokerServiceMBeanJavaDoc
    @Override
    public ServiceName getRemoteServiceName(){
        return remoteServiceName;
    }
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[XRMIIuWFNglookup{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rXݒ肷B<p>
     *
     * @param jndiFinder JndiFinderT[rX
     */
    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[XRMIIuWFNglookup{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rXݒ肷B<p>
     *
     * @param jndiRepository RepositoryT[rX
     */
    public void setJndiRepository(Repository jndiRepository) {
        this.jndiRepository = jndiRepository;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(jndiFinderServiceName != null){
            jndiFinder = ServiceManagerFactory
                .getServiceObject(jndiFinderServiceName);
        }
        if(jndiRepositoryServiceName != null){
            jndiRepository = ServiceManagerFactory
                .getServiceObject(jndiRepositoryServiceName);
        }
        if(jndiFinder == null && jndiRepository == null) {
            throw new IllegalArgumentException(
                "JndiFinder or JndiRepository must be specified."
            );
        }
    }
    
    /**
     * {@link ProxyServerInvoker}C^tF[X[gIuWFNgĂяoB<p>
     * 
     * @param context ĂяõReLXg
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇ
     */
    @Override
    public Object invoke(InvocationContext context) throws Throwable{
        final MethodInvocationContext methodContext
             = (MethodInvocationContext)context;
        try{
            ServiceName serviceName = remoteServiceName;
            if(serviceName == null){
                Object target = methodContext.getTargetObject();
                if(target != null && target instanceof ServiceName){
                    serviceName = (ServiceName)target;
                }
            }
            if(serviceName != null){
                methodContext.setTargetObject(serviceName);
            }
            return lookupProxyServerInvoker(serviceName).invoke(context);
        }catch(javax.naming.NamingException e){
            throw new InvokeException(e);
        }catch(java.rmi.RemoteException e){
            throw new InvokeException(e);
        }
    }
    
    private ProxyServerInvoker lookupProxyServerInvoker(
        ServiceName serviceName
    ) throws javax.naming.NamingException{
        
        String name = jndiName;
        if(name == null && serviceName != null){
            name = serviceName.getServiceManagerName()
                 + '/' + serviceName.getServiceName();
        }
        if(name == null){
            throw new IllegalArgumentException(
                "ProxyServerJndiName and RemoteServiceName is null."
            );
        }
        if(jndiFinder != null){
            return (ProxyServerInvoker)jndiFinder.lookup(name);
        }else{
            return (ProxyServerInvoker)jndiRepository.get(name);
        }
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public boolean isAlive(){
        try{
            return lookupProxyServerInvoker(remoteServiceName)
                .isAlive(remoteServiceName);
        }catch(Exception e){
            return false;
        }
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public void addKeepAliveListener(KeepAliveListener listener){
        throw new UnsupportedOperationException();
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public void removeKeepAliveListener(KeepAliveListener listener){
        throw new UnsupportedOperationException();
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public void clearKeepAliveListener(){
        throw new UnsupportedOperationException();
    }
    
    // KeepAliveCheckInvokerJavaDoc
    @Override
    public <T extends Comparable<?>> T getResourceUsage(){
        try{
            return lookupProxyServerInvoker(remoteServiceName).getResourceUsage();
        }catch(Exception e){
            return null;
        }
    }
}
