/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.beanflow;

import java.util.Set;
import java.util.HashSet;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link BeanFlowFactory}O[sO{@link BeanFlowFactory}T[rXB<p>
 * 
 * @author M.Takata
 */
public class  GroupBeanFlowFactoryService extends ServiceBase implements BeanFlowFactory, GroupBeanFlowFactoryServiceMBean{
    
    private static final long serialVersionUID = -8663539706200662077L;
    
    private ServiceName[] beanFlowFactoryServiceNames;
    private BeanFlowFactory[] beanFlowFactories;
    
    @Override
    public void setBeanFlowFactoryServiceNames(ServiceName[] names){
        beanFlowFactoryServiceNames = names;
    }
    @Override
    public ServiceName[] getBeanFlowFactoryServiceNames(){
        return beanFlowFactoryServiceNames;
    }
    
    public void setBeanFlowFactories(BeanFlowFactory[] factories){
        beanFlowFactories = factories;
    }
    
    @Override
    public void startService() throws Exception{
        if(beanFlowFactoryServiceNames != null && beanFlowFactoryServiceNames.length != 0){
            beanFlowFactories = new BeanFlowFactory[beanFlowFactoryServiceNames.length];
            for(int i = 0; i < beanFlowFactoryServiceNames.length; i++){
                beanFlowFactories[i] = ServiceManagerFactory.getServiceObject(beanFlowFactoryServiceNames[i]);
            }
        }
        if(beanFlowFactories == null){
            throw new IllegalArgumentException("BeanFlowFactories is null.");
        }
    }
    
    @Override
    public BeanFlow createFlow(String key) throws BeanFlowException{
        for(BeanFlowFactory beanFlowFactory : beanFlowFactories){
            if(beanFlowFactory.containsFlow(key)){
                return beanFlowFactory.createFlow(key);
            }
        }
        throw new NoSuchBeanFlowException(key);
    }
    
    @Override
    public BeanFlow createFlow(String key, String caller, boolean isOverride) throws BeanFlowException{
        for(BeanFlowFactory beanFlowFactory : beanFlowFactories){
            if(beanFlowFactory.containsFlow(key)){
                return beanFlowFactory.createFlow(key, caller, isOverride);
            }
        }
        throw new NoSuchBeanFlowException(key);
    }
    
    @Override
    public Set<String> getBeanFlowKeySet(){
        Set<String> result = new HashSet<String>();
        for(BeanFlowFactory beanFlowFactory : beanFlowFactories){
            result.addAll(beanFlowFactory.getBeanFlowKeySet());
        }
        return result;
    }
    
    @Override
    public boolean containsFlow(String key){
        for(BeanFlowFactory beanFlowFactory : beanFlowFactories){
            if(beanFlowFactory.containsFlow(key)){
                return true;
            }
        }
        return false;
    }
}
