/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http.proxy;

import jp.ossc.nimbus.core.*;

/**
 * {@link ProxyServerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see ProxyServerService
 */
public interface ProxyServerServiceMBean extends ServiceBaseMBean{
    
    /**
     * ftHg̑҂󂯃|[gԍB<p>
     */
    public static final int DEFAULT_PORT = 8080;
    
    /**
     * {@link Process}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ProcessT[rX̃T[rX
     */
    public void setProcessServiceName(ServiceName name);
    
    /**
     * {@link Process}T[rX̃T[rX擾B<p>
     *
     * @return ProcessT[rX̃T[rX
     */
    public ServiceName getProcessServiceName();
    
    /**
     * {@link javax.net.ServerSocketFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ServerSocketFactoryT[rX̃T[rX
     */
    public void setServerSocketFactoryServiceName(ServiceName name);
    
    /**
     * {@link javax.net.ServerSocketFactory}T[rX̃T[rX擾B<p>
     *
     * @return ServerSocketFactoryT[rX̃T[rX
     */
    public ServiceName getServerSocketFactoryServiceName();
    
    /**
     * T[o\Pbg̃oChAhXݒ肷B<p>
     *
     * @param address oChAhX
     */
    public void setBindAddress(String address);
    
    /**
     * T[o\Pbg̃oChAhX擾B<p>
     *
     * @return oChAhX
     */
    public String getBindAddress();
    
    /**
     * T[o\Pbg̃obNOݒ肷B<p>
     * ftHǵA0B<br>
     *
     * @param backlog obNO
     */
    public void setBacklog(int backlog);
    
    /**
     * T[o\Pbg̃obNO擾B<p>
     *
     * @return obNO
     */
    public int getBacklog();
    
    /**
     * ̃vLV̑҂󂯃|[gԍݒ肷B<p>
     * ftHǵA{@link #DEFAULT_PORT}B<br>
     *
     * @param port |[gԍ
     */
    public void setPort(int port);
    
    /**
     * ̃vLV̑҂󂯃|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getPort();
    
    /**
     * \Pbg̓ǂݍ݃^CAEg[ms]ݒ肷B<p>
     * ftHǵA^CAEgȂB<br>
     *
     * @param millis ǂݍ݃^CAEg[ms]
     */
    public void setSoTimeout(int millis);
    
    /**
     * \Pbg̓ǂݍ݃^CAEg[ms]擾B<p>
     *
     * @return ǂݍ݃^CAEg[ms]
     */
    public int getSoTimeout();
    
    /**
     * NGXgXbhݒ肷B<p>
     * ftHǵA1B<br>
     *
     * @param count Xbh
     */
    public void setMaxProcessCount(int count);
    
    /**
     * NGXgXbh擾B<p>
     *
     * @return Xbh
     */
    public int getMaxProcessCount();
}
