/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.List;
import java.util.ArrayList;
import java.util.Stack;

import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.service.journal.EditorFinder;

/**
 * CӂBeanJSON`ɕҏWW[iGfB^[B<p>
 *
 * @author M.Takata
 */
public class BeanJSONJournalEditorService extends JSONJournalEditorService{
    
    private static final long serialVersionUID = -518920885502264853L;
    
    @Override
    protected StringBuilder appendUnknownValue(StringBuilder buf, EditorFinder finder, Class<?> type, Object value, Stack<Object> stack){
        if(value == null || isRecursiveCall(stack)){
            return super.appendUnknownValue(buf, finder, type, value, stack);
        }
        final Property[] props = SimpleProperty.getProperties(value);
        if(props == null || props.length == 0){
            return super.appendUnknownValue(buf, finder, type, value, stack);
        }
        final List<Property> readProps = new ArrayList<Property>();
        for(int i = 0; i < props.length; i++){
            if(props[i].isReadable(value)){
                readProps.add(props[i]);
            }
        }
        if(readProps.size() == 0){
            return super.appendUnknownValue(buf, finder, type, value, stack);
        }
        buf.append(OBJECT_ENCLOSURE_START);
        boolean isOutput = false;
        for(int i = 0, max = readProps.size(); i < max; i++){
            Property prop = (Property)readProps.get(i);
            if(!isOutputProperty(prop.getPropertyName())){
                continue;
            }
            Object val = null;
            try{
                val = prop.getProperty(value);
            }catch(Exception e){
            }
            if(val == value){
                continue;
            }
            if(isOutput){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(buf, finder, prop.getPropertyName(), val, stack);
            isOutput = true;
        }
        buf.append(OBJECT_ENCLOSURE_END);
        return buf;
    }
}