/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import java.util.Set;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link MessageReceiverService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MessageReceiverService
 */
public interface MessageReceiverServiceMBean extends ServiceBaseMBean{
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgJNDIݒ肷B<p>
     *
     * @param name JNDI
     */
    public void setClientConnectionFactoryJndiName(String name);
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgJNDI擾B<p>
     *
     * @return JNDI
     */
    public String getClientConnectionFactoryJndiName();
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgoChĂ{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rXݒ肷B<p>
     *
     * @param name RepositoryT[rX̃T[rX
     */
    public void setJndiRepositoryServiceName(ServiceName name);
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgoChĂ{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rX擾B<p>
     *
     * @return RepositoryT[rX̃T[rX
     */
    public ServiceName getJndiRepositoryServiceName();
    
    /**
     * {@link ClientConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ClientConnectionFactoryT[rX̃T[rX
     */
    public void setClientConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link ClientConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ClientConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getClientConnectionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX𐶐t@NgT[rX̃T[rXݒ肷B<p>
     * Ŏw肳ꂽt@NgT[rX琶ꂽQueuéA{@link Message}ɔ񓯊ŔzMsꍇ̔zMQueueƂĎgpB<br>
     * ݒ肵Ȃꍇ́AQueueB<br>
     * 
     * @param name QueueT[rX𐶐t@NgT[rX̃T[rX
     */
    public void setMessageQueueFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX𐶐t@NgT[rX̃T[rX擾B<p>
     * 
     * @return QueueT[rX𐶐t@NgT[rX̃T[rX
     */
    public ServiceName getMessageQueueFactoryServiceName();
    
    /**
     * {@link Message}𕪗A{@link MessageListener}ւ̔zM񓯊ōsꍇ̔zMXbh̐ݒ肷B<p>
     * ftHg0ŁAeMessage𕪗ȂŔzMB<br>
     *
     * @param size zMXbh̐
     */
    public void setMessageQueueDistributedSize(int size);
    
    /**
     * {@link Message}𕪗A{@link MessageListener}ւ̔zM񓯊ōsꍇ̔zMXbh̐擾B<p>
     *
     * @return zMXbh̐
     */
    public int getMessageQueueDistributedSize();
    
    /**
     * {@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX𐶐t@NgT[rX̃T[rXݒ肷B<p>
     * Ŏw肳ꂽt@NgT[rX琶ꂽQueuéA{@link MessageListener}ɔ񓯊ŔzMsꍇ̔zMQueueƂĎgpB<br>
     * ݒ肵Ȃꍇ́AQueueB<br>
     * 
     * @param name QueueT[rX𐶐t@NgT[rX̃T[rX
     */
    public void setMessageListenerQueueFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX𐶐t@NgT[rX̃T[rX擾B<p>
     * 
     * @return QueueT[rX𐶐t@NgT[rX̃T[rX
     */
    public ServiceName getMessageListenerQueueFactoryServiceName();
    
    /**
     * {@link MessageListener}ւ̔zM񓯊ōsꍇ̔zMXbh̐ݒ肷B<p>
     * ftHg0ŁAeMessageListenerɃVOXbhŏzMB<br>
     *
     * @param size zMXbh̐
     */
    public void setMessageListenerQueueDistributedSize(int size);
    
    /**
     * {@link MessageListener}ւ̔zM񓯊ōsꍇ̔zMXbh̐擾B<p>
     *
     * @return zMXbh̐
     */
    public int getMessageListenerQueueDistributedSize();
    
    /**
     * T[rX̊JnɁA{@link ClientConnection}ڑ邩ǂݒ肷B<p>
     *
     * @param isConnect ڑꍇAtrue
     */
    public void setConnectOnStart(boolean isConnect);
    
    /**
     * T[rX̊JnɁA{@link ClientConnection}ڑ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇڑ
     */
    public boolean isConnectOnStart();
    
    /**
     * T[rX̊JnɁAMJn邩ǂݒ肷B<p>
     *
     * @param isStart MJnꍇAtrue
     */
    public void setStartReceiveOnStart(boolean isStart);
    
    /**
     * T[rX̊JnɁAMJn邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAMJn
     */
    public boolean isStartReceiveOnStart();
    
    /**
     * {@link ClientConnection}ڑB<p>
     *
     * @exception Exception ڑɎsꍇ
     */
    public void connect() throws Exception;
    
    /**
     * {@link ClientConnection}ؒfB<p>
     */
    public void close();
    
    /**
     * ڑĂ邩ǂ𔻒肷B<p>
     *
     * @return ڑĂꍇtrue
     */
    public boolean isConnected();
    
    /**
     * MJnB<p>
     *
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void startReceive() throws MessageSendException;
    
    /**
     * M~B<p>
     *
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void stopReceive() throws MessageSendException;
    
    /**
     * zMJnĂ邩ǂ𔻒肷B<br>
     *
     * @return zMJnĂꍇtrue
     */
    public boolean isStartReceive();
    
    /**
     * M̃TuWFNg̏W擾B<p>
     *
     * @return M̃TuWFNg̏W
     */
    public Set<String> getSubjectNameSet();
    
    /**
     * M擾B<p>
     *
     * @return M
     */
    public long getReceiveCount();
    
    /**
     * MZbgB<p>
     */
    public void resetReceiveCount();
    
    /**
     * w肵TuWFNg̎M擾B<p>
     *
     * @param subject TuWFNg
     * @return M
     */
    public long getReceiveCount(String subject);
    
    /**
     * w肵TuWFNg̎MZbgB<p>
     *
     * @param subject TuWFNg
     */
    public void resetReceiveCount(String subject);
    
    /**
     * o^ĂTuWFNg擾B<p>
     *
     * @return TuWFNg̏W
     */
    public Set<String> getSubjects();
    
    /**
     * w肳ꂽTuWFNgɑ΂ēo^ĂL[擾B<p>
     *
     * @param subject TuWFNg
     * @return L[̏W
     */
    public Set<String> getKeys(String subject);
    
    /**
     * o^Ă{@link MessageListener}̐擾B<p>
     *
     * @return MessageListener̐
     */
    public int getMessageListenerSize();
    
    /**
     * {@link Message}𕪗A{@link MessageListener}ւ̔zM񓯊ōsꍇ̔񓯊̕Ϗ[ms]擾B<p>
     *
     * @return 񓯊̕Ϗ[ms]
     */
    public long getMessageQueueAverageHandleProcessTime();
    
    /**
     * {@link MessageListener}ւ̔zM񓯊ōsꍇ̔񓯊̕Ϗ[ms]擾B<p>
     *
     * @return 񓯊̕Ϗ[ms]
     */
    public long getMessageListenerQueueAverageHandleProcessTime();
}
