/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

/**
 * XPW[sB<p>
 * s˗ꂽ^XNsAXPW[̏ԑJڂ{@link ScheduleManager}ɒʒmB<br>
 * ܂AXPW[̎sA{@link Schedule#isRetry()}truȅꍇ́AXPW[̃gCԊuɏ]āÃXPW[ɍăXPW[B<br>
 *
 * @author M.Takata
 */
public interface ScheduleExecutor{
    
    /**
     * ̃XPW[s肷L[擾B<p>
     *
     * @return L[
     */
    public String getKey();
    
    /**
     * ̃XPW[s̎ނ擾B<p>
     *
     * @return XPW[s̎
     */
    public String getType();
    
    /**
     * w肳ꂽXPW[sB<p>
     *
     * @param schedule XPW[
     * @return XPW[
     */
    public Schedule execute(Schedule schedule);
    
    /**
     * s̎w肳ꂽXPW[Aw肳ꂽsԂɐ䂷B<p>
     * 
     * @param id XPW[ID
     * @param cntrolState s
     * @return sԂ̂ύXꂽꍇtrue
     * @exception ScheduleStateControlException s̃XPW[̏ԕύXɎsꍇ
     */
    public boolean controlState(String id, int cntrolState) throws ScheduleStateControlException;
    
    /**
     * XPW[Ǘ{@link ScheduleManager}擾B<p>
     *
     * @return ScheduleManager
     */
    public ScheduleManager getScheduleManager();
    
    /**
     * XPW[Ǘ{@link ScheduleManager}ݒ肷B<p>
     *
     * @param manager ScheduleManager
     */
    public void setScheduleManager(ScheduleManager manager);
}