/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link WrappedConnectionFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see WrappedConnectionFactoryService
 */
public interface WrappedConnectionFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * bvConnectionFactoryT[rX̃T[rXݒ肷B<p>
     *
     * @param name bvConnectionFactoryT[rX̃T[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * bvConnectionFactoryT[rX̃T[rX擾B<p>
     *
     * @return bvConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * {@link java.sql.Connection}bvNXݒ肷B<p>
     * ŎwłNX́Ajava.sql.ConnectionC^tF[XĂAjava.sql.ConnectionRXgN^ĂNXłB<br>
     *
     * @param clazz NX
     */
    public void setConnectionWrapperClass(Class<java.sql.Connection> clazz);
    
    /**
     * {@link java.sql.Connection}bvNX̃NX擾B<p>
     *
     * @return NX
     */
    public Class<java.sql.Connection> getConnectionWrapperClass();
    
    /**
     * {@link java.sql.Connection}bvNX̃CX^Xɐݒ肷vpeBݒ肷B<p>
     * ConnectionbvNX̃CX^X́Aw肳ꂽ}bṽL[ɊYsettergāAL[ɊYlݒ肷B<br>
     *
     * @param prop ConnectionbvNX̃CX^Xɐݒ肷vpeB}bv
     */
    public void setConnectionWrapperProperties(Map<String, Object> prop);
    
    /**
     * {@link java.sql.Connection}bvNX̃CX^Xɐݒ肷vpeB擾B<p>
     *
     * @return ConnectionbvNX̃CX^Xɐݒ肷vpeB}bv
     */
    public Map<String, Object> getConnectionWrapperProperties();
}