/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link ByteArrayEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class ByteArrayEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
            {"1", new Byte[]{new Byte((byte)1)}},
            {"0b00000011", new Byte[]{new Byte((byte)3)}},
            {"0o010", new Byte[]{new Byte((byte)8)}},
            {"0x7F", new Byte[]{new Byte((byte)127)}},
            {"1,", new Byte[]{new Byte((byte)1)}},
            {"1,2", new Byte[]{new Byte((byte)1), new Byte((byte)2)}},
            {" \t 1,    2\n    , 3  ", new Byte[]{new Byte((byte)1), new Byte((byte)2), new Byte((byte)3)}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.ByteArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.ByteArrayEditor#getValue()",
                    "Normal"},
          dataProvider = "SetAsText")
  public void testSetText(String paramStr, Byte[] answerArray){
        arrayEditorSetText(ByteArrayEditor.class, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty(){
        return new Object[][]{
                {"test.ByteArrayEditor.value", "0x02", "${test.ByteArrayEditor.value}", new Byte[]{new Byte((byte)2)}},
                {"test.ByteArrayEditor.value", "0x02", "1,${test.ByteArrayEditor.value}", new Byte[]{new Byte((byte)1), new Byte((byte)2)}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.ByteArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.ByteArrayEditor#getValue()",
                    "Normal"},
  dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, Byte[] answerArray){
        arrayEditorSetTextSystemProperty(ByteArrayEditor.class, propertyKeyStr, propertyValStr, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsValue")
    public Object[][] dataSetAsValue(){
        return new Object[][]{
            {new Byte[]{(byte)1}, "1"},
            {new Byte[]{(byte)1, (byte)2}, "1,2"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.ByteArrayEditor#setAsValue(java.lang.Boolean)",
                    "jp.ossc.nimbus.beans.ByteArrayEditor#getAsText()",
                    "Normal"},
  dataProvider = "SetAsValue")
    public void testSetValue(Byte[] paramArray, String answerStr){
        arrayEditorSetValue(ByteArrayEditor.class, paramArray, answerStr);
    }
}
