/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;


import static org.testng.Assert.assertEquals;

import java.lang.reflect.Array;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link StringArrayEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class StringArrayEditorTest{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
                {"aaa", new String[]{"aaa"}},
                {"aaa,", new String[]{"aaa"}},
                {"aaa,bbb,", new String[]{"aaa", "bbb"}},
                {" \t aaa,    bbb   ,\n  \" c\\,cc  \" ", new String[]{"aaa", "    bbb   ", " c,cc  "}},
                {"aaa,<!--  bbb\n  -->,ccc", new String[]{"aaa", "ccc"}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.StringArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.StringArrayEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsText")
    public void testSetAsText(String paramStr, String[] answerArray){
        StringArrayEditor editor = new StringArrayEditor();
        editor.setAsText(paramStr);
        Object val = editor.getValue();
        int paramLength = answerArray.length;
        assertEquals(paramLength, Array.getLength(val));
        for(int i = 0 ; i < answerArray.length ; i++){
            assertEquals(Array.get(val, i), answerArray[i]);
        }
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty(){
        return new Object[][]{
            {"test.StringArrayEditor.value", "abc", "\\u3042aa,${test.StringArrayEditor.value}", new String[]{"aa", "abc"}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.StringArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.StringArrayEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, String[] answerArray){
        StringArrayEditor editor = new StringArrayEditor();
        System.setProperty(propertyKeyStr, propertyValStr);
        editor.setAsText(paramStr);
        Object val = editor.getValue();
        int paramLength = answerArray.length;
        assertEquals(paramLength, Array.getLength(val));
        for(int i = 0 ; i < answerArray.length ; i++){
            assertEquals(Array.get(val, i), answerArray[i]);
        }
    }
    
    @DataProvider(name = "SetValue")
    public Object[][] dataSetValue(){
        return new Object[][]{
                {new String[]{"aaa", "b,bb"}, "aaa,b\\,bb"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.StringArrayEditor#setValue(java.math.BigDecimal)",
                    "jp.ossc.nimbus.beans.StringArrayEditor#getAsText()",
                    "Normal"},
        dataProvider = "SetValue")
    public void testSetValue(Object[] param, String answerStr){
        StringArrayEditor editor = new StringArrayEditor();
        editor.setValue(param);
        assertEquals(editor.getAsText(), answerStr);
    }
}
