/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop;

import java.util.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.http.*;

import jp.ossc.nimbus.beans.*;
import jp.ossc.nimbus.core.*;

/**
 * T[ubgtB^̌ĂяogāA{@link InterceptorChainList}U蕪InterceptorChainListC^tF[X̎T[rXB<p>
 *
 * @author M.Takata
 */
public class SelectableServletFilterInterceptorChainListService
 extends ServiceBase
 implements SelectableServletFilterInterceptorChainListServiceMBean,
            InterceptorChainList{
    
    private static final long serialVersionUID = -3624632759924394508L;
    
    private Properties enabledURLMapping;
    private Map<Pattern, InterceptorChainList> enabledURLChainMapping;
    
    private Properties enabledURIMapping;
    private Map<Pattern, InterceptorChainList> enabledURIChainMapping;
    
    private Properties enabledPathMapping;
    private Map<Pattern, InterceptorChainList> enabledPathChainMapping;
    
    private Properties disabledURLMapping;
    private Map<Pattern, InterceptorChainList> disabledURLChainMapping;
    
    private Properties disabledURIMapping;
    private Map<Pattern, InterceptorChainList> disabledURIChainMapping;
    
    private Properties disabledPathMapping;
    private Map<Pattern, InterceptorChainList> disabledPathChainMapping;
    
    private ServiceName defaultInterceptorChainListServiceName;
    private InterceptorChainList defaultInterceptorChainList;
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public void setEnabledURLMapping(Properties mapping){
        enabledURLMapping = mapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public Properties getEnabledURLMapping(){
        return enabledURLMapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public void setEnabledURIMapping(Properties mapping){
        enabledURIMapping = mapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public Properties getEnabledURIMapping(){
        return enabledPathMapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public void setEnabledPathMapping(Properties mapping){
        enabledPathMapping = mapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public Properties getEnabledPathMapping(){
        return enabledPathMapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public void setDisabledURLMapping(Properties mapping){
        disabledURLMapping = mapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public Properties getDisabledURLMapping(){
        return disabledURLMapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public void setDisabledURIMapping(Properties mapping){
        disabledURIMapping = mapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public Properties getDisabledURIMapping(){
        return disabledPathMapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public void setDisabledPathMapping(Properties mapping){
        disabledPathMapping = mapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public Properties getDisabledPathMapping(){
        return disabledPathMapping;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public void setDefaultInterceptorChainListServiceName(ServiceName name){
        defaultInterceptorChainListServiceName = name;
    }
    
    // SelectableServletFilterInterceptorChainListServiceMBeanJavaDoc
    @Override
    public ServiceName getDefaultInterceptorChainListServiceName(){
        return defaultInterceptorChainListServiceName;
    }
    
    /**
     * T[rX̐sB<p>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        enabledURLChainMapping = new HashMap<Pattern, InterceptorChainList>();
        enabledURIChainMapping = new HashMap<Pattern, InterceptorChainList>();
        enabledPathChainMapping = new HashMap<Pattern, InterceptorChainList>();
        disabledURLChainMapping = new HashMap<Pattern, InterceptorChainList>();
        disabledURIChainMapping = new HashMap<Pattern, InterceptorChainList>();
        disabledPathChainMapping = new HashMap<Pattern, InterceptorChainList>();
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        
        final ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(getServiceManagerName());
        
        if(enabledURLMapping != null && enabledURLMapping.size() != 0){
            initMapping(editor, enabledURLMapping, enabledURLChainMapping);
        }
        
        if(enabledURIMapping != null && enabledURIMapping.size() != 0){
            initMapping(editor, enabledURIMapping, enabledURIChainMapping);
        }
        
        if(enabledPathMapping != null && enabledPathMapping.size() != 0){
            initMapping(editor, enabledPathMapping, enabledPathChainMapping);
        }
        
        if(disabledURLMapping != null && disabledURLMapping.size() != 0){
            initMapping(editor, disabledURLMapping, disabledURLChainMapping);
        }
        
        if(disabledURIMapping != null && disabledURIMapping.size() != 0){
            initMapping(editor, disabledURIMapping, disabledURIChainMapping);
        }
        
        if(disabledPathMapping != null && disabledPathMapping.size() != 0){
            initMapping(editor, disabledPathMapping, disabledPathChainMapping);
        }
        
        if(defaultInterceptorChainListServiceName != null){
            defaultInterceptorChainList
                 = (InterceptorChainList)ServiceManagerFactory
                    .getServiceObject(defaultInterceptorChainListServiceName);
        }
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    @Override
    public void stopService() throws Exception{
        enabledURLChainMapping.clear();
        enabledURIChainMapping.clear();
        enabledPathChainMapping.clear();
        disabledURLChainMapping.clear();
        disabledURIChainMapping.clear();
        disabledPathChainMapping.clear();
    }
    
    /**
     * T[rX̔jsB<p>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        enabledURLChainMapping = null;
        enabledURIChainMapping = null;
        enabledPathChainMapping = null;
        disabledURLChainMapping = null;
        disabledURIChainMapping = null;
        disabledPathChainMapping = null;
    }
    
    private void initMapping(
        ServiceNameEditor editor,
        Properties mapping,
        Map<Pattern, InterceptorChainList> chainMapping
    ){
        final Iterator<Object> urls = mapping.keySet().iterator();
        while(urls.hasNext()){
            final String url = (String)urls.next();
            final Pattern pattern = Pattern.compile(url);
            
            final String serviceNameStr = mapping.getProperty(url);
            editor.setAsText(serviceNameStr);
            final ServiceName name = (ServiceName)editor.getValue();;
            final InterceptorChainList chain = (InterceptorChainList)
                ServiceManagerFactory.getServiceObject(name);
            
            chainMapping.put(pattern, chain);
        }
    }
    
    /**
     * w肳ꂽCfbNX̃C^[Zv^擾B<p>
     * Ŏw肳ꂽĂяoReLXg{@link ServletFilterInvocationContext}ɃLXgāANGXg̃pX擾ÃpXɃ}bsOꂽ{@link InterceptorChainList}AC^[Zv^擾B<br>
     *
     * @param context ĂяõReLXgB{@link ServletFilterInvocationContext}łȂ΂ȂȂB
     * @param index C^[Zv^̃`F[̃CfbNX
     * @return w肳ꂽCfbNX̃C^[Zv^Bw肳ꂽCfbNX̃C^[Zv^݂Ȃꍇ́AnullԂ
     */
    @Override
    public Interceptor getInterceptor(InvocationContext context, int index){
        if(getState() != State.STARTED){
            return null;
        }
        InterceptorChainList chainList = null;
        final ServletFilterInvocationContext filtreContext
             = (ServletFilterInvocationContext)context;
        final ServletRequest request = filtreContext.getServletRequest();
        if(request instanceof HttpServletRequest){
            final HttpServletRequest httpReq = (HttpServletRequest)request;
            if(enabledURLChainMapping.size() != 0){
                final String reqURL = httpReq.getRequestURL().toString();
                chainList = selectInterceptorChainList(
                    reqURL,
                    enabledURLChainMapping,
                    true
                );
            }
            if(chainList == null && enabledURIChainMapping.size() != 0){
                final String reqURI = httpReq.getRequestURI().toString();
                chainList = selectInterceptorChainList(
                    reqURI,
                    enabledURIChainMapping,
                    true
                );
            }
            if(chainList == null && enabledPathChainMapping.size() != 0){
                String reqPath = httpReq.getPathInfo();
                if(reqPath == null){
                    reqPath = httpReq.getServletPath();
                }
                chainList = selectInterceptorChainList(
                    reqPath,
                    enabledPathChainMapping,
                    true
                );
            }
            if(chainList == null && disabledURLChainMapping.size() != 0){
                final String reqURL = httpReq.getRequestURL().toString();
                chainList = selectInterceptorChainList(
                    reqURL,
                    disabledURLChainMapping,
                    false
                );
            }
            if(chainList == null && disabledURIChainMapping.size() != 0){
                final String reqURI = httpReq.getRequestURI().toString();
                chainList = selectInterceptorChainList(
                    reqURI,
                    disabledURIChainMapping,
                    false
                );
            }
            if(chainList == null && disabledPathChainMapping.size() != 0){
                String reqPath = httpReq.getPathInfo();
                if(reqPath == null){
                    reqPath = httpReq.getServletPath();
                }
                chainList = selectInterceptorChainList(
                    reqPath,
                    disabledPathChainMapping,
                    false
                );
            }
        }
        if(chainList == null){
            chainList = defaultInterceptorChainList;
        }
        if(chainList == null){
            return null;
        }
        return chainList.getInterceptor(context, index);
    }
    
    private InterceptorChainList selectInterceptorChainList(
        String target,
        Map<Pattern, InterceptorChainList> patternMapping,
        boolean isMatch
    ){
        for(Map.Entry<Pattern, InterceptorChainList> entry : patternMapping.entrySet()){
            final Pattern pattern = entry.getKey();
            final Matcher m = pattern.matcher(target);
            if(m.matches() == isMatch){
                return entry.getValue();
            }
        }
        return null;
    }
}
