/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;

/**
 * {@link ReturnInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see ReturnInterceptorService
 */
public interface ReturnInterceptorServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * L/ݒ肷B<p>
     *
     * @param enabled Lɂꍇ́Atrue
     */
    public void setEnabled(boolean enabled);
    
    /**
     * L/𔻒肷B<p>
     *
     * @return truȅꍇAL
     */
    public boolean isEnabled();
    
    /**
     * Ăяo{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}ɑ΂Ɩ߂lݒ肷B<p>
     * ́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)gpB<br>
     * InvocationContext̃vpeBQƂꍇ́Aprop:get(context, "vpeB")Ŏw肷BŌAvpeB̊TÓAJava Beans̃vpeB̊TOLA{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]B<br>
     *
     * @param condition 
     * @param value ߂l
     */
    public void setReturnValue(String condition, Object value);
    
    /**
     * Ăяo{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}ɑ΂ɑΉ߂l擾B<p>
     *
     * @param condition 
     * @return ߂l
     */
    public Object getReturnValue(String condition);
    
    /**
     * ߂lݒ肷B<p>
     *
     * @param value ߂l
     */
    public void setReturnValue(Object value);
    
    /**
     * ߂l擾B<p>
     *
     * @return ߂l
     */
    public Object getReturnValue();
    
    /**
     * Ăяo{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}ɑ΂Ɩ߂T[rXݒ肷B<p>
     * ́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)gpB<br>
     * InvocationContext̃vpeBQƂꍇ́Aprop:get(context, "vpeB")Ŏw肷BŌAvpeB̊TÓAJava Beans̃vpeB̊TOLA{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]B<br>
     *
     * @param condition 
     * @param name ߂T[rX
     */
    public void setReturnServiceName(String condition, ServiceName name);
    
    /**
     * Ăяo{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}ɑ΂ɑΉ߂T[rX擾B<p>
     *
     * @param condition 
     * @return ߂T[rX
     */
    public ServiceName getReturnServiceName(String condition);
    
    /**
     * ߂T[rXݒ肷B<p>
     *
     * @param name ߂T[rX
     */
    public void setReturnServiceName(ServiceName name);
    
    /**
     * ߂T[rX擾B<p>
     *
     * @return ߂T[rX
     */
    public ServiceName getReturnServiceName();
    
    /**
     * ߂lbvۂ̃C^[tF[Xݒ肷B<p>
     *
     * @param clazz C^[tF[X
     */
    public void setReturnInterfaceClass(Class<?> clazz);
    
    /**
     * ߂lbvۂ̃C^[tF[X擾B<p>
     *
     * @return C^[tF[X
     */
    public Class<?> getReturnInterfaceClass();
    
    /**
     * ߂lbvvLVɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rXݒ肷B<p>
     *
     * @param name InterceptorChainListT[rX̃T[rX
     */
    public void setInterceptorChainListServiceName(ServiceName name);
    
    /**
     * ߂lbvvLVɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rX擾B<p>
     *
     * @return InterceptorChainListT[rX̃T[rX
     */
    public ServiceName getInterceptorChainListServiceName();
}