/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.util.*;

/**
 * LbV}bvB<p>
 * {@link Map}C^tF[XLbVB<br>
 *
 * @author M.Takata
 */
public interface CacheMap<K, V> extends Map<K, V>{
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽLbVQƂ擾B<p>
     *
     * @param key LbṼL[
     * @return LbVQ
     */
    public KeyCachedReference<K, V> getCachedReference(Object key);
    
    /**
     * SẴLbV폜B<p>
     */
    public void clear();
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽLbVIuWFNg݂邩ׂB<p>
     *
     * @param key LbVIuWFNgɊ֘AtL[
     * @return w肳ꂽL[Ɋ֘AtꂽLbVIuWFNg݂ꍇtrue
     */
    public boolean containsKey(Object key);
    
    /**
     * w肳ꂽLbVIuWFNg݂邩ׂB<p>
     *
     * @param value LbVIuWFNg
     * @return w肳ꂽLbVIuWFNg݂ꍇtrue
     */
    public boolean containsValue(Object value);
    
    /**
     * LbV}bvɊ܂܂ĂGg̏W擾B<p>
     * ̏W̓LbV}bvƘAĂ̂ŁALbV}bvɑ΂ύX͏WɔfA܂AWɑ΂ύX̓LbV}bvɔfB<br>
     * ̏Wɑ΂锽̏ɃLbV}bvύXꂽꍇ́Ǎʂ͕ۏ؂ȂB<br>
     * ̏ẂAIterator.removeASet.removeAremoveAllAretainAllA clear ̊eIy[VgăLbV}bvΉ}bsO폜vf폜T|[gB
     * add Iy[V addAll Iy[V́ȀWł̓T|[gĂȂB<br>
     *
     * @return LbV}bvɕێĂGg̏W
     */
    public Set<Map.Entry<K, V>> entrySet();
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽLbVIuWFNg擾B<p>
     *
     * @param key LbVIuWFNgɊ֘AtL[
     * @return w肳ꂽL[Ɋ֘AtꂽLbVIuWFNgB݂Ȃꍇnull
     */
    public V get(Object key);
    
    /**
     * LbV}bv󂩂ǂׂB<p>
     *
     * @return LbV}bv̏ꍇtrue
     */
    public boolean isEmpty();
    
    /**
     * LbV}bvɊ܂܂ĂL[̏W擾B<p>
     * ̏W̓LbV}bvƘAĂ̂ŁALbV}bvɑ΂ύX͏WɔfA܂AWɑ΂ύX̓LbV}bvɔfB<br>
     * ̏Wɑ΂锽̏ɃLbV}bvύXꂽꍇ́Ǎʂ͕ۏ؂ȂB<br>
     * ̏ẂAIterator.removeASet.removeAremoveAllAretainAllA clear ̊eIy[VgăLbV}bvΉ}bsO폜vf폜T|[gB<br>
     * add Iy[V addAll Iy[V́ȀWł̓T|[gĂȂB<br>
     * 
     * @return LbV}bvɊ܂܂ĂL[̏W
     */
    public Set<K> keySet();
    
    /**
     * w肳ꂽLbVIuWFNgw肳ꂽL[Ɋ֘AtăLbVB<p>
     *
     * @param key LbVIuWFNgɊ֘AtL[
     * @param value LbVIuWFNg
     * @return w肳ꂽL[Ɋ֘AtĂÂLbVIuWFNgBÂLbVIuWFNg݂Ȃꍇnull
     */
    public V put(K key, V value);
    
    /**
     * w肳ꂽ}bvׂ̂Ẵ}bsÕLbV}bvɃRs[B<p>
     * 
     * @param map ̃LbV}bvɊi[}bsO
     */
    public void putAll(java.util.Map<? extends K,? extends V> map);
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽLbVIuWFNg폜B<p>
     *
     * @param key LbVIuWFNgɊ֘AtL[
     * @return 폜LbVIuWFNgBYLbVIuWFNg݂Ȃꍇnull
     */
    public V remove(Object key);
    
    /**
     * LbVĂIuWFNg̐擾B<p>
     *
     * @return LbVĂIuWFNg̐
     */
    public int size();
    
    /**
     * LbV}bvɊ܂܂ĂLbVIuWFNg̏W擾B<p>
     * ̏W̓LbV}bvƘAĂ̂ŁALbV}bvɑ΂ύX͏WɔfA܂AWɑ΂ύX̓LbV}bvɔfB<br>
     * ̏Wɑ΂锽̏ɃLbV}bvύXꂽꍇǍʂ͕ۏ؂ȂB<br>
     * ̏ẂAIterator.removeACollection.removeAremoveAllAretainAllA clear ̊eIy[VgăLbV}bvΉ}bsO폜vf폜T|[gB<br>
     * add Iy[V addAll Iy[V́ȀWł̓T|[gĂȂB<br>
     *
     * @return LbV}bvɕێĂLbVIuWFNg̏W
     */
    public Collection<V> values();
}
