/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.util.*;
import java.lang.ref.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.daemon.*;

/**
 * \tgQƂӂꓮT[rXB<p>
 * ӂꂽLbVIuWFNgAQƂ\tgQƂɕύXAɉiLbVɉi邠ӂꓮłB<br>
 * ȉɁAiLbVƂăt@CLbVgp\tgQƂӂꓮT[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="SoftReferenceOverflowAction"
 *                  code="jp.ossc.nimbus.service.cache.SoftReferenceOverflowActionService"&gt;
 *             &lt;attribute name="PersistCacheServiceName"&gt;#FileCache&lt;/attribute&gt;
 *             &lt;depends&gt;FileCache&lt;/depends&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="FileCache"
 *                  code="jp.ossc.nimbus.service.cache.FileCacheService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class SoftReferenceOverflowActionService<E> extends ServiceBase
 implements OverflowAction<E>, LinkedReference<E>, CacheRemoveListener<E>,
            CacheChangeListener<E>, DaemonRunnable<SoftReferenceOverflowActionService.CachedSoftReference<E>>, java.io.Serializable,
            SoftReferenceOverflowActionServiceMBean{
    
    private static final long serialVersionUID = 6278424846147595060L;
    
    // bZ[WID`
    private static final String SROA_ = "SROA_";
    private static final String SROA_0 = SROA_ + 0;
    private static final String SROA_00 = SROA_0 + 0;
    private static final String SROA_000 = SROA_00 + 0;
    private static final String SROA_0000 = SROA_000 + 0;
    private static final String SROA_00001 = SROA_0000 + 1;
    private static final String SROA_00002 = SROA_0000 + 2;
    
    private ServiceName cacheServiceName;
    private Cache<E> cache;
    
    private ServiceName cacheMapServiceName;
    private CacheMap<Object, E> cacheMap;
    
    private OverflowController<E> controller;
    
    private Map<CachedReference<E>, SoftCachedReference<E>> references;
    
    private ReferenceQueue<E> refQueue;
    
    /**
     * {@link Daemon}IuWFNgB<p>
     */
    protected Daemon daemon;
    
    // SoftReferenceOverflowActionServiceMBeanJavaDoc
    @Override
    public void setPersistCacheServiceName(ServiceName name){
        cacheServiceName = name;
    }
    
    // SoftReferenceOverflowActionServiceMBeanJavaDoc
    @Override
    public ServiceName getPersistCacheServiceName(){
        return cacheServiceName;
    }
    
    // SoftReferenceOverflowActionServiceMBeanJavaDoc
    @Override
    public void setPersistCacheMapServiceName(ServiceName name){
        cacheMapServiceName = name;
    }
    
    // SoftReferenceOverflowActionServiceMBeanJavaDoc
    @Override
    public ServiceName getPersistCacheMapServiceName(){
        return cacheMapServiceName;
    }
    
    /**
     * Cacheݒ肷B
     */
    public void setCache(Cache<E> cache) {
		this.cache = cache;
	}
    /**
     * CacheMapݒ肷B
     */
	public void setCacheMap(CacheMap<Object, E> cacheMap) {
		this.cacheMap = cacheMap;
	}

	/**
     * T[rX̐sB<p>
     * CX^Xϐ̏sB
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        references = Collections.synchronizedMap(new HashMap<CachedReference<E>, SoftCachedReference<E>>());
        refQueue = new ReferenceQueue<E>();
        daemon = new Daemon(this);
        daemon.setName("Nimbus SoftReferenceOverflowActionDaemon " + getServiceNameObject());
    }
    
    /**
     * T[rX̊JnsB<p>
     * ޔ̃LbVT[rX̎擾Ayу\tgQƂɂLbVIuWFNgKx[WRNĝĎf[Xbh̊JnsB<br>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(cacheServiceName != null){
            cache = ServiceManagerFactory
                .getServiceObject(cacheServiceName);
        }
        if(cacheMapServiceName != null){
            cacheMap = ServiceManagerFactory
                .getServiceObject(cacheMapServiceName);
        }
        
        // f[N
        daemon.start();
    }
    
    /**
     * T[rX̒~sB<p>
     * ޔ̃LbVT[rXQƂ̊JAyу\tgQƂɂLbVIuWFNgKx[WRNĝĎf[Xbh̒~sB<br>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    @Override
    public void stopService() throws Exception{
        
        // f[~
        daemon.stop();
        
        cache = null;
        cacheMap = null;
    }
    
    /**
     * T[rX̔jsB<p>
     * CX^Xϐ̊JsB
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        references = null;
        refQueue = null;
        daemon = null;
    }
    
    // OverflowActionJavaDoc
    @Override
    public void setOverflowController(OverflowController<E> controller){
        this.controller = controller;
    }
    
    /**
     * ӂꂽLbVIuWFNgQƂ\tgQƂɕύXƓɁAiLbVɑޔB<p>
     *
     * @param validator ӂꌟ؂sOverflowValidator
     * @param algorithm ӂLbVQƂ肵OverflowAlgorithm
     * @param ref ӂꂽLbVQ
     */
    @SuppressWarnings("unchecked")
    @Override
    public void action(
        OverflowValidator<E> validator,
        OverflowAlgorithm<E> algorithm,
        CachedReference<E> ref
    ){
        if(ref == null || references == null){
            return;
        }
        synchronized(references){
            final E obj = ref.get(this, false);
            if(obj == null){
                return;
            }
            CachedReference<E> persistRef = null;
            if(ref instanceof KeyCachedReference && cacheMap != null){
                final KeyCachedReference<Object, E> keyRef = (KeyCachedReference<Object, E>)ref;
                final Object key = keyRef.getKey();
                if(key != null && obj != null){
                    cacheMap.put(key, obj);
                    persistRef = cacheMap.getCachedReference(key);
                }
            }else if(cache != null){
                if(obj != null){
                    persistRef = cache.add(obj);
                }
            }
            try{
                final SoftCachedReference<E> newRef = new SoftCachedReference<E>(
                    obj,
                    ref,
                    persistRef,
                    refQueue
                );
                references.put(ref, newRef);
                
                ref.addLinkedReference(this);
                ref.addCacheRemoveListener(this);
                ref.addCacheChangeListener(this);
                ref.set(this, null);
                
                if(validator != null){
                    validator.remove(ref);
                }
                if(algorithm != null){
                    algorithm.remove(ref);
                }
            }catch(IllegalCachedReferenceException e){
                getLogger().write(SROA_00001, e);
                if(persistRef != null){
                    persistRef.remove(this);
                }
                return;
            }
            if(persistRef != null && ref.isRemoved()){
                persistRef.remove(this);
            }
        }
    }
    
    /**
     * ӂꓮs邽߂ɕێĂB<p>
     */
    @Override
    public void reset(){
        if(references != null){
            references.clear();
        }
    }
    
    @Override
    public int size(){
        return references == null ? 0 : references.size();
    }
    
    /**
     * \tgQƂ܂͉iLbVLbVIuWFNg擾B<p>
     *
     * @param ref Qƌ̃LbVQ
     * @return LbVIuWFNg
     */
    @Override
    public E get(CachedReference<E> ref){
        if(ref == null || references == null){
            return null;
        }
        synchronized(references){
            final CachedReference<E> newRef
                 = references.get(ref);
            E obj = null;
            if(newRef != null){
                obj = newRef.get(this);
                try{
                    ref.set(this, obj);
                    newRef.remove(this);
                    references.remove(ref);
                    ref.removeLinkedReference(this);
                    ref.removeCacheRemoveListener(this);
                    ref.removeCacheChangeListener(this);
                    if(controller != null){
                        controller.control(ref);
                    }
                }catch(IllegalCachedReferenceException e){
                    getLogger().write(SROA_00002, obj, e);
                }
            }
            return obj;
        }
    }
    
    /**
     * LbV폜ꂽLbVQƂ̒ʒm󂯂B<p>
     * 폜ꂽLbVQƂɃN\tgLbVQƂ폜B<br>
     *
     * @param ref LbV폜ꂽLbVQ
     */
    @Override
    public void removed(CachedReference<E> ref){
        if(references == null){
            return;
        }
        synchronized(references){
            if(references.containsKey(ref)){
                final CachedReference<E> newRef
                     = references.remove(ref);
                newRef.remove(this);
                ref.removeLinkedReference(this);
                ref.removeCacheRemoveListener(this);
                ref.removeCacheChangeListener(this);
            }
        }
    }
    
    /**
     * LbVQƂ̃LbVIuWFNgύXꂽʒm󂯂B<p>
     * ύXꂽLbVQƂɃN\tgLbVQƂ폜B<br>
     *
     * @param ref ύXꂽLbVIuWFNg̃LbVQ
     * @param obj ύX̃LbVIuWFNg
     */
    @Override
    public void changed(CachedReference<E> ref, E obj){
        if(references == null){
            return;
        }
        synchronized(references){
            if(references != null && references.containsKey(ref)){
                final CachedReference<E> newRef
                     = references.remove(ref);
                newRef.remove(this);
                ref.removeLinkedReference(this);
                ref.removeCacheRemoveListener(this);
                ref.removeCacheChangeListener(this);
            }
        }
    }
    
    /**
     * f[JnɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onStart() {
        return true;
    }
    
    /**
     * f[~ɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onStop() {
        return true;
    }
    
    /**
     * f[fɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onSuspend() {
        return true;
    }
    
    /**
     * f[ĊJɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onResume() {
        return true;
    }
    
    /**
     * Kx[Wꂽ\tgQƂo^QƃL[L[҂āAPoĕԂB<p>
     * 
     * @param ctrl DaemonControlIuWFNg
     * @return Kx[Wꂽ\tgQ
     */
    @SuppressWarnings("unchecked")
    @Override
    public CachedSoftReference<E> provide(DaemonControl ctrl){
        if(refQueue == null){
            return null;
        }
        try{
            return (CachedSoftReference<E>)refQueue.remove();
        }catch(InterruptedException e){
            return null;
        }
    }
    
    /**
     * \tgQƂKx[WƁA̎gp󋵂ύXĂ\邽߁AӂꐧsB<p>
     *
     * @param dequeued Kx[Wꂽ\tgQ
     * @param ctrl DaemonControlIuWFNg
     */
    @Override
    public void consume(CachedSoftReference<E> dequeued, DaemonControl ctrl){
        if(dequeued == null || controller == null){
            return;
        }
        if(dequeued.getPersistCachedReference() == null){
            dequeued.getSourceCachedReference().remove(this);
        }
        controller.control(null);
    }
    
    /**
     * ȂB<p>
     */
    @Override
    public void garbage(){
    }
    
    /**
     * \tgLbVQƁB<p>
     * LbVIuWFNg\tgQƂɂƓɁAiLbVŊǗLbVQƂłB<br>
     *
     * @author M.Takata
     */
    protected static class SoftCachedReference<E> extends DefaultCachedReference<E>
     implements java.io.Serializable{
        
        private static final long serialVersionUID = -6567323403396424209L;
        
        /**
         * iLbVɃLbVLbVIuWFNg̃LbVQƁB<p>
         */
        protected CachedReference<E> persistRef;
        
        /**
         * LbVIuWFNg\tgQƂɂƓɁAiLbVŊǗLbVQƂ𐶐B<p>
         *
         * @param obj LbVIuWFNg
         * @param source ӂΏۂƂȂLbVIuWFNg̃LbVQ
         * @param persist iLbVɃLbVLbVIuWFNg̃LbVQ
         * @param refQueue QƃL[
         */
        public SoftCachedReference(E obj, CachedReference<E> source, CachedReference<E> persist, ReferenceQueue<E> refQueue){
            super(new CachedSoftReference<E>(source, persist, obj, refQueue));
            persistRef = persist;
        }
        
        /**
         * LbVꂽIuWFNg擾B<p>
         * truȅꍇ́A{@link #addCacheAccessListener(CacheAccessListener)}œo^ꂽ{@link CacheAccessListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheAccessListener̃CX^XƓꍇ́AʒmȂB<br>
         * gێ\tgQƂKx[WĂȂꍇ́AԂBKx[WĂꍇ́AiLbV擾ĕԂBiLbV擾łȂꍇ́A{@link #addLinkedReference(LinkedReference)}œo^ꂽ{@link LinkedReference}擾݂B<br>
         *
         * @param source LbV擾邱̃\bȟĂяoIuWFNg
         * @param notify LbVANZXXiɒʒmꍇtrue
         * @return LbVIuWFNg
         */
        @SuppressWarnings("unchecked")
        @Override
        public E get(Object source, boolean notify){
            E obj = ((CachedSoftReference<E>)cacheObj).get();
            if(obj == null && persistRef != null){
                obj = persistRef.get(this, notify);
            }
            if(obj == null){
                obj = getLinkedObject();
            }
            return obj;
        }
        
        /**
         * LbVIuWFNgݒ肷B<p>
         * T|[gȂB<br>
         *
         * @param source LbVIuWFNgύX邱̃\bȟĂяoIuWFNg
         * @param obj ݒ肷LbVIuWFNg
         * @exception UnsupportedOperationException T|[ĝߕKthrow
         */
        @Override
        public void set(Object source, E obj){
            throw new UnsupportedOperationException();
        }
        
        /**
         * LbVIuWFNg폜B<p>
         * \tgQƂƁAiLbV̗폜B<br>
         * {@link #addCacheRemoveListener(CacheRemoveListener)}œo^ꂽ{@link CacheRemoveListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheChangeListener̃CX^XƓꍇ́AʒmȂB<br>
         *
         * @param source LbVIuWFNg폜邱̃\bȟĂяoIuWFNg
         */
        @Override
        public void remove(Object source){
            super.remove(source);
            if(persistRef != null){
                persistRef.remove(this);
                persistRef = null;
            }
        }
    }
    
    /**
     * LbV\tgQƁB<p>
     * \tgQƂɂLbVQƂƁAɂiꂽiLbVQƂێB<br>
     *
     * @author M.Takata
     */
    protected static class CachedSoftReference<E> extends SoftReference<E>{
        
        /**
         * \tgQƂɂLbVQƁB<p>
         */
        protected CachedReference<E> sourceRef;
        
        /**
         * iꂽiLbVQƁB<p>
         */
        protected CachedReference<E> persistRef;
        
        /**
         * CX^X𐶐B<p>
         *
         * @param source ӂΏۂƂȂLbVIuWFNg̃LbVQ
         * @param persist iLbVɃLbVLbVIuWFNg̃LbVQ
         * @param obj LbVIuWFNg
         * @param refQueue QƃL[
         */
        public CachedSoftReference(
            CachedReference<E> source,
            CachedReference<E> persist,
            E obj,
            ReferenceQueue<E> refQueue
        ){
            super(obj, refQueue);
            sourceRef = source;
            persistRef = persist;
        }
        
        /**
         * \tgQƂɂLbVQƂ擾B<p>
         * 
         * @return LbVQ
         */
        public CachedReference<E> getSourceCachedReference(){
            return sourceRef;
        }
        
        /**
         * iꂽiLbVQƂ擾B<p>
         * 
         * @return LbVQ
         */
        public CachedReference<E> getPersistCachedReference(){
            return persistRef;
        }
    }
}
