/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The Nimbus Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.service.context;

/**
 * T[oB<p>
 *
 * @author M.Takata
 */
public interface ServerInfo extends Context<Object, Object>{
    
    /**
     * JRẼo[W擾L[B<p>
     */
    public static final String JAVA_VERSION_KEY = "JAVA_VERSION";
    
    /**
     * JRẼx_擾L[B<p>
     */
    public static final String JAVA_VENDOR_KEY = "JAVA_VENDOR";
    
    /**
     * JVM̖O擾L[B<p>
     */
    public static final String JAVA_VM_NAME_KEY = "JAVA_VM_NAME";
    
    /**
     * JVM̃o[W擾L[B<p>
     */
    public static final String JAVA_VM_VERSION_KEY = "JAVA_VM_VERSION";
    
    /**
     * JVM̃x_擾L[B<p>
     */
    public static final String JAVA_VM_VENDOR_KEY = "JAVA_VM_VENDOR";
    
    /**
     * OS̖O擾L[B<p>
     */
    public static final String OS_NAME_KEY = "OS_NAME";
    
    /**
     * OS̃o[W擾L[B<p>
     */
    public static final String OS_VERSION_KEY = "OS_VERSION";
    
    /**
     * OS̃A[LeN`擾L[B<p>
     */
    public static final String OS_ARCH_KEY = "OS_ARCH";
    
    /**
     * q[v݂̌̑eʂ擾L[B<p>
     */
    public static final String TOTAL_MEMORY_KEY = "TOTAL_MEMORY";
    
    /**
     * q[v݂̌̎gpʂ擾L[B<p>
     */
    public static final String USED_MEMORY_KEY = "USED_MEMORY";
    
    /**
     * q[v݂̌̋󂫗eʂ擾L[B<p>
     */
    public static final String FREE_MEMORY_KEY = "FREE_MEMORY";
    
    /**
     * q[v̍őeʂ擾L[B<p>
     */
    public static final String MAX_MEMORY_KEY = "MAX_MEMORY";
    
    /**
     * gp\CPU̐擾L[B<p>
     */
    public static final String AVAILABLE_PROCESSORS_KEY
         = "AVAILABLE_PROCESSORS";
    
    /**
     * zXg擾L[B<p>
     */
    public static final String HOST_NAME_KEY = "HOST_NAME";
    
    /**
     * zXg̃AhX擾L[B<p>
     */
    public static final String HOST_ADDRESS_KEY = "HOST_ADDRESS";
    
    /**
     * ݃ANeBuȃXbh擾L[B<p>
     */
    public static final String ACTIVE_THREAD_COUNT_KEY = "ACTIVE_THREAD_COUNT";
    
    /**
     * ݃ANeBuȃXbhO[v擾L[B<p>
     */
    public static final String ACTIVE_THREAD_GROUP_COUNT_KEY
         = "ACTIVE_THREAD_GROUP_COUNT";
    
    /**
     * JRẼo[W擾B<p>
     *
     * @return JRẼo[W
     */
    public String getJavaVersion();
    
    /**
     * JRẼx_擾B<p>
     *
     * @return JRẼx_
     */
    public String getJavaVendor();
    
    /**
     * JVM̖O擾B<p>
     *
     * @return JVM̖O
     */
    public String getJavaVMName();
    
    /**
     * JVM̃o[W擾B<p>
     *
     * @return JVM̃o[W
     */
    public String getJavaVMVersion();
    
    /**
     * JVM̃x_擾B<p>
     *
     * @return JVM̃x_
     */
    public String getJavaVMVendor();
    
    /**
     * OS̖O擾B<p>
     *
     * @return OS̖O
     */
    public String getOSName();
    
    /**
     * OS̃o[W擾B<p>
     *
     * @return OS̃o[W
     */
    public String getOSVersion();
    
    /**
     * OS̃A[LeN`擾B<p>
     *
     * @return OS̃A[LeN`
     */
    public String getOSArch();
    
    /**
     * ݂̃q[v̑e[byte]擾B<p>
     *
     * @return ݂̃q[v̑e[byte]
     */
    public long getTotalMemory();
    
    /**
     * ݂̃q[v̎gp[byte]擾B<p>
     *
     * @return ݂̃q[v̎gp[byte]
     */
    public long getUsedMemory();
    
    /**
     * ݂̃q[v̋󂫗e[byte]擾B<p>
     *
     * @return ݂̃q[v̋󂫗e[byte]
     */
    public long getFreeMemory();
    
    /**
     * q[v̍őe[byte]擾B<p>
     *
     * @return q[v̍őe[byte]
     */
    public long getMaxMemory();
    
    /**
     * gp\CPU̐擾B<p>
     *
     * @return gp\CPU̐
     */
    public int getAvailableProcessors();
    
    /**
     * zXg擾B<p>
     *
     * @return zXg
     */
    public String getHostName();
    
    /**
     * zXg̃AhX擾B<p>
     *
     * @return zXg̃AhX
     */
    public String getHostAddress();
    
    /**
     * ݃ANeBuȃXbh擾B<p>
     *
     * @return ݃ANeBuȃXbh
     */
    public int getActiveThreadCount();
    
    /**
     * ݃ANeBuȃXbhO[v擾B<p>
     *
     * @return ݃ANeBuȃXbhO[v
     */
    public int getActiveThreadGroupCount();
}