/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import java.util.Iterator;

/**
 * `[gB<p>
 *
 * @author k2-taniguchi
 */
public interface ChartCondition {

    /**
     * vbgǉB<p>
     *
     * @param plotCondition vbg
     */
    public void addPlotCondition(PlotCondition plotCondition);

    /**
     * w肳ꂽvbg̃vbgz擾B<p>
     *
     * @param plotName vbg
     * @return vbgz
     */
    public PlotCondition[] getPlotConditions(String plotName);

    /**
     * vbgz擾B<p>
     *
     * @return vbgz
     */
    public PlotCondition[] getPlotConditions();

    /**
     * vbg̃Ce[^擾B<p>
     *
     * @return vbg̃Ce[^
     */
    public Iterator<String> getPlotNames();

    /**
     * JFreeChart̃^Cgݒ肷B<p>
     *
     * @param title ^Cg
     */
    public void setTitle(String title);

    /**
     * JFreeChart̃^Cg擾B<p>
     *
     * @return ^Cg
     */
    public String getTitle();

    /**
     * JFreeChart̃^CgtHgݒ肷B<p>
     *
     * @param name tHg
     */
    public void setTitleFontName(String name);

    /**
     * JFreeChart̃^CgtHg擾B<p>
     *
     * @return tHg
     */
    public String getTitleFontName();

    /**
     * JFreeChart̃^CgtHgX^Cݒ肷B<p>
     *
     * @param style tHgX^C
     */
    public void setTitleFontStyle(int style);

    /**
     * JFreeChart̃^CgtHgX^C擾B<p>
     *
     * @return tHgX^C
     */
    public int getTitleFontStyle();

    /**
     * JFreeChart̃^CgtHgTCYݒ肷B<p>
     *
     * @param size tHgTCY
     */
    public void setTitleFontSize(int size);

    /**
     * JFreeChart̃^CgtHgTCY擾B<p>
     *
     * @return tHgTCY
     */
    public int getTitleFontSize();

    /**
     * ftHg̃Tu^CgtHgݒ肷B<p>
     *
     * @param name tHg
     */
    public void setDefaultSubtitleFontName(String name);

    /**
     * ftHg̃Tu^CgtHg擾B<p>
     *
     * @return tHg
     */
    public String getDefaultSubtitleFontName();

    /**
     * ftHg̃Tu^CgtHgX^Cݒ肷B<p>
     *
     * @param style tHgX^C
     */
    public void setDefaultSubtitleFontStyle(int style);

    /**
     * ftHg̃Tu^CgtHgX^C擾B<p>
     *
     * @return tHgX^C
     */
    public int getDefaultSubtitleFontStyle();

    /**
     * ftHg̃Tu^CgtHgTCYݒ肷B<p>
     *
     * @param size tHgTCY
     */
    public void setDefaultSubtitleFontSize(int size);

    /**
     * ftHg̃Tu^CgtHgTCY擾B<p>
     *
     * @return tHgTCY
     */
    public int getDefaultSubtitleFontSize();

    /**
     * w肳ꂽCfbNX̃Tu^CgtHgݒ肷B<p>
     *
     * @param index Tu^CgCfbNX
     * @param name tHg
     */
    public void setSubtitleFontName(int index, String name);

    /**
     * w肳ꂽCfbNX̃Tu^CgtHg擾B<p>
     *
     * @param index Tu^CgCfbNX
     * @return tHg
     */
    public String getSubtitleFontName(int index);

    /**
     * w肳ꂽCfbNX̃Tu^CgtHgX^Cݒ肷B<p>
     *
     * @param index Tu^CgCfbNX
     * @param style tHgX^C
     */
    public void setSubtitleFontStyle(int index, int style);

    /**
     * w肳ꂽCfbNX̃Tu^CgtHgX^C擾B<p>
     *
     * @param index Tu^CgCfbNX
     * @return tHgX^C
     */
    public int getSubtitleFontStyle(int index);

    /**
     * w肳ꂽCfbNX̃Tu^CgtHgTCYݒ肷B<p>
     *
     * @param index Tu^CgCfbNX
     * @param size tHgTCY
     */
    public void setSubtitleFontSize(int index, int size);

    /**
     * w肳ꂽCfbNX̃Tu^CgtHgTCY擾B<p>
     *
     * @param index Tu^CgCfbNX
     * @return tHgTCY
     */
    public int getSubtitleFontSize(int index);

}
