/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http;

import java.io.*;
import java.util.*;

/**
 * HTTPX|XB<p>
 *
 * @author M.Takata
 */
public interface HttpResponse{
    
    /**
     * X|XHTTPwb_̏W擾B<p>
     *
     * @return HTTPwb_̏W
     */
    public Set<String> getHeaderNameSet();
    
    /**
     * w肳ꂽOHTTPwb_擾B<p>
     * wb_ŕ̒lꍇ́Aŏ̒lB<br>
     *
     * @return HTTPwb_
     */
    public String getHeader(String name);
    
    /**
     * w肳ꂽOHTTPwb_擾B<p>
     *
     * @return HTTPwb_z
     */
    public String[] getHeaders(String name);
    
    /**
     * X|X̕GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getCharacterEncoding();
    
    /**
     * X|XHTTPXe[^X擾B<p>
     *
     * @return HTTPXe[^X
     */
    public int getStatusCode();
    
    /**
     * X|XHTTPXe[^XbZ[W擾B<p>
     *
     * @return HTTPXe[^XbZ[W
     */
    public String getStatusMessage();
    
    /**
     * X|XXg[擾B<p>
     *
     * @return X|XXg[
     */
    public InputStream getInputStream() throws IOException;
    
    /**
     * X|XXg[ǂݍ񂾉IuWFNg擾B<p>
     *
     * @return IuWFNg
     */
    public <T> T getObject();
    
    /**
     * X|XXg[ǂݍ񂾉IuWFNg擾B<p>
     *
     * @param bind IuWFNg
     * @return IuWFNg
     */
    public <T> T getObject(T bind);
    
    /**
     * IɐڑؒfB<p>
     */
    public void close();
}