/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.*;

import jp.ossc.nimbus.core.*;

/**
 * HTTPvLṼNGXgsۃNXB<p>
 * 
 * @author M.Takata
 */
public abstract class HttpProcessServiceBase extends ServiceBase
 implements HttpProcessServiceBaseMBean, Process{
    
    private static final long serialVersionUID = 7809414473826320613L;
    
    private boolean isRequestStreamInflate = true;
    
    // HttpProcessServiceBaseMBean JavaDoc
    public void setRequestStreamInflate(boolean isInflate){
        isRequestStreamInflate = isInflate;
    }
    
    // HttpProcessServiceBaseMBean JavaDoc
    public boolean isRequestStreamInflate(){
        return isRequestStreamInflate;
    }
    
    // ProcessJavaDoc
    public void doProcess(InputStream is, OutputStream os) throws Exception{
        
        HttpRequest request = null;
        try{
            request = new HttpRequest(is);
            if(request.body != null){
                request.body.setDecompress(isRequestStreamInflate());
            }
        }catch(Exception e){
            HttpResponse response = new HttpResponse();
            response.setStatusCode(400);
            response.setStatusMessage(e.getMessage());
            PrintStream ps = new PrintStream(response.getOutputStream());
            e.printStackTrace(ps);
            ps.flush();
            response.writeResponse(request, os);
            return;
        }
        
        HttpResponse response = new HttpResponse();
        response.setVersion(request.getHeader().getVersion());
        
        try{
            doProcess(request, response);
        }catch(Exception e){
            response.setStatusCode(500);
            response.setStatusMessage(e.getMessage());
            PrintStream ps = new PrintStream(response.getOutputStream());
            e.printStackTrace(ps);
            ps.flush();
            response.writeResponse(request, os);
            return;
        }
        
        response.writeResponse(request, os);
    }
    
    /**
     * HTTPNGXg̃vLVsB<p>
     *
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @exception Exception HTTPNGXg̏Ɏsꍇ
     */
    public abstract void doProcess(
        HttpRequest request,
        HttpResponse response
    ) throws Exception;
}