/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import java.util.*;
import javax.jms.*;

import jp.ossc.nimbus.core.*;

/**
 * JMSZbVt@NgB<p>
 * javax.jms.ConnectionbvAJMSZbV̐ȗB<br>
 * ܂AꂽJMSZbV̊JRh~@\B<br>
 * QueueTopĩC^tF[XꂽJMS 1.1ɑΉĂ܂BJMS 1.1ȑÕo[WŎgpꍇɂ́ATuNX{@link JMSQueueSessionFactoryService}A{@link JMSTopicSessionFactoryService}gpĉB<br>
 * 
 * @author M.Takata
 */
public class JMSSessionFactoryService extends ServiceBase
 implements JMSSessionFactory, JMSSessionFactoryServiceMBean{
    
    private static final long serialVersionUID = 5981302065231856716L;
    
    protected ServiceName jmsConnectionFactoryServiceName;
    protected JMSConnectionFactory jmsConnectionFactory;
    
    protected String ackModeStr = AUTO_ACKNOWLEDGE;
    protected int ackMode = Session.AUTO_ACKNOWLEDGE;
    
    protected boolean transactionMode;
    
    protected Connection connection;
    protected boolean isConnectionCreate = true;
    protected Set<Session> sessions;
    protected boolean isStartConnection;
    protected boolean isStopConnection;
    protected boolean isCloseConnection;
    protected boolean isSessionManagement;
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setSessionManagement(boolean isManaged){
        isSessionManagement = isManaged;
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public boolean isSessionManagement(){
        return isSessionManagement;
    }
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setJMSConnectionFactoryServiceName(ServiceName name){
        jmsConnectionFactoryServiceName = name;
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public ServiceName getJMSConnectionFactoryServiceName(){
        return jmsConnectionFactoryServiceName;
    }
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setAcknowledgeMode(String mode){
        if(AUTO_ACKNOWLEDGE.equals(ackModeStr)){
            ackModeStr = mode;
            ackMode = Session.AUTO_ACKNOWLEDGE;
        }else if(CLIENT_ACKNOWLEDGE.equals(ackModeStr)){
            ackModeStr = mode;
            ackMode = Session.CLIENT_ACKNOWLEDGE;
        }else if(DUPS_OK_ACKNOWLEDGE.equals(ackModeStr)){
            ackModeStr = mode;
            ackMode = Session.DUPS_OK_ACKNOWLEDGE;
        }else{
            throw new IllegalArgumentException(mode);
        }
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public String getAcknowledgeMode(){
        return ackModeStr;
    }
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setTransactionMode(boolean isTransacted){
        transactionMode = isTransacted;
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public boolean getTransactionMode(){
        return transactionMode;
    }
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setConnectionCreate(boolean isCreate){
        isConnectionCreate = isCreate;
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public boolean isConnectionCreate(){
        return isConnectionCreate;
    }
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setStartConnection(boolean isStart){
        isStartConnection = isStart;
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public boolean isStartConnection(){
        return isStartConnection;
    }
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setStopConnection(boolean isStop){
        isStopConnection = isStop;
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public boolean isStopConnection(){
        return isStopConnection;
    }
    
    // JMSSessionFactoryServiceMBeanJavaDoc
    public void setCloseConnection(boolean isClose){
        isCloseConnection = isClose;
    }
    // JMSSessionFactoryServiceMBeanJavaDoc
    public boolean isCloseConnection(){
        return isCloseConnection;
    }
    
    /**
     * {@link JMSConnectionFactory}T[rXݒ肷B<p>
     * ConnectionCreatetruȅꍇAT[rX̊JnɁAŐݒ肳ꂽJMSConnectionFactoryT[rXgāAConnection𐶐ێB<br>
     * ConnectionCreatefalsȅꍇAŏSession擾悤ƂɁAConnection𐶐ێB<br>
     *
     * @param jmsConnectionFactory JMSConnectionFactoryT[rX
     */
    public void setJMSConnectionFactory(JMSConnectionFactory jmsConnectionFactory) {
        this.jmsConnectionFactory = jmsConnectionFactory;
    }
    
    /**
     * T[rX̐sB<p>
     *
     * @exception Exception Ɏsꍇ
     */
    public void createService() throws Exception{
        sessions = new HashSet<Session>();
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception JnɎsꍇ
     */
    public void startService() throws Exception{
        
        if(jmsConnectionFactoryServiceName != null){
            jmsConnectionFactory
                 = (JMSConnectionFactory)ServiceManagerFactory
                    .getServiceObject(jmsConnectionFactoryServiceName);
        }
        if(isConnectionCreate){
            if(jmsConnectionFactory == null){
                throw new IllegalArgumentException(
                    "jmsConnectionFactoryServiceName must be specified."
                );
            }
            connection = jmsConnectionFactory.getConnection();
            if(isStartConnection){
                connection.start();
            }
        }
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception ~Ɏsꍇ
     */
    public void stopService() throws Exception{
        
        if(isStopConnection && connection != null){
            try{
                connection.stop();
            }catch(JMSException e){
            }
        }
        if(isCloseConnection && connection != null){
            try{
                connection.close();
            }catch(JMSException e){
            }
        }
        connection = null;
        
        if(sessions != null && sessions.size() != 0){
            for(Session s : sessions){
                try{
                    s.close();
                }catch(JMSException e){
                }
            }
            sessions.clear();
        }
        
        jmsConnectionFactory = null;
    }
    
    /**
     * T[rX̔jsB<p>
     *
     * @exception Exception jɎsꍇ
     */
    public void destroyService() throws Exception{
        sessions = null;
    }
    
    // JMSSessionFactoryJavaDoc
    public Connection getConnection(){
        return connection;
    }
    
    // JMSSessionFactoryJavaDoc
    public JMSConnectionFactory getConnectionFactory(){
        return jmsConnectionFactory;
    }
    
    // JMSSessionFactoryJavaDoc
    public Session getSession() throws JMSSessionCreateException{
        Connection con = connection;
        if(con == null){
            try{
                con = jmsConnectionFactory.getConnection();
            }catch(JMSConnectionCreateException e){
                throw new JMSSessionCreateException(e);
            }
        }
        return getSession(con);
    }
    
    // JMSSessionFactoryJavaDoc
    public Session getSession(
        boolean transactionMode,
        int ackMode
    ) throws JMSSessionCreateException{
        Connection con = connection;
        if(con == null){
            try{
                con = jmsConnectionFactory.getConnection();
                if(isStartConnection){
                    con.start();
                }
            }catch(JMSException e){
                throw new JMSSessionCreateException(e);
            }catch(JMSConnectionCreateException e){
                throw new JMSSessionCreateException(e);
            }
        }
        return getSession(con, transactionMode, ackMode);
    }
    
    // JMSSessionFactoryJavaDoc
    public Session getSession(Connection con) throws JMSSessionCreateException{
        return getSession(con, transactionMode, ackMode);
    }
    
    // JMSSessionFactoryJavaDoc
    public Session getSession(
        Connection con,
        boolean transactionMode,
        int ackMode
    ) throws JMSSessionCreateException{
        try{
            final Session session = con.createSession(
                transactionMode,
                ackMode
            );
            if(isSessionManagement){
                sessions.add(session);
            }
            return session;
        }catch(JMSException e){
            throw new JMSSessionCreateException(e);
        }
    }
}
