/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link ClusterConnectionFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ClusterConnectionFactoryService
 */
public interface ClusterConnectionFactoryServiceMBean extends ServiceBaseMBean{
    
    public static final String MSG_ID_CONNECT_ERROR = "PCCF_00001";
    public static final String MSG_ID_RECONNECT     = "PCCF_00003";
    public static final String MSG_ID_NOCONNECT_ERROR = "PCCF_00004";
    
    /**
     * {@link ClientConnectionFactory ClientConnectionFactory}[gIuWFNgJNDIݒ肷B<p>
     * ftHǵA{@link ClientConnectionFactory#DEFAULT_JNDI_NAME}B<br>
     *
     * @param name JNDI
     */
    public void setJndiName(String name);
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgJNDI擾B<p>
     *
     * @return JNDI
     */
    public String getJndiName();
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name RepositoryT[rX̃T[rX
     */
    public void setJndiRepositoryServiceName(ServiceName name);
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rX擾B<p>
     * 
     * @return RepositoryT[rX̃T[rX
     */
    public ServiceName getJndiRepositoryServiceName();
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgRMIʐM|[gԍݒ肷B<p>
     *
     * @param port |[gԍ
     */
    public void setRMIPort(int port);
    
    /**
     * {@link ClientConnectionFactory}[gIuWFNgRMIʐM|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getRMIPort();
    
    /**
     * {@link jp.ossc.nimbus.service.keepalive.ClusterService ClusterService}T[rX̃T[rXݒ肷B<p>
     * NX^̃o[ɁA{@link ClientConnectionFactory}[gIuWFNgݒ肷鎖ŁANX^ɎQĂClientConnectionFactoryNCAgŋLB<br>
     *
     * @param name ClusterServiceT[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.keepalive.ClusterService ClusterService}T[rX̃T[rX擾B<p>
     *
     * @return ClusterServiceT[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * NX^{@link ClientConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ClientConnectionFactoryT[rX̃T[rX
     */
    public void setClientConnectionFactoryServiceName(ServiceName name);
    
    /**
     * NX^{@link ClientConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ClientConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getClientConnectionFactoryServiceName();
    
    /**
     * UNX^ɂ邩ǂݒ肷B<p>
     * trueɂƕUNX^ƂȂANCAǵAڑ䐔̏ȂNX^oɐڑAT[oɑ΂ĕUĐڑB<br>
     * ftHgfalseŁASẴNCAgnƂȂĂNX^oɐڑB<br>
     *
     * @param isDistribute UNX^ɂꍇtrue
     */
    public void setDistribute(boolean isDistribute);
    
    /**
     * UNX^ɂ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAUNX^
     */
    public boolean isDistribute();
    
    /**
     * dT[ozM邩ǂݒ肷B<p>
     * trueɂƑdT[ozMƂȂANCAg͕̃T[o烁bZ[W𓯎ɎMB<br>
     * ftHgfalseŁANCAǵAǂP̃T[oMB<br>
     *
     * @param isMultiple dT[ozMꍇAtrue
     */
    public void setMultiple(boolean isMultiple);
    
    /**
     * dT[ozM邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAdT[ozM
     */
    public boolean isMultiple();
    
    /**
     * g̃bZ[WM邩ǂݒ肷B<p>
     * ftHǵAfalseŎMȂB<br>
     * 
     * @param isReceive Mꍇtrue
     */
    public void setReceiveOwnMessage(boolean isReceive);
    
    /**
     * g̃bZ[WM邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇAM
     */
    public boolean isReceiveOwnMessage();
    
    /**
     * {@link ClientConnection#connect()}sɁANX^o݂ȂĂڑ\ȏ_ȐڑƂ邩ǂݒ肷B<p>
     * ftHǵAfalseŁANX^o݂Ȃꍇ́AڑłȂB<br>
     *
     * @param isFlexible _ȐڑƂꍇAtrue
     */
    public void setFlexibleConnect(boolean isFlexible);
    
    /**
     * {@link ClientConnection#connect()}sɁANX^o݂ȂĂڑ\ȏ_ȐڑƂ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA_Ȑڑ
     */
    public boolean isFlexibleConnect();
    
    /**
     * tFCI[o[ɍŌɎMbZ[W̎Mǂ̂炢̎[ms]kčđvoݒ肷B<p>
     * ftHǵA0[ms]ōŏIMđvB<br>
     *
     * @param time Mk鎞[ms]
     */
    public void setFailoverBufferTime(long time);
    
    /**
     * tFCI[o[ɍŌɎMbZ[W̎Mǂ̂炢̎[ms]kčđvo擾B<p>
     *
     * @return Mk鎞[ms]
     */
    public long getFailoverBufferTime();
    
    public void setClientConnectErrorMessageId(String id);
    public String getClientConnectErrorMessageId();
    
    public void setClientReconnectMessageId(String id);
    public String getClientReconnectMessageId();
    
    public void setClientNoConnectErrorMessageId(String id);
    public String getClientNoConnectErrorMessageId();
}
