/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.net.SocketAddress;
import java.util.Set;
import java.util.Map;
import java.util.Date;

import jp.ossc.nimbus.core.*;

/**
 * {@link ConnectionFactoryService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface ConnectionFactoryServiceMBean extends ServiceBaseMBean{
    
    public static final String MSG_ID_SEND_ERROR                = "PCFT_00001";
    public static final String MSG_ID_SEND_ERROR_RETRY_OVER     = "PCFT_00002";
    public static final String MSG_ID_RECEIVE_WARN              = "PCFT_00003";
    public static final String MSG_ID_RECEIVE_ERROR             = "PCFT_00004";
    public static final String MSG_ID_RESPONSE_ERROR            = "PCFT_00005";
    public static final String MSG_ID_CLIENT_LOST_MESSAGE_ERROR = "PCFT_00006";
    public static final String MSG_ID_SERVER_LOST_MESSAGE_ERROR = "PCFT_00007";
    public static final String MSG_ID_SERVER_CLOSE              = "PCFT_00008";
    
    /**
     * NCAgŃoCh郍[JAhXw肷VXevpeBݒ肷B<br>
     * ftHǵAwȂŁANCAg̃[vobNAhXɃoChB<br>
     *
     * @param name VXevpeB
     */
    public void setClientAddressPropertyName(String name);
    
    /**
     * NCAgŃoCh郍[JAhXw肷VXevpeB擾B<br>
     *
     * @return VXevpeB
     */
    public String getClientAddressPropertyName();
    
    /**
     * NCAgŃoCh郍[J|[gw肷VXevpeBݒ肷B<br>
     * ftHǵAwȂŁANCAg̔Cӂ̃|[gɃoChB<br>
     *
     * @param name VXevpeB
     */
    public void setClientPortPropertyName(String name);
    
    /**
     * NCAgŃoCh郍[J|[gw肷VXevpeB擾B<br>
     *
     * @return VXevpeB
     */
    public String getClientPortPropertyName();
    
    /**
     * NCAgŐڑؒfmꍇ̍Đڑs񐔂ݒ肷B<br>
     * ftHǵA0ōĐڑȂB<br>
     * Đڑꍇ́A{@link #setServerPort(int)}ŃT[õ|[gԍŒɂKvB<br>
     *
     * @param count Đڑs
     */
    public void setClientReconnectCount(int count);
    
    /**
     * NCAgŐڑؒfmꍇ̍Đڑs񐔂擾B<br>
     *
     * @return Đڑs
     */
    public int getClientReconnectCount();
    
    /**
     * NCAgŐڑؒfmꍇ̍ĐڑsԊu[ms]ݒ肷B<br>
     * ftHǵA0B<br>
     *
     * @param interval ĐڑsԊu[ms]
     */
    public void setClientReconnectInterval(long interval);
    
    /**
     * NCAgŐڑؒfmꍇ̍ĐڑsԊu[ms]擾B<br>
     *
     * @return ĐڑsԊu[ms]
     */
    public long getClientReconnectInterval();
    
    /**
     * NCAgŐڑؒfmꍇɍŌɎMbZ[W̎Mǂ̂炢̎[ms]kčđvoݒ肷B<p>
     * ftHǵA0[ms]ōŏIMđvB<br>
     *
     * @param time Mk鎞[ms]
     */
    public void setClientReconnectBufferTime(long interval);
    
    /**
     * NCAgŐڑؒfmꍇɍŌɎMbZ[W̎Mǂ̂炢̎[ms]kčđvo擾B<p>
     *
     * @return Mk鎞[ms]
     */
    public long getClientReconnectBufferTime();
    
    /**
     * NCAg{@link Window}XgƔf܂ł̃^CAEgݒ肷B<p>
     * ftHg1000[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setMissingWindowTimeout(long timeout);
    
    /**
     * NCAg{@link Window}XgƔf܂ł̃^CAEg擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getMissingWindowTimeout();
    
    /**
     * NCAg{@link Window}XgƔf܂ł̑ؗݒ肷B<p>
     * ftHg0ŁAؗł̓XgƔfȂB<br>
     *
     * @param count ؗ
     */
    public void setMissingWindowCount(int count);
    
    /**
     * NCAg{@link Window}XgƔf܂ł̑ؗ擾B<p>
     *
     * @return ؗ
     */
    public int getMissingWindowCount();
    
    /**
     * NCAg㑱̃bZ[WĂȂT[oփ|[OԊuݒ肷B<p>
     * ftHg5000[ms]B<br>
     *
     * @param interval |[OԊu[ms]
     */
    public void setNewMessagePollingInterval(long interval);
    
    /**
     * NCAg㑱̃bZ[WĂȂT[oփ|[OԊu擾B<p>
     *
     * @return |[OԊu[ms]
     */
    public long getNewMessagePollingInterval();
    
    /**
     * NCAgT[ỏ҂^CAEg[ms]ݒ肷B<p>
     * ftHǵA30bB<br>
     *
     * @param timeout ^CAEg
     */
    public void setClientResponseTimeout(long timeout);
    
    /**
     * NCAgT[ỏ҂^CAEg[ms]擾B<p>
     *
     * @return ^CAEg
     */
    public long getClientResponseTimeout();
    
    /**
     * T[o̐ڑ҂󂯃AhXݒ肷B<br>
     * w肵Ȃꍇ́A[JAhXB<br>
     *
     * @param address AhX
     */
    public void setServerAddress(String address);
    
    /**
     * T[o̐ڑ҂󂯃AhX擾B<br>
     *
     * @return AhX
     */
    public String getServerAddress();
    
    /**
     * T[o̐ڑ҂󂯃|[gԍݒ肷B<br>
     * ftHǵA0ŔCӂ̃|[gԍB<br>
     *
     * @param port |[gԍ
     */
    public void setServerPort(int port);
    
    /**
     * T[o̐ڑ҂󂯃|[gԍ擾B<br>
     *
     * @return |[gԍ
     */
    public int getServerPort();
    
    /**
     * T[o\Pbg̃obNOݒ肷B<br>
     * ftHg0B<br>
     * 
     * @param backlog obNO
     */
    public void setServerBacklog(int backlog);
    
    /**
     * T[o\Pbg̃obNO擾B<br>
     * 
     * @return obNO
     */
    public int getServerBacklog();
    
    /**
     * T[o\Pbgt@NgT[rX̃T[rXݒ肷B<br>
     *
     * @param name T[o\Pbgt@NgT[rX̃T[rX
     */
    public void setServerSocketFactoryServiceName(ServiceName name);
    
    /**
     * T[o\Pbgt@NgT[rX̃T[rX擾B<br>
     *
     * @return T[o\Pbgt@NgT[rX̃T[rX
     */
    public ServiceName getServerSocketFactoryServiceName();
    
    /**
     * \Pbgt@NgT[rX̃T[rXݒ肷B<br>
     *
     * @param name \Pbgt@NgT[rX̃T[rX
     */
    public void setSocketFactoryServiceName(ServiceName name);
    
    /**
     * \Pbgt@NgT[rX̃T[rX擾B<br>
     *
     * @return \Pbgt@NgT[rX̃T[rX
     */
    public ServiceName getSocketFactoryServiceName();
    
    /**
     * T[õ\Pbgjava.niogڑsꍇ̃T[õ\PbgɓKp\Pbgt@NgT[rX̃T[rXݒ肷B<br>
     *
     * @param name \Pbgt@NgT[rX̃T[rX
     */
    public void setNIOSocketFactoryServiceName(ServiceName name);
    
    /**
     * T[õ\Pbgjava.niogڑsꍇ̃T[õ\PbgɓKp\Pbgt@NgT[rX̃T[rX擾B<br>
     *
     * @return \Pbgt@NgT[rX̃T[rX
     */
    public ServiceName getNIOSocketFactoryServiceName();
    
    /**
     * T[õ\Pbgjava.niogڑsǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isNIO java.niogڑsꍇtrue
     */
    public void setNIO(boolean isNIO);
    
    /**
     * T[õ\Pbgjava.niogڑsǂ𔻒肷B<p>
     *
     * @return truȅꍇAjava.niogڑs
     */
    public boolean isNIO();
    
    /**
     * }`LXgzMsꍇ̑M|[gԍݒ肷B<p>
     * ftHǵA0ŔCӂ̃|[gԍB<br>
     * jLXgzMŃ|[gԍw肵ꍇ́ASẴNCAgɑ΂zM𓯂M\PbgŔzMB<br>
     * 
     * @param port M|[gԍ
     */
    public void setLocalPort(int port);
    
    /**
     * }`LXgzMsꍇ̑M|[gԍ擾B<p>
     * 
     * @return M|[gԍ
     */
    public int getLocalPort();
    
    /**
     * }`LXgzMsꍇ̔zMAhXݒ肷B<p>
     * }`LXgAhX܂́Au[hLXgAhXݒ肷Bݒ肵Ȃꍇ́AUDPjLXgzMƂȂB<br>
     * 
     * @param ip zMAhX
     */
    public void setMulticastGroupAddress(String ip);
    
    /**
     * }`LXgzMsꍇ̈AhX擾B<p>
     * 
     * @return AhX
     */
    public String getMulticastGroupAddress();
    
    /**
     * }`LXgzMsꍇ̈|[gԍݒ肷B<p>
     * ftHǵA2000B<br>
     * 
     * @param port |[gԍ
     */
    public void setMulticastPort(int port);
    
    /**
     * }`LXgzMsꍇ̈|[gԍ擾B<p>
     * 
     * @return |[gԍ
     */
    public int getMulticastPort();
    
    /**
     * }`LXgzMsꍇŁA}`LXgAhXw肵ꍇ́A}`LXgpPbg̗LԂݒ肷B<p>
     * ftHǵA1B<br>
     *
     * @param ttl }`LXgpPbg̗L
     */
    public void setTimeToLive(int ttl);
    
    /**
     * }`LXgzMsꍇŁA}`LXgAhXw肵ꍇ́A}`LXgpPbg̗LԂ擾B<p>
     *
     * @return }`LXgpPbg̗L
     */
    public int getTimeToLive();
    
    /**
     * jLXgzMsꍇ̈|[gԍݒ肷B<p>
     * ftHǵA0ŔCӂ̃|[gԍB<br>
     * 
     * @param port |[gԍ
     */
    public void setUnicastPort(int port);
    
    /**
     * jLXgzMsꍇ̈|[gԍ擾B<p>
     * 
     * @return |[gԍ
     */
    public int getUnicastPort();
    
    /**
     * UDPpPbg̃TCYݒ肷B<p>
     * ftHǵA1024[byte]B<br>
     *
     * @param bytes UDPpPbg̃TCY
     */
    public void setWindowSize(int bytes);
    
    /**
     * UDPpPbg̃TCY擾B<p>
     *
     * @return UDPpPbg̃TCY
     */
    public int getWindowSize();
    
    /**
     * MpPbg̃obt@Ԃݒ肷B<p>
     * MpPbgXgƔfɁAMɃXgpPbg₢킹ĕԂB<br>
     * ̂߂̑M̕ԗpMobt@ɁAMpPbg𑗐Mǂ̂炢̊ԎcĂݒ肷B<br>
     * MpPbgXgƔf鎞Ԃ́A{@link #setMissingWindowTimeout(long)}Őݒ肷邽߁A̎Ԃ蒷ݒ肷ׂłB<br>
     * ftHǵA5000[ms]B<br>
     *
     * @param time obt@[ms]
     */
    public void setSendBufferTime(long time);
    
    /**
     * MpPbg̃obt@Ԃ擾B<p>
     *
     * @return obt@[ms]
     */
    public long getSendBufferTime();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgJNDIݒ肷B<p>
     * ftHǵA{@link jp.ossc.nimbus.service.publish.ClientConnectionFactory#DEFAULT_JNDI_NAME}B<br>
     *
     * @param name JNDI
     */
    public void setJndiName(String name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgJNDI擾B<p>
     *
     * @return JNDI
     */
    public String getJndiName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name RepositoryT[rX̃T[rX
     */
    public void setJndiRepositoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rX擾B<p>
     * 
     * @return RepositoryT[rX̃T[rX
     */
    public ServiceName getJndiRepositoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgRMIʐM|[gԍݒ肷B<p>
     *
     * @param port |[gԍ
     */
    public void setRMIPort(int port);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgRMIʐM|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getRMIPort();
    
    /**
     * jLXgzM̏ꍇŁA{@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁAeM֕ɑMsXbh̐ݒ肷B<p>
     * ftHg1ŁAeM֒ɑMsB<br>
     *
     * @param threadSize Xbh
     */
    public void setSendThreadSize(int threadSize);
    
    /**
     * jLXgzM̏ꍇŁA{@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁAeM֕ɑMsXbh̐擾B<p>
     *
     * @return Xbh
     */
    public int getSendThreadSize();
    
    /**
     * jLXgzM̏ꍇŁA{@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁAeMւ̔zM񑗐M邽߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃T[rXݒ肷B<p>
     * {@link #setSendThreadSize(int)}ɁA2ȏw肵Ȃꍇ́A񑗐MȂ߁AQueue͎gpȂB<br>
     * 2ȏw肵ꍇŁȂw肵Ȃꍇ́AQueue𐶐B<br>
     *
     * @param name 񑗐MpQueueT[rX
     */
    public void setSendQueueServiceName(ServiceName name);
    
    /**
     * jLXgzM̏ꍇŁA{@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁAeMւ̔zM񑗐M邽߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃T[rX擾B<p>
     *
     * @return 񑗐MpQueueT[rX
     */
    public ServiceName getSendQueueServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁAeM֕ɑMsXbh̐ݒ肷B<p>
     * ftHg0ŁA񓯊MT|[gȂB<br>
     *
     * @param threadSize Xbh
     */
    public void setAsynchSendThreadSize(int threadSize);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁAeM֕ɑMsXbh̐擾B<p>
     *
     * @return Xbh
     */
    public int getAsynchSendThreadSize();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁA񑗐Ms߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃t@NgT[rXݒ肷B<p>
     * {@link #setAsynchSendThreadSize(int)}ɁA1ȏw肵Ȃꍇ́A񓯊MT|[gȂ߁AQueue͎gpȂB<br>
     * 1ȏw肵ꍇŁȂw肵Ȃꍇ́AQueue𐶐B<br>
     *
     * @param name 񑗐MpQueueT[rX
     */
    public void setAsynchSendQueueFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁA񑗐Ms߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃t@NgT[rX擾B<p>
     *
     * @return 񑗐MpQueueT[rX
     */
    public ServiceName getAsynchSendQueueFactoryServiceName();
    
    public void setRequestHandleQueueServiceName(ServiceName name);
    public ServiceName getRequestHandleQueueServiceName();
    
    public void setRequestHandleThreadSize(int threadSize);
    public int getRequestHandleThreadSize();
    
    /**
     * MɎsꍇɍđMs񐔂ݒ肷B<p>
     * ftHǵA0ōđMȂB<br>
     * 
     * @param count đM
     */
    public void setMaxSendRetryCount(int count);
    
    /**
     * MɎsꍇɍđMs񐔂擾B<p>
     *
     * @return đM
     */
    public int getMaxSendRetryCount();
    
    /**
     * MG[ꍇɏo͂郍ObZ[WIDݒ肷B<br>
     * ftHǵAȂŃOo͂ȂB<br>
     * 
     * @param id ObZ[WID
     */
    public void setServerSendErrorMessageId(String id);
    
    /**
     * MG[ꍇɏo͂郍ObZ[WID擾B<br>
     * 
     * @return ObZ[WID
     */
    public String getServerSendErrorMessageId();
    
    /**
     * MG[AK̃gC񐔃gCĂȂꍇɏo͂郍ObZ[WIDݒ肷B<br>
     * ftHǵAȂŃOo͂ȂB<br>
     * 
     * @param id ObZ[WID
     */
    public void setServerSendErrorRetryOverMessageId(String id);
    
    /**
     * MG[AK̃gC񐔃gCĂȂꍇɏo͂郍ObZ[WID擾B<br>
     * 
     * @return ObZ[WID
     */
    public String getServerSendErrorRetryOverMessageId();
    
    /**
     * NCAg̗vɉۂɁAMG[ꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public void setServerResponseErrorMessageId(String id);
    
    /**
     * NCAg̗vɉۂɁAMG[ꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getServerResponseErrorMessageId();
    
    /**
     * NCAg̕ԗvɉۂɁAvꂽbZ[WԂłȂꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public void setServerMessageLostErrorMessageId(String id);
    
    /**
     * NCAg̕ԗvɉۂɁAvꂽbZ[WԂłȂꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getServerMessageLostErrorMessageId();
    
    /**
     * T[oIꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public void setClientServerCloseMessageId(String id);
    
    /**
     * T[oIꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getClientServerCloseMessageId();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageListener#onMessage(jp.ossc.nimbus.service.publish.Message)}ŎMۂɁAMG[ꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public void setClientReceiveWarnMessageId(String id);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageListener#onMessage(jp.ossc.nimbus.service.publish.Message)}ŎMۂɁAMG[ꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getClientReceiveWarnMessageId();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageListener#onMessage(jp.ossc.nimbus.service.publish.Message)}ŎMۂɁAMG[AgCAEgꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public void setClientReceiveErrorMessageId(String id);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageListener#onMessage(jp.ossc.nimbus.service.publish.Message)}ŎMۂɁAMG[AgCAEgꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getClientReceiveErrorMessageId();
    
    /**
     * T[o̕ԉɗvbZ[W݂Ȃꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public void setClientMessageLostErrorMessageId(String id);
    
    /**
     * T[o̕ԉɗvbZ[W݂Ȃꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getClientMessageLostErrorMessageId();
    
    /**
     * bZ[W̒/񒼗񉻂Ɏgp{@link jp.ossc.nimbus.service.io.Externalizer Externalizer}T[rX̃T[rXݒ肷B<p>
     * w肵Ȃꍇ́Ajava.io.ObjectOutputStreamŃbZ[W̒/񒼗񉻂sB<br>
     *
     * @param name ExternalizerT[rX̃T[rX
     */
    public void setExternalizerServiceName(ServiceName name);
    
    /**
     * bZ[W̒/񒼗񉻂Ɏgp{@link jp.ossc.nimbus.service.io.Externalizer Externalizer}T[rX̃T[rX擾B<p>
     *
     * @return ExternalizerT[rX̃T[rX
     */
    public ServiceName getExternalizerServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnectionListener ServerConnectionListener}̃T[rXݒ肷B<p>
     *
     * @param names ServerConnectionListener̃T[rX̔z
     */
    public void setServerConnectionListenerServiceNames(ServiceName[] names);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnectionListener ServerConnectionListener}̃T[rX擾B<p>
     *
     * @return ServerConnectionListener̃T[rX̔z
     */
    public ServiceName[] getServerConnectionListenerServiceNames();
    
    /**
     * M擾B<p>
     *
     * @return M
     */
    public long getSendCount();
    
    /**
     * MpPbg擾B<p>
     *
     * @return MpPbg
     */
    public long getSendPacketCount();
    
    /**
     * őEBhE擾B<p>
     * bZ[W{@link #setWindowSize(int)}Ŏw肵oCg̃pPbgɕđMB
     * ̒PʂEBhEƌĂсȂ́A1bZ[W̃EBhEőƂȂlB<br>
     *
     * @return őEBhE
     */
    public int getMaxWindowCount();
    
    /**
     * σEBhE擾B<p>
     * bZ[W{@link #setWindowSize(int)}Ŏw肵oCg̃pPbgɕđMB
     * ̒PʂEBhEƌĂсȂ́A1bZ[W̃EBhE̕ϒlB<br>
     * ϒl1ɋ߂`ǂƌB<br>
     *
     * @return őEBhE
     */
    public double getAverageWindowCount();
    
    /**
     * MZbgB<p>
     */
    public void resetSendCount();
    
    /**
     * ϑMԂ擾B<p>
     *
     * @return ϑM[ms]
     */
    public long getAverageSendProcessTime();
    
    /**
     * ڑ̃NCAgjava.net.InetSocketAddress̏W擾B<br>
     *
     * @return NCAgjava.net.InetSocketAddress̏W
     */
    public Set<SocketAddress> getClients();
    
    /**
     * ڑ̃NCAg̐擾B<br>
     *
     * @return NCAg̐
     */
    public int getClientSize();
    
    /**
     * ڑ̃NCAgŔzMsΏۂƂȂNCAgjava.net.InetSocketAddress̏W擾B<br>
     *
     * @return NCAgjava.net.InetSocketAddress̏W
     */
    public Set<SocketAddress> getEnabledClients();
    
    /**
     * ڑ̃NCAgŔzMsȂΏۂƂȂNCAgjava.net.InetSocketAddress̏W擾B<br>
     *
     * @return NCAgjava.net.InetSocketAddress̏W
     */
    public Set<SocketAddress> getDisabledClients();
    
    /**
     * w肳ꂽAhXA|[gԍ̃NCAg̔zMLɂB<p>
     * |[gԍ̎w肪0ȉ̏ꍇ́A|[gԍ͔CӂƂ݂ȂB<br>
     *
     * @param address NCAg̃AhX܂̓zXg
     * @param port NCAg̃|[gԍ
     */
    public void enabledClient(String address, int port);
    
    /**
     * w肳ꂽAhXA|[gԍ̃NCAg̔zM𖳌ɂB<p>
     * |[gԍ̎w肪0ȉ̏ꍇ́A|[gԍ͔CӂƂ݂ȂB<br>
     *
     * @param address NCAg̃AhX܂̓zXg
     * @param port NCAg̃|[gԍ
     */
    public void disabledClient(String address, int port);
    
    /**
     * ڑ̃NCAg̑M擾B<br>
     *
     * @return NCAg̑MBL[NCAgjava.net.InetSocketAddressAlM̃}bv
     */
    public Map<SocketAddress,Long> getSendCountsByClient();
    
    /**
     * ڑ̃NCAg̕ϑMԂ擾B<br>
     *
     * @return NCAg̕ϑM[ms]BL[NCAgjava.net.InetSocketAddressAlϑMԂ̃}bv
     */
    public Map<SocketAddress,Long> getAverageSendProcessTimesByClient();
    
    /**
     * ڑ̃NCAg̑MZbgB<br>
     */
    public void resetSendCountsByClient();
    
    /**
     * ڑ̃NCAg̕ԗv擾B<br>
     *
     * @return NCAg̕ԗvBL[NCAgjava.net.InetSocketAddressAlԗṽ}bv
     */
    public Map<SocketAddress,Long> getInterpolateRequestCountsByClient();
    
    /**
     * ڑ̃NCAg̕ԗvZbgB<br>
     */
    public void resetInterpolateRequestCountsByClient();
    
    /**
     * w肳ꂽAhXA|[gԍ̃NCAgo^ĂTuWFNg擾B<p>
     *
     * @param address NCAg̃AhX܂̓zXg
     * @param port NCAg̃|[gԍ
     * @return TuWFNg̏W
     */
    public Set<String> getSubjects(String address, int port);
    
    /**
     * w肳ꂽAhXA|[gԍ̃NCAgAw肳ꂽTuWFNgɑ΂ēo^ĂL[擾B<p>
     *
     * @param address NCAg̃AhX܂̓zXg
     * @param port NCAg̃|[gԍ
     * @param subject TuWFNg
     * @return L[̏W
     */
    public Set<String> getKeys(String address, int port, String subject);
    
    /**
     * ԗpMobt@Ƀobt@Ă郁bZ[W̒ŁAłÂbZ[W̒ʔԂ擾B<p>
     *
     * @return bZ[Wʔ
     */
    public int getMostOldSendBufferSequence();
    
    /**
     * ԗpMobt@Ƀobt@Ă郁bZ[W̒ŁAłÂbZ[W̑M擾B<p>
     *
     * @return bZ[W̑M
     */
    public Date getMostOldSendBufferTime();
    
    /**
     * ԗpMobt@Ƀobt@Ă郁bZ[W̌擾B<p>
     *
     * @return bZ[W
     */
    public int getSendBufferSize();
    
    /**
     * 񓯊M̕Ϗ[ms]擾B<p>
     *
     * @return Ϗ[ms]
     */
    public long getAverageAsynchSendProcessTime();
    
    public long getAverageRequestHandleProcessTime();
}