/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.resource.jms;

import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.JMSException;

import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.ClosableResource;
import jp.ossc.nimbus.service.resource.ResourceException;

public class SessionResource
 implements TransactionResource<Session>, ClosableResource<Session>{
    
    private boolean isManaged;
    private boolean isTransacted;
    private Connection connection;
    private Session session;
    
    public SessionResource(
        Connection con,
        Session ss,
        boolean isManaged,
        boolean isTransacted
    ){
        connection = con;
        session = ss;
        this.isManaged = isManaged;
        this.isTransacted = isTransacted;
    }
    
    @Override
    public Session getResource(){
        return session;
    }
    
    public Connection getConnection(){
        return connection;
    }
    
    @Override
    public boolean isManaged(){
        return isManaged;
    }
    
    @Override
    public void commit() throws ResourceException{
        if(session != null && isTransacted){
            try{
                session.commit();
            }catch(JMSException e){
                throw new ResourceException(e);
            }
        }
    }
    
    @Override
    public void rollback() throws ResourceException{
        if(session != null && isTransacted){
            try{
                session.rollback();
            }catch(JMSException e){
                throw new ResourceException(e);
            }
        }
    }
    
    @Override
    public void close() throws ResourceException{
        if(session != null){
            try{
                session.close();
            }catch(JMSException e){
                throw new ResourceException(e);
            }finally{
                session = null;
                connection = null;
            }
        }
    }
}