/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.resource.sql;

import java.sql.Connection;
import java.sql.SQLException;

import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.ClosableResource;
import jp.ossc.nimbus.service.resource.ResourceException;

public class ConnectionResource
 implements TransactionResource<Connection>, ClosableResource<Connection>{
    
    private boolean isManaged;
    private Connection connection;
    
    public ConnectionResource(Connection con, boolean isManaged){
        connection = con;
        this.isManaged = isManaged;
    }
    
    @Override
    public Connection getResource(){
        return connection;
    }
    
    @Override
    public boolean isManaged(){
        return isManaged;
    }
    
    @Override
    public void commit() throws ResourceException{
        if(connection != null){
            try{
                connection.commit();
            }catch(SQLException e){
                throw new ResourceException(e);
            }
        }
    }
    
    @Override
    public void rollback() throws ResourceException{
        if(connection != null){
            try{
                connection.rollback();
            }catch(SQLException e){
                throw new ResourceException(e);
            }
        }
    }
    
    @Override
    public void close() throws ResourceException{
        if(connection != null){
            try{
                connection.close();
            }catch(SQLException e){
                throw new ResourceException(e);
            }finally{
                connection = null;
            }
        }
    }
}