/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.websocket;

import java.util.Map;
import java.util.HashMap;

import jp.ossc.nimbus.core.ServiceBase;

/**
 * ȈՃ`PbgF؃T[rXB<p>
 * `ɂAÓIɒ߂`Pbgƍv邩ɂāAF؂sȈՂȔF؃T[rXłB<br>
 *
 * @author M.Takata
 */
public class SimpleTicketAuthenticatorService extends ServiceBase implements Authenticator, SimpleTicketAuthenticatorServiceMBean{
    
    private static final long serialVersionUID = -4122061396478325526L;
    
    private Map<String,String> idAndTicketMapping;
    private String ticket;
    
    @Override
    public void setTicketMapping(String id, String ticket){
        if(idAndTicketMapping == null){
            idAndTicketMapping = new HashMap<String,String>();
        }
        idAndTicketMapping.put(id, ticket);
    }
    @Override
    public String getTicketMapping(String id){
        return idAndTicketMapping == null ? null : idAndTicketMapping.get(id);
    }
    @Override
    public Map<String, String> getTicketMappings(){
        return idAndTicketMapping;
    }
    
    @Override
    public void setTicket(String ticket){
        this.ticket = ticket;
    }
    @Override
    public String getTicket(){
        return ticket;
    }
    
    @Override
    public boolean login(String id, String ticket) throws AuthenticateException{
        String myTicket = this.ticket;
        if(idAndTicketMapping != null && idAndTicketMapping.containsKey(id)){
            myTicket = idAndTicketMapping.get(id);
        }
        if(myTicket == null && ticket == null){
            return true;
        }else if((myTicket == null && ticket != null)
                || (myTicket != null && ticket == null)){
            return false;
        }else{
            return myTicket.equals(ticket);
        }
    }
    
    @Override
    public void logout(String id, boolean isForce) throws AuthenticateException{
    }
}
