/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.sql;

import java.io.*;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.*;
import java.util.Map;
import java.util.Calendar;

/**
 * ResultSetbp[B<p>
 *
 * @author M.Takata
 */
public class ResultSetWrapper implements java.sql.ResultSet, Serializable{
    
    private static final long serialVersionUID = 6755628820571444793L;
    
    protected ResultSet resultSet;
    
    public ResultSetWrapper(ResultSet rs){
        resultSet = rs;
    }
    
    @Override
    public int getConcurrency() throws SQLException {
        return resultSet.getConcurrency();
    }
    
    @Override
    public int getFetchDirection() throws SQLException {
        return resultSet.getFetchDirection();
    }
    
    @Override
    public int getFetchSize() throws SQLException {
        return resultSet.getFetchSize();
    }
    
    @Override
    public int getRow() throws SQLException {
        return resultSet.getRow();
    }
    
    @Override
    public int getType() throws SQLException {
        return resultSet.getType();
    }
    
    @Override
    public void afterLast() throws SQLException {
        resultSet.afterLast();
    }
    
    @Override
    public void beforeFirst() throws SQLException {
        resultSet.beforeFirst();
    }
    
    @Override
    public void cancelRowUpdates() throws SQLException {
        resultSet.cancelRowUpdates();
    }
    
    @Override
    public void clearWarnings() throws SQLException {
        resultSet.clearWarnings();
    }
    
    @Override
    public void close() throws SQLException {
        resultSet.close();
    }
    
    @Override
    public void deleteRow() throws SQLException {
        resultSet.deleteRow();
    }
    
    @Override
    public void insertRow() throws SQLException {
        resultSet.insertRow();
    }
    
    @Override
    public void moveToCurrentRow() throws SQLException {
        resultSet.moveToCurrentRow();
    }
    
    @Override
    public void moveToInsertRow() throws SQLException {
        resultSet.moveToInsertRow();
    }
    
    @Override
    public void refreshRow() throws SQLException {
        resultSet.refreshRow();
    }
    
    @Override
    public void updateRow() throws SQLException {
        resultSet.updateRow();
    }
    
    @Override
    public boolean first() throws SQLException {
        return resultSet.first();
    }
    
    @Override
    public boolean isAfterLast() throws SQLException {
        return resultSet.isAfterLast();
    }
    
    @Override
    public boolean isBeforeFirst() throws SQLException {
        return resultSet.isBeforeFirst();
    }
    
    @Override
    public boolean isFirst() throws SQLException {
        return resultSet.isFirst();
    }
    
    @Override
    public boolean isLast() throws SQLException {
        return resultSet.isLast();
    }
    
    @Override
    public boolean last() throws SQLException {
        return resultSet.last();
    }
    
    @Override
    public boolean next() throws SQLException {
        return resultSet.next();
    }
    
    @Override
    public boolean previous() throws SQLException {
        return resultSet.previous();
    }
    
    @Override
    public boolean rowDeleted() throws SQLException {
        return resultSet.rowDeleted();
    }
    
    @Override
    public boolean rowInserted() throws SQLException {
        return resultSet.rowInserted();
    }
    
    @Override
    public boolean rowUpdated() throws SQLException {
        return resultSet.rowUpdated();
    }
    
    @Override
    public boolean wasNull() throws SQLException {
        return resultSet.wasNull();
    }
    
    @Override
    public byte getByte(int arg0) throws SQLException {
        return resultSet.getByte(arg0);
    }
    
    @Override
    public double getDouble(int arg0) throws SQLException {
        return resultSet.getDouble(arg0);
    }
    
    @Override
    public float getFloat(int arg0) throws SQLException {
        return resultSet.getFloat(arg0);
    }
    
    @Override
    public int getInt(int arg0) throws SQLException {
        return resultSet.getInt(arg0);
    }
    
    @Override
    public long getLong(int arg0) throws SQLException {
        return resultSet.getLong(arg0);
    }
    
    @Override
    public short getShort(int arg0) throws SQLException {
        return resultSet.getShort(arg0);
    }
    
    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        resultSet.setFetchDirection(arg0);
    }
    
    @Override
    public void setFetchSize(int arg0) throws SQLException {
        resultSet.setFetchSize(arg0);
    }
    
    @Override
    public void updateNull(int arg0) throws SQLException {
        resultSet.updateNull(arg0);
    }
    
    @Override
    public boolean absolute(int arg0) throws SQLException {
        return resultSet.absolute(arg0);
    }
    
    @Override
    public boolean getBoolean(int arg0) throws SQLException {
        return resultSet.getBoolean(arg0);
    }
    
    @Override
    public boolean relative(int arg0) throws SQLException {
        return resultSet.relative(arg0);
    }
    
    @Override
    public byte[] getBytes(int arg0) throws SQLException {
        return resultSet.getBytes(arg0);
    }
    
    @Override
    public void updateByte(int arg0, byte arg1) throws SQLException {
        resultSet.updateByte(arg0, arg1);
    }
    
    @Override
    public void updateDouble(int arg0, double arg1) throws SQLException {
        resultSet.updateDouble(arg0, arg1);
    }
    
    @Override
    public void updateFloat(int arg0, float arg1) throws SQLException {
        resultSet.updateFloat(arg0, arg1);
    }
    
    @Override
    public void updateInt(int arg0, int arg1) throws SQLException {
        resultSet.updateInt(arg0, arg1);
    }
    
    @Override
    public void updateLong(int arg0, long arg1) throws SQLException {
        resultSet.updateLong(arg0, arg1);
    }
    
    @Override
    public void updateShort(int arg0, short arg1) throws SQLException {
        resultSet.updateShort(arg0, arg1);
    }
    
    @Override
    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        resultSet.updateBoolean(arg0, arg1);
    }
    
    @Override
    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        resultSet.updateBytes(arg0, arg1);
    }
    
    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        return resultSet.getAsciiStream(arg0);
    }
    
    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        return resultSet.getBinaryStream(arg0);
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        return resultSet.getUnicodeStream(arg0);
    }
    
    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, int arg2)
            throws SQLException {
        resultSet.updateAsciiStream(arg0, arg1, arg2);
    }
    
    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, int arg2)
            throws SQLException {
        resultSet.updateBinaryStream(arg0, arg1, arg2);
    }
    
    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        return resultSet.getCharacterStream(arg0);
    }
    
    @Override
    public void updateCharacterStream(int arg0, Reader arg1, int arg2)
            throws SQLException {
        resultSet.updateCharacterStream(arg0, arg1, arg2);
    }
    
    @Override
    public Object getObject(int arg0) throws SQLException {
        return resultSet.getObject(arg0);
    }
    
    @Override
    public void updateObject(int arg0, Object arg1) throws SQLException {
        resultSet.updateObject(arg0, arg1);
    }
    
    @Override
    public void updateObject(int arg0, Object arg1, int arg2)
            throws SQLException {
        resultSet.updateObject(arg0, arg1, arg2);
    }
    
    @Override
    public String getCursorName() throws SQLException {
        return resultSet.getCursorName();
    }
    
    @Override
    public String getString(int arg0) throws SQLException {
        return resultSet.getString(arg0);
    }
    
    @Override
    public void updateString(int arg0, String arg1) throws SQLException {
        resultSet.updateString(arg0, arg1);
    }
    
    @Override
    public byte getByte(String arg0) throws SQLException {
        return resultSet.getByte(arg0);
    }
    
    @Override
    public double getDouble(String arg0) throws SQLException {
        return resultSet.getDouble(arg0);
    }
    
    @Override
    public float getFloat(String arg0) throws SQLException {
        return resultSet.getFloat(arg0);
    }
    
    @Override
    public int findColumn(String arg0) throws SQLException {
        return resultSet.findColumn(arg0);
    }
    
    @Override
    public int getInt(String arg0) throws SQLException {
        return resultSet.getInt(arg0);
    }
    
    @Override
    public long getLong(String arg0) throws SQLException {
        return resultSet.getLong(arg0);
    }
    
    @Override
    public short getShort(String arg0) throws SQLException {
        return resultSet.getShort(arg0);
    }
    
    @Override
    public void updateNull(String arg0) throws SQLException {
        resultSet.updateNull(arg0);
    }
    
    @Override
    public boolean getBoolean(String arg0) throws SQLException {
        return resultSet.getBoolean(arg0);
    }
    
    @Override
    public byte[] getBytes(String arg0) throws SQLException {
        return resultSet.getBytes(arg0);
    }
    
    @Override
    public void updateByte(String arg0, byte arg1) throws SQLException {
        resultSet.updateByte(arg0, arg1);
    }
    
    @Override
    public void updateDouble(String arg0, double arg1) throws SQLException {
        resultSet.updateDouble(arg0, arg1);
    }
    
    @Override
    public void updateFloat(String arg0, float arg1) throws SQLException {
        resultSet.updateFloat(arg0, arg1);
    }
    
    @Override
    public void updateInt(String arg0, int arg1) throws SQLException {
        resultSet.updateInt(arg0, arg1);
    }
    
    @Override
    public void updateLong(String arg0, long arg1) throws SQLException {
        resultSet.updateLong(arg0, arg1);
    }
    
    @Override
    public void updateShort(String arg0, short arg1) throws SQLException {
        resultSet.updateShort(arg0, arg1);
    }
    
    @Override
    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        resultSet.updateBoolean(arg0, arg1);
    }
    
    @Override
    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        resultSet.updateBytes(arg0, arg1);
    }
    
    @Override
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        return resultSet.getBigDecimal(arg0);
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        return resultSet.getBigDecimal(arg0, arg1);
    }
    
    @Override
    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        resultSet.updateBigDecimal(arg0, arg1);
    }
    
    @Override
    public URL getURL(int arg0) throws SQLException {
        return resultSet.getURL(arg0);
    }
    
    @Override
    public Array getArray(int arg0) throws SQLException {
        return resultSet.getArray(arg0);
    }
    
    @Override
    public void updateArray(int arg0, Array arg1) throws SQLException {
        resultSet.updateArray(arg0, arg1);
    }
    
    @Override
    public Blob getBlob(int arg0) throws SQLException {
        return resultSet.getBlob(arg0);
    }
    
    @Override
    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        resultSet.updateBlob(arg0, arg1);
    }
    
    @Override
    public Clob getClob(int arg0) throws SQLException {
        return resultSet.getClob(arg0);
    }
    
    @Override
    public void updateClob(int arg0, Clob arg1) throws SQLException {
        resultSet.updateClob(arg0, arg1);
    }
    
    @Override
    public Date getDate(int arg0) throws SQLException {
        return resultSet.getDate(arg0);
    }
    
    @Override
    public void updateDate(int arg0, Date arg1) throws SQLException {
        resultSet.updateDate(arg0, arg1);
    }
    
    @Override
    public Ref getRef(int arg0) throws SQLException {
        return resultSet.getRef(arg0);
    }
    
    @Override
    public void updateRef(int arg0, Ref arg1) throws SQLException {
        resultSet.updateRef(arg0, arg1);
    }
    
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return resultSet.getMetaData();
    }
    
    @Override
    public SQLWarning getWarnings() throws SQLException {
        return resultSet.getWarnings();
    }
    
    @Override
    public Statement getStatement() throws SQLException {
        return resultSet.getStatement();
    }
    
    @Override
    public Time getTime(int arg0) throws SQLException {
        return resultSet.getTime(arg0);
    }
    
    @Override
    public void updateTime(int arg0, Time arg1) throws SQLException {
        resultSet.updateTime(arg0, arg1);
    }
    
    @Override
    public Timestamp getTimestamp(int arg0) throws SQLException {
        return resultSet.getTimestamp(arg0);
    }
    
    @Override
    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        resultSet.updateTimestamp(arg0, arg1);
    }
    
    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        return resultSet.getAsciiStream(arg0);
    }
    
    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        return resultSet.getBinaryStream(arg0);
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        return resultSet.getUnicodeStream(arg0);
    }
    
    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, int arg2)
            throws SQLException {
        resultSet.updateAsciiStream(arg0, arg1, arg2);
    }
    
    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, int arg2)
            throws SQLException {
        resultSet.updateBinaryStream(arg0, arg1, arg2);
    }
    
    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        return resultSet.getCharacterStream(arg0);
    }
    
    @Override
    public void updateCharacterStream(String arg0, Reader arg1, int arg2)
            throws SQLException {
        resultSet.updateCharacterStream(arg0, arg1, arg2);
    }
    
    @Override
    public Object getObject(String arg0) throws SQLException {
        return resultSet.getObject(arg0);
    }
    
    @Override
    public void updateObject(String arg0, Object arg1) throws SQLException {
        resultSet.updateObject(arg0, arg1);
    }
    
    @Override
    public void updateObject(String arg0, Object arg1, int arg2)
            throws SQLException {
        resultSet.updateObject(arg0, arg1, arg2);
    }
    
    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        return resultSet.getObject(arg0, arg1);
    }
    
    @Override
    public String getString(String arg0) throws SQLException {
        return resultSet.getString(arg0);
    }
    
    @Override
    public void updateString(String arg0, String arg1) throws SQLException {
        resultSet.updateString(arg0, arg1);
    }
    
    @Override
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        return resultSet.getBigDecimal(arg0);
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        return resultSet.getBigDecimal(arg0, arg1);
    }
    
    @Override
    public void updateBigDecimal(String arg0, BigDecimal arg1)
            throws SQLException {
        resultSet.updateBigDecimal(arg0, arg1);
    }
    
    @Override
    public URL getURL(String arg0) throws SQLException {
        return resultSet.getURL(arg0);
    }
    
    @Override
    public Array getArray(String arg0) throws SQLException {
        return resultSet.getArray(arg0);
    }
    
    @Override
    public void updateArray(String arg0, Array arg1) throws SQLException {
        resultSet.updateArray(arg0, arg1);
    }
    
    @Override
    public Blob getBlob(String arg0) throws SQLException {
        return resultSet.getBlob(arg0);
    }
    
    @Override
    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        resultSet.updateBlob(arg0, arg1);
    }
    
    @Override
    public Clob getClob(String arg0) throws SQLException {
        return resultSet.getClob(arg0);
    }
    
    @Override
    public void updateClob(String arg0, Clob arg1) throws SQLException {
        resultSet.updateClob(arg0, arg1);
    }
    
    @Override
    public Date getDate(String arg0) throws SQLException {
        return resultSet.getDate(arg0);
    }
    
    @Override
    public void updateDate(String arg0, Date arg1) throws SQLException {
        resultSet.updateDate(arg0, arg1);
    }
    
    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        return resultSet.getDate(arg0, arg1);
    }
    
    @Override
    public Ref getRef(String arg0) throws SQLException {
        return resultSet.getRef(arg0);
    }
    
    @Override
    public void updateRef(String arg0, Ref arg1) throws SQLException {
        resultSet.updateRef(arg0, arg1);
    }
    
    @Override
    public Time getTime(String arg0) throws SQLException {
        return resultSet.getTime(arg0);
    }
    
    @Override
    public void updateTime(String arg0, Time arg1) throws SQLException {
        resultSet.updateTime(arg0, arg1);
    }
    
    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        return resultSet.getTime(arg0, arg1);
    }
    
    @Override
    public Timestamp getTimestamp(String arg0) throws SQLException {
        return resultSet.getTimestamp(arg0);
    }
    
    @Override
    public void updateTimestamp(String arg0, Timestamp arg1)
            throws SQLException {
        resultSet.updateTimestamp(arg0, arg1);
    }
    
    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        return resultSet.getTimestamp(arg0, arg1);
    }
    
    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        return resultSet.getObject(arg0, arg1);
    }
    
    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        return resultSet.getDate(arg0, arg1);
    }
    
    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        return resultSet.getTime(arg0, arg1);
    }
    
    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1)
            throws SQLException {
        return resultSet.getTimestamp(arg0, arg1);
    }
    
    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException{
        resultSet.updateAsciiStream(columnIndex, inputStream);
    }
    
    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException{
        resultSet.updateAsciiStream(columnIndex, inputStream, length);
    }
    
    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException{
        resultSet.updateAsciiStream(columnLabel, inputStream);
    }
    
    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException{
        resultSet.updateAsciiStream(columnLabel, inputStream, length);
    }
    
    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException{
        resultSet.updateBinaryStream(columnIndex, inputStream);
    }
    
    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException{
        resultSet.updateBinaryStream(columnIndex, inputStream, length);
    }
    
    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException{
        resultSet.updateBinaryStream(columnLabel, inputStream);
    }
    
    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException{
        resultSet.updateBinaryStream(columnLabel, inputStream, length);
    }
    
    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException{
        resultSet.updateBlob(columnIndex, inputStream);
    }
    
    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException{
        resultSet.updateBlob(columnIndex, inputStream, length);
    }
    
    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException{
        resultSet.updateBlob(columnLabel, inputStream);
    }
    
    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException{
        resultSet.updateBlob(columnLabel, inputStream, length);
    }
    
    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException{
        resultSet.updateCharacterStream(columnIndex, reader);
    }
    
    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException{
        resultSet.updateCharacterStream(columnIndex, reader, length);
    }
    
    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException{
        resultSet.updateCharacterStream(columnLabel, reader);
    }
    
    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException{
        resultSet.updateCharacterStream(columnLabel, reader, length);
    }
    
    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException{
        resultSet.updateClob(columnIndex, reader);
    }
    
    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException{
        resultSet.updateClob(columnIndex, reader, length);
    }
    
    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException{
        resultSet.updateClob(columnLabel, reader);
    }
    
    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException{
        resultSet.updateClob(columnLabel, reader, length);
    }
    
    @Override
    public String getNString(int columnIndex) throws SQLException{
        return resultSet.getNString(columnIndex);
    }
    
    @Override
    public String getNString(String columnLabel) throws SQLException{
        return resultSet.getNString(columnLabel);
    }
    
    @Override
    public void updateNString(int columnIndex, String value) throws SQLException{
        resultSet.updateNString(columnIndex, value);
    }
    
    @Override
    public void updateNString(String columnLabel, String value) throws SQLException{
        resultSet.updateNString(columnLabel, value);
    }
    
    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException{
        return resultSet.getNCharacterStream(columnIndex);
    }
    
    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException{
        return resultSet.getNCharacterStream(columnLabel);
    }
    
    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException{
        resultSet.updateNCharacterStream(columnIndex, reader);
    }
    
    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader, long length) throws SQLException{
        resultSet.updateNCharacterStream(columnIndex, reader, length);
    }
    
    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException{
        resultSet.updateNCharacterStream(columnLabel, reader);
    }
    
    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException{
        resultSet.updateNCharacterStream(columnLabel, reader, length);
    }
    
    @Override
    public NClob getNClob(int columnIndex) throws SQLException{
        return resultSet.getNClob(columnIndex);
    }
    
    @Override
    public NClob getNClob(String columnLabel) throws SQLException{
        return resultSet.getNClob(columnLabel);
    }
    
    @Override
    public void updateNClob(int columnIndex, NClob value) throws SQLException{
        resultSet.updateNClob(columnIndex, value);
    }
    
    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException{
        resultSet.updateNClob(columnIndex, reader);
    }
    
    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException{
        resultSet.updateNClob(columnIndex, reader, length);
    }
    
    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException{
        resultSet.updateNClob(columnLabel, nClob);
    }
    
    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException{
        resultSet.updateNClob(columnLabel, reader);
    }
    
    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException{
        resultSet.updateNClob(columnLabel, reader, length);
    }
    
    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException{
        return resultSet.getSQLXML(columnIndex);
    }
    
    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException{
        return resultSet.getSQLXML(columnLabel);
    }
    
    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException{
        resultSet.updateSQLXML(columnIndex, xmlObject);
    }
    
    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException{
        resultSet.updateSQLXML(columnLabel, xmlObject);
    }
    
    @Override
    public RowId getRowId(int columnIndex) throws SQLException{
        return resultSet.getRowId(columnIndex);
    }
    
    @Override
    public RowId getRowId(String columnLabel) throws SQLException{
        return resultSet.getRowId(columnLabel);
    }
    
    @Override
    public void updateRowId(int columnIndex, RowId value) throws SQLException{
        resultSet.updateRowId(columnIndex, value);
    }
    
    @Override
    public void updateRowId(String columnLabel, RowId value) throws SQLException{
        resultSet.updateRowId(columnLabel, value);
    }
    
    @Override
    public int getHoldability() throws SQLException{
        return resultSet.getHoldability() ;
    }
    
    @Override
    public boolean isClosed() throws SQLException{
        return resultSet.isClosed() ;
    }
    
    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException{
        return resultSet.isWrapperFor(iface);
    }
    
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException{
        return resultSet.unwrap(iface);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return resultSet.getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return resultSet.getObject(columnLabel, type);
    }
}
