/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util;

import java.util.*;

/**
 * NXɑ΂Cӂ̃IuWFNg̃}bsOc[B<p>
 * NXɑΉCӂ̃IuWFNgANX̌p֌W̃c[Ń}bsOĊǗB<br>
 * {@link #add(Class, Object)}ŃNXƔCӂ̃IuWFNg̃}bsOo^łB{@link #getValue(Class)}ŃNXw肷ƑΉIuWFNg擾łBŌΉIuWFNgƂ́Aw肵NXɈvNXɃ}bsOĂIuWFNgA܂́AvNXȂꍇ́Ao^ĂNX̒ōł߂p֌WɂX[p[NXɃ}bsOꂽIuWFNgwB܂AŌNXɂ́AC^tF[X܂܂B<br>
 * 
 * @author M.Takata
 */
public class ClassMappingTree<T> implements java.io.Serializable{
    
    private static final long serialVersionUID = 4471328701464216810L;
    
    private final TreeElement<T> rootElement;
    
    private final Map<Class<?>, TreeElement<T>> classMap = new HashMap<Class<?>, TreeElement<T>>();
    
    /**
     * null{@link java.lang.Object}NXɃ}bsOāA}bsOc[̃[gƂāÃNX̃CX^X𐶐B<p>
     */
    public ClassMappingTree(){
        this(null);
    }
    
    /**
     * w肳ꂽIuWFNg{@link java.lang.Object}NXɃ}bsOāA}bsOc[̃[gƂāÃNX̃CX^X𐶐B<p>
     *
     * @param root java.lang.ObjectNXɑΉIuWFNg
     */
    public ClassMappingTree(T root){
        rootElement = new TreeElement<T>(java.lang.Object.class, root);
        classMap.put(java.lang.Object.class, rootElement);
    }
    
    /**
     * NXƔCӂ̃IuWFNg̃}bsOo^B<p>
     *
     * @param clazz NXIuWFNg
     * @param value Cӂ̃IuWFNg
     */
    public void add(Class<?> clazz, T value){
        add(clazz, value, false);
    }
    
    /**
     * NXƔCӂ̃IuWFNg̃}bsOo^B<p>
     *
     * @param clazz NXIuWFNg
     * @param value Cӂ̃IuWFNg
     * @param replace ɓNXɑ΂ă}bsOꂽIuWFNgꍇɁAƒuꍇ́AtrueBNXɑ΂ă}bsOꂽIuWFNg𕡐eāAǉꍇ́Afalse
     */
    public void add(Class<?> clazz, T value, boolean replace){
        if(classMap.containsKey(clazz)){
            final TreeElement<T> element = classMap.get(clazz);
            if(replace){
                element.setTarget(value);
            }else{
                element.addTarget(value);
            }
        }else{
            TreeElement<T> element = new TreeElement<T>(clazz, value);
            final TreeElement<T> nearestParent
                 = rootElement.getNearestParentElement(clazz);
            if(nearestParent != null){
                if(nearestParent.hasChild()){
                    for(TreeElement<T> child : nearestParent.getChildElements()){
                        if(child.isChildOf(clazz)){
                            nearestParent.moveChild(element, child);
                        }
                    }
                }
                element = nearestParent.addChild(element);
            }
            classMap.put(clazz, element);
        }
    }
    
    /**
     * w肳ꂽNXɑΉIuWFNg擾B<p>
     * ŌΉIuWFNgƂ́Aw肵NXɈvNXɃ}bsOĂIuWFNgwB<br>
     * ΉIuWFNg݂ꍇɂ́Aŏɓo^ꂽIuWFNgԂB<br>
     *
     * @param clazz NXIuWFNg
     * @return w肳ꂽNXɑΉIuWFNg
     * @see #getValuesOf(Class)
     */
    public T getValueOf(Class<?> clazz){
        final List<T> values = getValueListOf(clazz);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }
    
    /**
     * w肳ꂽNXɑΉIuWFNgXg擾B<p>
     *
     * @param clazz NXIuWFNg
     * @return w肳ꂽNXɑΉIuWFNgXg
     */
    public List<T> getValueListOf(Class<?> clazz){
        if(classMap.containsKey(clazz)){
            return classMap.get(clazz).getTargets();
        }else{
            return null;
        }
    }
    
    /**
     * w肳ꂽNXɑΉIuWFNg擾B<p>
     * ŌΉIuWFNgƂ́Aw肵NXɈvNXɃ}bsOĂIuWFNgA܂́AvNXȂꍇ́Ao^ĂNX̒ōł߂p֌WɂX[p[NXɃ}bsOꂽIuWFNgwB<br>
     * ΉIuWFNg݂ꍇɂ́Aŏɓo^ꂽIuWFNgԂB<br>
     *
     * @param clazz NXIuWFNg
     * @return w肳ꂽNXɑΉIuWFNg
     * @see #getValues(Class)
     */
    public T getValue(Class<?> clazz){
        final List<T> values = getValueList(clazz);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }
    
    /**
     * w肳ꂽNXɑΉIuWFNgXg擾B<p>
     *
     * @param clazz NXIuWFNg
     * @return w肳ꂽNXɑΉIuWFNgXg
     */
    public List<T> getValueList(Class<?> clazz){
        if(clazz == null){
            return rootElement.getTargets();
        }
        if(classMap.containsKey(clazz)){
            return classMap.get(clazz).getTargets();
        }else{
            final TreeElement<T> nearestParent
                 = rootElement.getNearestParentElement(clazz);
            if(nearestParent == null){
                return rootElement.getTargets();
            }
            return nearestParent.getTargets();
        }
    }
    
    /**
     * w肳ꂽNXɃ}bsOĂwIuWFNg폜B<p>
     *
     * @param clazz NXIuWFNg
     * @param value Cӂ̃IuWFNg
     */
    public void remove(Class<?> clazz, T value){
        if(classMap.containsKey(clazz)){
            final TreeElement<T> removeElement
                 = classMap.get(clazz);
            removeElement.removeTarget(value);
            if(removeElement.getTargets().size() == 0){
                remove(clazz);
            }
        }
    }
    
    /**
     * w肳ꂽNXɃ}bsOĂSẴIuWFNg폜B<p>
     *
     * @param clazz NXIuWFNg
     */
    public void remove(Class<?> clazz){
        if(!Object.class.equals(clazz) && classMap.containsKey(clazz)){
            final TreeElement<T> removedElement
                 = classMap.remove(clazz);
            if(removedElement.parent != null){
                removedElement.parent.removeChild(removedElement);
            }
        }
    }
    
    /**
     * }bsOĂSẴIuWFNg폜B<p>
     */
    public void clear(){
        final Set<Class<?>> classes = new HashSet<Class<?>>(classMap.keySet());
        for(Class<?> clazz : classes){
            remove(clazz);
        }
    }
    
    /**
     * o^ĂNX}bsO̕\ԂB<p>
     *
     * @return NX}bsO̕\
     */
    public String toString(){
        return super.toString() + classMap;
    }
    
    private static class TreeElement<T> implements java.io.Serializable{
        
        private static final long serialVersionUID = 4875545362697617699L;
        
        TreeElement<T> parent;
        private Map<Class<?>, TreeElement<T>> children;
        Class<?> clazz;
        private List<T> targets = new ArrayList<T>();
        public TreeElement(Class<?> clazz, T target){
            this(null, clazz, target);
        }
        public TreeElement(TreeElement<T> parent, Class<?> clazz, T target){
            this.parent = parent;
            this.clazz = clazz;
            setTarget(target);
        }
        public TreeElement<T> addChild(TreeElement<T> child){
            if(children == null){
                children = new HashMap<Class<?>, TreeElement<T>>();
            }
            if(children.containsKey(child.clazz)){
                final TreeElement<T> element
                     = children.get(child.clazz);
                element.addTargets(child.getTargets());
                return element;
            }else{
                children.put(child.clazz, child);
                child.parent = this;
                return child;
            }
        }
        @SuppressWarnings("unused")
		public TreeElement<T> getChild(Class<?> clazz){
            if(children == null){
                return null;
            }
            return children.get(clazz);
        }
        public Collection<TreeElement<T>> getChildElements(){
            return children == null ? null : new HashSet<TreeElement<T>>(children.values());
        }
        @SuppressWarnings("unused")
		public int childrenNumber(){
            return children == null ? 0 : children.size();
        }
        public void moveChild(TreeElement<T> newParent, TreeElement<T> child){
            children.remove(child.clazz);
            newParent.addChild(child);
        }
        public void removeChild(TreeElement<T> child){
            final TreeElement<T> removedChild
                 = children.remove(child.clazz);
            if(removedChild != null && removedChild.hasChild()
                && parent != null && parent.children != null){
                parent.children.putAll(removedChild.children);
            }
        }
        public void setTarget(T target){
            targets.clear();
            if(target != null){
                targets.add(target);
            }
        }
        public void addTarget(T target){
            if(target != null){
                targets.add(target);
            }
        }
        public void addTargets(List<T> targets){
            targets.addAll(targets);
        }
        public List<T> getTargets(){
            return targets;
        }
        public void removeTarget(T target){
            targets.remove(target);
        }
        public boolean hasChild(){
            return children != null && children.size() != 0;
        }
        public TreeElement<T> getNearestParentElement(Class<?> clazz){
            if(!isParentOf(clazz)){
                return null;
            }
            if(!hasChild()){
                return this;
            }
            TreeElement<T> nearestElement = null;
            for(TreeElement<T> element : children.values()){
                nearestElement = element.getNearestParentElement(clazz);
                if(nearestElement != null){
                    return nearestElement;
                }
            }
            return this;
        }
        public boolean isChildOf(Class<?> clazz){
            return clazz.isAssignableFrom(this.clazz);
        }
        public boolean isParentOf(Class<?> clazz){
            return this.clazz.isAssignableFrom(clazz);
        }
        @SuppressWarnings("unused")
		public T getTarget(){
            return targets.size() == 0 ? null : targets.get(0);
        }
        @SuppressWarnings("unchecked")
        @Override
        public boolean equals(Object obj){
            if(obj == null){
                return false;
            }
            if(obj == this){
                return true;
            }
            if(!(obj instanceof TreeElement)){
                return false;
            }
            final TreeElement<T> element = (TreeElement<T>)obj;
            if(clazz == null){
                return element.clazz == null;
            }
            return clazz.equals(element.clazz);
        }
        @Override
        public int hashCode(){
            return clazz == null ? 0 : clazz.hashCode();
        }
        @Override
        public String toString(){
            return targets.toString();
        }
    }
}
