/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

/**
 * J^JiЂ炪ȃRo[^B<p>
 * <table border=5 align=center>
 *     <tr><th>J^Ji</th><th>Ђ炪</th></tr>
 *     <tr><td>A</td><td></td></tr>
 *     <tr><td>@</td><td></td></tr>
 *     <tr><td>C</td><td></td></tr>
 *     <tr><td>B</td><td></td></tr>
 *     <tr><td>E</td><td></td></tr>
 *     <tr><td>D</td><td></td></tr>
 *     <tr><td>G</td><td></td></tr>
 *     <tr><td>F</td><td></td></tr>
 *     <tr><td>I</td><td></td></tr>
 *     <tr><td>H</td><td></td></tr>
 *     <tr><td>J</td><td></td></tr>
 *     <tr><td>K</td><td></td></tr>
 *     <tr><td>L</td><td></td></tr>
 *     <tr><td>M</td><td></td></tr>
 *     <tr><td>N</td><td></td></tr>
 *     <tr><td>O</td><td></td></tr>
 *     <tr><td>P</td><td></td></tr>
 *     <tr><td>Q</td><td></td></tr>
 *     <tr><td>R</td><td></td></tr>
 *     <tr><td>S</td><td></td></tr>
 *     <tr><td>T</td><td></td></tr>
 *     <tr><td>U</td><td></td></tr>
 *     <tr><td>V</td><td></td></tr>
 *     <tr><td>W</td><td></td></tr>
 *     <tr><td>X</td><td></td></tr>
 *     <tr><td>Y</td><td></td></tr>
 *     <tr><td>Z</td><td></td></tr>
 *     <tr><td>[</td><td></td></tr>
 *     <tr><td>\</td><td></td></tr>
 *     <tr><td>]</td><td></td></tr>
 *     <tr><td>^</td><td></td></tr>
 *     <tr><td>_</td><td></td></tr>
 *     <tr><td>`</td><td></td></tr>
 *     <tr><td>a</td><td></td></tr>
 *     <tr><td>b</td><td></td></tr>
 *     <tr><td>c</td><td></td></tr>
 *     <tr><td>d</td><td></td></tr>
 *     <tr><td>e</td><td></td></tr>
 *     <tr><td>f</td><td></td></tr>
 *     <tr><td>g</td><td></td></tr>
 *     <tr><td>h</td><td></td></tr>
 *     <tr><td>i</td><td></td></tr>
 *     <tr><td>j</td><td></td></tr>
 *     <tr><td>k</td><td></td></tr>
 *     <tr><td>l</td><td></td></tr>
 *     <tr><td>m</td><td></td></tr>
 *     <tr><td>n</td><td></td></tr>
 *     <tr><td>o</td><td></td></tr>
 *     <tr><td>p</td><td></td></tr>
 *     <tr><td>q</td><td></td></tr>
 *     <tr><td>r</td><td></td></tr>
 *     <tr><td>s</td><td></td></tr>
 *     <tr><td>t</td><td></td></tr>
 *     <tr><td>u</td><td></td></tr>
 *     <tr><td>v</td><td></td></tr>
 *     <tr><td>w</td><td></td></tr>
 *     <tr><td>x</td><td></td></tr>
 *     <tr><td>y</td><td></td></tr>
 *     <tr><td>z</td><td></td></tr>
 *     <tr><td>{</td><td></td></tr>
 *     <tr><td>|</td><td></td></tr>
 *     <tr><td>}</td><td></td></tr>
 *     <tr><td>~</td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td>R</td><td>T</td></tr>
 *     <tr><td>S</td><td>U</td></tr>
 * </table>
 * 
 * @author M.Takata
 */
public class KatakanaHiraganaStringConverter extends AbstractStringConverter
 implements java.io.Serializable{
    
    private static final long serialVersionUID = 2095171984891385726L;
    
    /**
     * J^JiЂ炪ȕϊ\ϊʒ萔B<p>
     */
    public static final int KATAKANA_TO_HIRAGANA = POSITIVE_CONVERT;
    
    /**
     * Ђ炪ȁJ^Jiϊ\ϊʒ萔B<p>
     */
    public static final int HIRAGANA_TO_KATAKANA = REVERSE_CONVERT;
    
    /**
     * J^JiЂ炪ȕϊʂ̃J^JiЂ炪ȃRo[^𐶐B<p>
     */
    public KatakanaHiraganaStringConverter(){
        super(KATAKANA_TO_HIRAGANA);
    }
    
    /**
     * J^JiЂ炪ȃRo[^𐶐B<p>
     *
     * @param type ϊ
     * @see #KATAKANA_TO_HIRAGANA
     * @see #HIRAGANA_TO_KATAKANA
     */
    public KatakanaHiraganaStringConverter(int type){
        super(type);
    }
    
    /**
     * ϊLN^z擾B<p>
     *
     * @return {@link KatakanaHiraganaCharacterConverter#CONV_CHARS}
     */
    @Override
    protected char[][] getConvertChars(){
        return KatakanaHiraganaCharacterConverter.CONV_CHARS;
    }
    
    /**
     * ϊz擾B<p>
     *
     * @return null
     */
    @Override
    protected String[][] getConvertStrings(){
        return null;
    }
}
