/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans.dataset;

import java.util.List;

/**
 * lXg{@link Record}̃vpeB̃XL[}`B<p>
 * ̃NXɂ́AvpeB̃XL[}ƂāAȉ̏񂪒`łB<br>
 * <ul>
 *   <li>O</li>
 *   <li>lXgR[h</li>
 *   <li>^</li>
 * </ul>
 * vpeBXL[}`̃tH[}bǵA<br>
 * <pre>
 *    O,lXgR[h,^
 * </pre>
 * ƂȂĂA^ȊO͑SĕK{łB<br>
 * <p>
 * ɁAeڂ̏ڍׂB<br>
 * <p>
 * ÓAvpeB̖OӖA{@link Record R[h}vpeBl擾ۂ̃L[ƂȂB<br>
 * <p>
 * lXgR[h́AlXgꂽRecord̖OŁA{@link DataSet#setNestedRecordSchema(String, String)}Őݒ肵R[hw肷B<br>
 * <p>
 * ^́AvpeB̌^ӖAJavåSCNXŎw肷B<br>
 * 
 * @author M.Takata
 */
public class RecordPropertySchema implements PropertySchema, java.io.Serializable{
    
    private static final long serialVersionUID = -6689975898690899203L;
    
    /**
     * XL[}B<p>
     */
    protected String schema;
    
    /**
     * vpeB̖OB<p>
     */
    protected String name;
    
    /**
     * lXgR[hB<p>
     */
    protected String recordName;
    
    /**
     * vpeB̌^B<p>
     */
    protected Class<?> type = Record.class;
    
    /**
     * ̃vpeBXL[}𐶐B<p>
     */
    public RecordPropertySchema(){
    }
    
    /**
     * vpeBXL[}𐶐B<p>
     *
     * @param schema vpeB̃XL[}`
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public RecordPropertySchema(String schema) throws PropertySchemaDefineException{
        setSchema(schema);
    }
    
    /**
     * vpeB̃XL[}`ݒ肷B<p>
     *
     * @param schema vpeB̃XL[}`
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    @Override
    public void setSchema(String schema) throws PropertySchemaDefineException{
        final List<String> schemata = DefaultPropertySchema.parseCSV(schema);
        if(schemata.size() < 2){
            throw new PropertySchemaDefineException("Name and Schema must be specified.");
        }
        this.schema = schema;
        name = schemata.get(0);
        recordName = schemata.get(1);
        if(schemata.size() > 2){
            parseType(schema, schemata.get(2));
        }
    }
    
    /**
     * vpeBXL[}̌^̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseType(String schema, String val)
     throws PropertySchemaDefineException{
        if(val != null && val.length() != 0){
            try{
                type = jp.ossc.nimbus.core.Utility.convertStringToClass(val, false);
            }catch(ClassNotFoundException e){
                throw new PropertySchemaDefineException(
                    schema,
                    "The type is illegal.",
                    e
                );
            }
        }
    }
    
    // PropertySchemaJavaDoc
    @Override
    public String getSchema(){
        return schema;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public String getName(){
        return name;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Class<?> getType(){
        return type;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public boolean isPrimaryKey(){
        return false;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object set(Object val) throws PropertySetException{
        if(val == null){
            return null;
        }
        if(!(val instanceof Record)){
            throw new PropertySchemaCheckException(
                this,
                "The type is unmatch. type=" + val.getClass().getName()
            );
        }
        return val;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object get(Object val) throws PropertyGetException{
        return val;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object format(Object val) throws PropertyGetException{
        return val;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object parse(Object val) throws PropertySetException{
        return val;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public boolean validate(Object val) throws PropertyValidateException{
        if(val != null && val instanceof Record){
            return ((Record)val).validate();
        }
        return true;
    }
        
    /**
     * lXgR[h擾B<p>
     *
     * @return lXgR[h
     */
    public String getRecordName(){
        return recordName;
    }
    
    /**
     * ̃XL[}̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        final StringBuilder buf = new StringBuilder(getClass().getName());
        buf.append('{');
        buf.append("name=").append(name);
        buf.append(",recordName=").append(recordName);
        buf.append(",type=").append(type);
        buf.append('}');
        return buf.toString();
    }
}
