/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;

/**
 * {@link MethodJournalInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MethodJournalInterceptorService
 */
public interface MethodJournalInterceptorServiceMBean extends ServiceBaseMBean{
    
    /**
     * W[iJñftHg̃W[iL[B<p>
     */
    public static final String DEFAULT_REQUEST_JOURNAL_KEY = "Request";
    
    /**
     * \bhĂяõftHg̃W[iL[B<p>
     */
    public static final String DEFAULT_METHOD_CALL_JOURNAL_KEY
         = "MethodCall";
    
    /**
     * \bh߂莞̃ftHg̃W[iL[B<p>
     */
    public static final String DEFAULT_METHOD_RETURN_JOURNAL_KEY
         = "MethodReturn";
    
    /**
     * NGXgID擾{@link jp.ossc.nimbus.service.context.Context}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     * @see #getThreadContextServiceName()
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * NGXgID擾{@link jp.ossc.nimbus.service.context.Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     * @see #setThreadContextServiceName(ServiceName)
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * ContextT[rXɐݒ肳ꂽNGXgID̃L[ݒ肷B<p>
     *
     * @param key NGXgID̃L[
     * @see #getRequestIdKey()
     */
    public void setRequestIdKey(String key);
    
    /**
     * ContextT[rXɐݒ肳ꂽNGXgID̃L[擾B<p>
     *
     * @return NGXgID̃L[
     * @see #setRequestIdKey(String)
     */
    public String getRequestIdKey();
    
    /**
     * {@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JournalT[rX̃T[rX
     * @see #getJournalServiceName()
     */
    public void setJournalServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rX擾B
     *
     * @return JournalT[rX̃T[rX
     * @see #setJournalServiceName(ServiceName)
     */
    public ServiceName getJournalServiceName();
    
    /**
     * W[iJñW[iҏWɎgp{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name EditorFinderT[rX̃T[rX
     * @see #getEditorFinderServiceName()
     */
    public void setEditorFinderServiceName(ServiceName name);
    
    /**
     * W[iJñW[iҏWɎgp{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rX擾B<p>
     *
     * @return EditorFinderT[rX̃T[rX
     * @see #setEditorFinderServiceName(ServiceName)
     */
    public ServiceName getEditorFinderServiceName();
    
    /**
     * o͂W[ĩ[gvf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#startJournal(String)}̈ƂĎgpB<br>
     * ܂Aw肵Ȃꍇ́A"Request"gpB<br>
     *
     * @param key o͂W[ĩ[gvf̃L[
     * @see #getRequestJournalKey()
     */
    public void setRequestJournalKey(String key);
    
    /**
     * o͂W[ĩ[gvf̃L[擾B<p>
     *
     * @return o͂W[ĩ[gvf̃L[
     * @see #setRequestJournalKey(String)
     */
    public String getRequestJournalKey();
        
    /**
     * o͂W[ĩ\bhĂяovf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#addInfo(String, Object)}̑ƂĎgpB<br>
     * ܂Aw肵Ȃꍇ́A"MethodCall"gpB<br>
     *
     * @param key o͂W[ĩ\bhĂяovf̃L[
     * @see #getMethodCallJournalKey()
     */
    public void setMethodCallJournalKey(String key);
    
    /**
     * o͂W[ĩ\bhĂяovf̃L[擾B<p>
     *
     * @return o͂W[ĩ\bhĂяovf̃L[
     * @see #setMethodCallJournalKey(String)
     */
    public String getMethodCallJournalKey();
    
    /**
     * o͂W[ĩ\bh߂vf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#addInfo(String, Object)}̑ƂĎgpB<br>
     * ܂Aw肵Ȃꍇ́A"MethodReturn"gpB<br>
     *
     * @param key o͂W[ĩ\bh߂vf̃L[
     * @see #getMethodReturnJournalKey()
     */
    public void setMethodReturnJournalKey(String key);
    
    /**
     * o͂W[ĩ\bh߂vf̃L[擾B<p>
     *
     * @return o͂W[ĩ\bh߂vf̃L[
     * @see #setMethodReturnJournalKey(String)
     */
    public String getMethodReturnJournalKey();
    
    /**
     * W[io͂sǂݒ肷B<p>
     * ftHgł́AtrueB
     *
     * @param enable W[io͂sꍇtrue
     * @see #isEnabled()
     */
    public void setEnabled(boolean enable);
    
    /**
     * W[io͂sǂ𔻒肷B<p>
     *
     * @return W[io͂sꍇtrue
     * @see #setEnabled(boolean)
     */
    public boolean isEnabled();
    
    /**
     * \bhĂяoɕʉ߂ꍇɁA2ڈȍ~̃W[iL^Ȃǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isBlock L^Ȃꍇ́Atrue
     */
    public void setBushingCallBlock(boolean isBlock);
    
    /**
     * \bhĂяoɕʉ߂ꍇɁA2ڈȍ~̃W[iL^Ȃǂ𔻒肷B<p>
     *
     * @return truȅꍇ́AL^Ȃ
     */
    public boolean isBushingCallBlock();
}
