/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import jp.ossc.nimbus.core.*;

/**
 * {@link JMSSessionFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see JMSSessionFactoryService
 */
public interface JMSSessionFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * AcknowledgeMode̐ݒl ACK[hB<p>
     */
    public static final String AUTO_ACKNOWLEDGE = "AUTO_ACKNOWLEDGE";
    
    /**
     * AcknowledgeMode̐ݒl NCAgACK[hB<p>
     */
    public static final String CLIENT_ACKNOWLEDGE = "CLIENT_ACKNOWLEDGE";
    
    /**
     * AcknowledgeMode̐ݒl deACK[hB<p>
     */
    public static final String DUPS_OK_ACKNOWLEDGE = "DUPS_OK_ACKNOWLEDGE";
    
    /**
     * JMSZbVǗ邩ǂݒ肷B<p>
     * trueݒ肵ꍇAJMSZbV́ÃT[rXɂĕێĂAT[rX̒~ƋJMSZbV̏IsB
     * \[X̊JRh߂̋@\łB<br>
     * ftHǵAfalseB<br>
     *
     * @param isManaged JMSZbVǗꍇtrue
     */
    public void setSessionManagement(boolean isManaged);
    
    /**
     * JMSZbVǗ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAJMSZbVǗ
     */
    public boolean isSessionManagement();
    
    /**
     * {@link JMSConnectionFactory}T[rX̃T[rXݒ肷B<p>
     * ConnectionCreatetruȅꍇAT[rX̊JnɁAŐݒ肳ꂽJMSConnectionFactoryT[rXgāAConnection𐶐ێB<br>
     *
     * @param name JMSConnectionFactoryT[rX̃T[rX
     */
    public void setJMSConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link JMSConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getJMSConnectionFactoryServiceName();
    
    /**
     * T[rX̊JnConnection𐶐ĕێ邩ǂݒ肷B<p>
     * trueݒ肷ꍇAJMSConnectionFactoryServiceNameݒ肵Ȃ΂ȂȂB<br>
     * ftHǵAtrueB<br>
     *
     * @param isCreate T[rX̊JnConnection𐶐ĕێꍇtrue
     */
    public void setConnectionCreate(boolean isCreate);
    
    /**
     * T[rX̊JnConnection𐶐ĕێ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAT[rX̊JnConnection𐶐ĕێ
     */
    public boolean isConnectionCreate();
    
    /**
     * Connection̊Jn邩ǂݒ肷B<p>
     * Connectionێꍇ́AT[rX̊JnɊJn邩ǂݒ肷B<br>
     * ConnectionێȂꍇ́ASession𐶐鎞ɊJn邩ǂݒ肷B<br>
     * ftHǵAfalseB<br>
     *
     * @param isStart Connection̊Jnꍇtrue
     */
    public void setStartConnection(boolean isStart);
    
    /**
     * Connection̊Jn邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAConnection̊Jn
     */
    public boolean isStartConnection();
    
    /**
     * T[rX̒~ɕێĂConnection̒~邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isStop T[rX̒~ɕێĂConnection̒~ꍇtrue
     */
    public void setStopConnection(boolean isStop);
    
    /**
     * T[rX̒~ɕێĂConnection̒~邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAT[rX̒~ɕێĂConnection̒~
     */
    public boolean isStopConnection();
    
    /**
     * T[rX̒~ɕێĂConnectioñN[Y邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isClose T[rX̒~ɕێĂConnectioñN[Yꍇtrue
     */
    public void setCloseConnection(boolean isClose);
    
    /**
     * T[rX̒~ɕێĂConnectioñN[Y邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAT[rX̒~ɕێĂConnectioñN[Y
     */
    public boolean isCloseConnection();
    
    /**
     * MessageConsumerJMSNCAgbZ[WMACK̕Ԃ̃[hݒ肷B<p>
     * ftHǵA{@link #AUTO_ACKNOWLEDGE}B<br>
     *
     * @param mode ACK̕Ԃ̃[h
     * @see #AUTO_ACKNOWLEDGE
     * @see #CLIENT_ACKNOWLEDGE
     * @see #DUPS_OK_ACKNOWLEDGE
     */
    public void setAcknowledgeMode(String mode);
    
    /**
     * MessageConsumerJMSNCAgbZ[WMACK̕Ԃ̃[h擾B<p>
     *
     * @return ACK̕Ԃ̃[h
     */
    public String getAcknowledgeMode();
    
    /**
     * gUNVT|[g邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isTransacted gUNVT|[gꍇAtrue
     */
    public void setTransactionMode(boolean isTransacted);
    
    /**
     * gUNVT|[g邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAgUNVT|[g
     */
    public boolean getTransactionMode();
}
