/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.lang.reflect.Array;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.EditorFinder;

/**
 * IuWFNgtH[}bgGfB^B<p>
 * nꂽIuWFNǧ^āA{@link EditorFinder}ɐݒ肳ꂽA^ƃGfB^̃}bsOgāA𑼂̃GfB^ɈϏāǍ{@link Object#toString()}ĂŕɂB܂AnꂽIuWFNǧ^z^̏ꍇAevfɑ΂ēl̏sA','ŋ؂ɘAB<br>
 * EditorFinderŃGfB^ĂȂꍇɂ́A{@link Object#toString()}ĂŕɂB<br>
 * 
 * @author M.Takata
 */
public class ObjectJournalEditorService extends ServiceBase
 implements JournalEditor, ObjectJournalEditorServiceMBean{
    
    private static final long serialVersionUID = 7578630921939702576L;
    
    public Object toObject(EditorFinder finder, String key, Object value){
        final StringBuilder buf = new StringBuilder();
        if(value == null){
            return "null";
        }
        if(value.getClass().isArray()){
            return toArrayString(finder, key, value, buf);
        }
        final JournalEditor editor = finder.findEditor(key, value.getClass());
        if(editor != null && editor != this){
            final Object obj = editor.toObject(finder, key, value);
            return buf.append(obj != null ? obj.toString() : null).toString();
        }else{
            return buf.append(value.toString()).toString();
        }
    }
    
    protected String toArrayString(
        EditorFinder finder,
        String key,
        Object values,
        StringBuilder buf
    ){
        if(values == null){
            return "null";
        }
        
        buf.append('[');
        for(int i = 0, max = Array.getLength(values); i < max; i++){
            Object value = Array.get(values, i);
            if(value != null){
                final JournalEditor editor = finder.findEditor(key, value);
                if(editor != null){
                    value = editor.toObject(finder, key, value);
                }else{
                    value = value.toString();
                }
            }
            buf.append(value);
            if(i != max - 1){
                buf.append(',');
            }
        }
        buf.append(']');
        return buf.toString();
    }
}